package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Contract_StrikePrice;
import drr.regulation.common.functions.GetPriceNotation;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;


@ImplementedBy(CDEStrikePriceNotationEnumRule.CDEStrikePriceNotationEnumRuleDefault.class)
public abstract class CDEStrikePriceNotationEnumRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Contract_StrikePrice contract_StrikePrice;
	@Inject protected GetPriceNotation getPriceNotation;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class CDEStrikePriceNotationEnumRuleDefault extends CDEStrikePriceNotationEnumRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			output = MapperS.of(MapperC.of(contract_StrikePrice.evaluate(input)).get())
				.mapSingleToItem(item -> MapperS.of(getPriceNotation.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
