package drr.standards.iso.upi.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.standards.iso.upi.AnnaDsbReturnUnderlierIDSourceEnum;
import drr.standards.iso.upi.AnnaDsbUnderlierIDSourceEnum;
import drr.standards.iso.upi.AnnaDsbUnderlyingRecord;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class AnnaDsbUnderlyingRecordValidator implements Validator<AnnaDsbUnderlyingRecord> {

	private List<ComparisonResult> getComparisonResults(AnnaDsbUnderlyingRecord o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("UnderlierIDSource", (AnnaDsbUnderlierIDSourceEnum) o.getUnderlierIDSource() != null ? 1 : 0, 1, 1), 
				checkCardinality("UnderlierID", (String) o.getUnderlierID() != null ? 1 : 0, 1, 1), 
				checkCardinality("ReturnUnderlierID", (List<String>) o.getReturnUnderlierID() == null ? 0 : o.getReturnUnderlierID().size(), 1, 0), 
				checkCardinality("ReturnUnderlierIDSource", (AnnaDsbReturnUnderlierIDSourceEnum) o.getReturnUnderlierIDSource() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, AnnaDsbUnderlyingRecord o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("AnnaDsbUnderlyingRecord", ValidationResult.ValidationType.CARDINALITY, "AnnaDsbUnderlyingRecord", path, "", res.getError());
				}
				return success("AnnaDsbUnderlyingRecord", ValidationResult.ValidationType.CARDINALITY, "AnnaDsbUnderlyingRecord", path, "");
			})
			.collect(toList());
	}

}
