package drr.standards.iso.upi.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.standards.iso.upi.AnnaDsbCategory;
import drr.standards.iso.upi.AnnaDsbRateGroup;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class AnnaDsbCategoryOnlyExistsValidator implements ValidatorWithArg<AnnaDsbCategory, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends AnnaDsbCategory> ValidationResult<AnnaDsbCategory> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("Swaps", ExistenceChecker.isSet((AnnaDsbRateGroup) o.getSwaps()))
				.put("NonListedAndComplexListedOptions", ExistenceChecker.isSet((AnnaDsbRateGroup) o.getNonListedAndComplexListedOptions()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("AnnaDsbCategory", ValidationResult.ValidationType.ONLY_EXISTS, "AnnaDsbCategory", path, "");
		}
		return failure("AnnaDsbCategory", ValidationResult.ValidationType.ONLY_EXISTS, "AnnaDsbCategory", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
