package iso20022.auth030.esma;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.esma.GenericIdentification175__2;
import iso20022.auth030.esma.GenericIdentification175__2.GenericIdentification175__2Builder;
import iso20022.auth030.esma.NoReasonCode;
import iso20022.auth030.esma.UniqueTransactionIdentifier3Choice__1;
import iso20022.auth030.esma.UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder;
import iso20022.auth030.esma.UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1BuilderImpl;
import iso20022.auth030.esma.UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Impl;
import iso20022.auth030.esma.meta.UniqueTransactionIdentifier3Choice__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Element is a choice between a standard identifier and a proprietary code.
 * @version ${project.version}
 */
@RosettaDataType(value="UniqueTransactionIdentifier3Choice__1", builder=UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1BuilderImpl.class, version="${project.version}")
public interface UniqueTransactionIdentifier3Choice__1 extends RosettaModelObject {

	UniqueTransactionIdentifier3Choice__1Meta metaData = new UniqueTransactionIdentifier3Choice__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Unique trade identifier (UTI) as agreed with the counterparty.
	 */
	String getUnqTxIdr();
	/**
	 * Trade identifier expressed in a proprietary notation.
	 */
	GenericIdentification175__2 getPrtry();
	/**
	 * Indicates unique transaction identifier is not available.
	 */
	NoReasonCode getNotAvlbl();

	/*********************** Build Methods  ***********************/
	UniqueTransactionIdentifier3Choice__1 build();
	
	UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder toBuilder();
	
	static UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder builder() {
		return new UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends UniqueTransactionIdentifier3Choice__1> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends UniqueTransactionIdentifier3Choice__1> getType() {
		return UniqueTransactionIdentifier3Choice__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("unqTxIdr"), String.class, getUnqTxIdr(), this);
		processRosetta(path.newSubPath("prtry"), processor, GenericIdentification175__2.class, getPrtry());
		processor.processBasic(path.newSubPath("notAvlbl"), NoReasonCode.class, getNotAvlbl(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface UniqueTransactionIdentifier3Choice__1Builder extends UniqueTransactionIdentifier3Choice__1, RosettaModelObjectBuilder {
		GenericIdentification175__2.GenericIdentification175__2Builder getOrCreatePrtry();
		@Override
		GenericIdentification175__2.GenericIdentification175__2Builder getPrtry();
		UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder setUnqTxIdr(String unqTxIdr);
		UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder setPrtry(GenericIdentification175__2 prtry);
		UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder setNotAvlbl(NoReasonCode notAvlbl);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("unqTxIdr"), String.class, getUnqTxIdr(), this);
			processRosetta(path.newSubPath("prtry"), processor, GenericIdentification175__2.GenericIdentification175__2Builder.class, getPrtry());
			processor.processBasic(path.newSubPath("notAvlbl"), NoReasonCode.class, getNotAvlbl(), this);
		}
		

		UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder prune();
	}

	/*********************** Immutable Implementation of UniqueTransactionIdentifier3Choice__1  ***********************/
	class UniqueTransactionIdentifier3Choice__1Impl implements UniqueTransactionIdentifier3Choice__1 {
		private final String unqTxIdr;
		private final GenericIdentification175__2 prtry;
		private final NoReasonCode notAvlbl;
		
		protected UniqueTransactionIdentifier3Choice__1Impl(UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder builder) {
			this.unqTxIdr = builder.getUnqTxIdr();
			this.prtry = ofNullable(builder.getPrtry()).map(f->f.build()).orElse(null);
			this.notAvlbl = builder.getNotAvlbl();
		}
		
		@Override
		@RosettaAttribute("unqTxIdr")
		public String getUnqTxIdr() {
			return unqTxIdr;
		}
		
		@Override
		@RosettaAttribute("prtry")
		public GenericIdentification175__2 getPrtry() {
			return prtry;
		}
		
		@Override
		@RosettaAttribute("notAvlbl")
		public NoReasonCode getNotAvlbl() {
			return notAvlbl;
		}
		
		@Override
		public UniqueTransactionIdentifier3Choice__1 build() {
			return this;
		}
		
		@Override
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder toBuilder() {
			UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder builder) {
			ofNullable(getUnqTxIdr()).ifPresent(builder::setUnqTxIdr);
			ofNullable(getPrtry()).ifPresent(builder::setPrtry);
			ofNullable(getNotAvlbl()).ifPresent(builder::setNotAvlbl);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			UniqueTransactionIdentifier3Choice__1 _that = getType().cast(o);
		
			if (!Objects.equals(unqTxIdr, _that.getUnqTxIdr())) return false;
			if (!Objects.equals(prtry, _that.getPrtry())) return false;
			if (!Objects.equals(notAvlbl, _that.getNotAvlbl())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (unqTxIdr != null ? unqTxIdr.hashCode() : 0);
			_result = 31 * _result + (prtry != null ? prtry.hashCode() : 0);
			_result = 31 * _result + (notAvlbl != null ? notAvlbl.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "UniqueTransactionIdentifier3Choice__1 {" +
				"unqTxIdr=" + this.unqTxIdr + ", " +
				"prtry=" + this.prtry + ", " +
				"notAvlbl=" + this.notAvlbl +
			'}';
		}
	}

	/*********************** Builder Implementation of UniqueTransactionIdentifier3Choice__1  ***********************/
	class UniqueTransactionIdentifier3Choice__1BuilderImpl implements UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder {
	
		protected String unqTxIdr;
		protected GenericIdentification175__2.GenericIdentification175__2Builder prtry;
		protected NoReasonCode notAvlbl;
		
		@Override
		@RosettaAttribute("unqTxIdr")
		public String getUnqTxIdr() {
			return unqTxIdr;
		}
		
		@Override
		@RosettaAttribute("prtry")
		public GenericIdentification175__2.GenericIdentification175__2Builder getPrtry() {
			return prtry;
		}
		
		@Override
		public GenericIdentification175__2.GenericIdentification175__2Builder getOrCreatePrtry() {
			GenericIdentification175__2.GenericIdentification175__2Builder result;
			if (prtry!=null) {
				result = prtry;
			}
			else {
				result = prtry = GenericIdentification175__2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("notAvlbl")
		public NoReasonCode getNotAvlbl() {
			return notAvlbl;
		}
		
		@Override
		@RosettaAttribute("unqTxIdr")
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder setUnqTxIdr(String _unqTxIdr) {
			this.unqTxIdr = _unqTxIdr == null ? null : _unqTxIdr;
			return this;
		}
		
		@Override
		@RosettaAttribute("prtry")
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder setPrtry(GenericIdentification175__2 _prtry) {
			this.prtry = _prtry == null ? null : _prtry.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("notAvlbl")
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder setNotAvlbl(NoReasonCode _notAvlbl) {
			this.notAvlbl = _notAvlbl == null ? null : _notAvlbl;
			return this;
		}
		
		@Override
		public UniqueTransactionIdentifier3Choice__1 build() {
			return new UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Impl(this);
		}
		
		@Override
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder prune() {
			if (prtry!=null && !prtry.prune().hasData()) prtry = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getUnqTxIdr()!=null) return true;
			if (getPrtry()!=null && getPrtry().hasData()) return true;
			if (getNotAvlbl()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder o = (UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder) other;
			
			merger.mergeRosetta(getPrtry(), o.getPrtry(), this::setPrtry);
			
			merger.mergeBasic(getUnqTxIdr(), o.getUnqTxIdr(), this::setUnqTxIdr);
			merger.mergeBasic(getNotAvlbl(), o.getNotAvlbl(), this::setNotAvlbl);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			UniqueTransactionIdentifier3Choice__1 _that = getType().cast(o);
		
			if (!Objects.equals(unqTxIdr, _that.getUnqTxIdr())) return false;
			if (!Objects.equals(prtry, _that.getPrtry())) return false;
			if (!Objects.equals(notAvlbl, _that.getNotAvlbl())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (unqTxIdr != null ? unqTxIdr.hashCode() : 0);
			_result = 31 * _result + (prtry != null ? prtry.hashCode() : 0);
			_result = 31 * _result + (notAvlbl != null ? notAvlbl.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "UniqueTransactionIdentifier3Choice__1Builder {" +
				"unqTxIdr=" + this.unqTxIdr + ", " +
				"prtry=" + this.prtry + ", " +
				"notAvlbl=" + this.notAvlbl +
			'}';
		}
	}
}
