package iso20022.auth030.esma.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.esma.AgriculturalCommodityDairy2;
import iso20022.auth030.esma.validation.AgriculturalCommodityDairy2TypeFormatValidator;
import iso20022.auth030.esma.validation.AgriculturalCommodityDairy2Validator;
import iso20022.auth030.esma.validation.exists.AgriculturalCommodityDairy2OnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version ${project.version}
 */
@RosettaMeta(model=AgriculturalCommodityDairy2.class)
public class AgriculturalCommodityDairy2Meta implements RosettaMetaData<AgriculturalCommodityDairy2> {

	@Override
	public List<Validator<? super AgriculturalCommodityDairy2>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super AgriculturalCommodityDairy2, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}

	@Override
	public Validator<? super AgriculturalCommodityDairy2> validator() {
		return new AgriculturalCommodityDairy2Validator();
	}

	@Override
	public Validator<? super AgriculturalCommodityDairy2> typeFormatValidator() {
		return new AgriculturalCommodityDairy2TypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super AgriculturalCommodityDairy2, Set<String>> onlyExistsValidator() {
		return new AgriculturalCommodityDairy2OnlyExistsValidator();
	}
}
