package iso20022.auth030.esma.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.esma.AgriculturalCommodityGrain3;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class AgriculturalCommodityGrain3TypeFormatValidator implements Validator<AgriculturalCommodityGrain3> {

	private List<ComparisonResult> getComparisonResults(AgriculturalCommodityGrain3 o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public ValidationResult<AgriculturalCommodityGrain3> validate(RosettaPath path, AgriculturalCommodityGrain3 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("AgriculturalCommodityGrain3", ValidationType.TYPE_FORMAT, "AgriculturalCommodityGrain3", path, "", error);
		}
		return success("AgriculturalCommodityGrain3", ValidationType.TYPE_FORMAT, "AgriculturalCommodityGrain3", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, AgriculturalCommodityGrain3 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("AgriculturalCommodityGrain3", ValidationType.TYPE_FORMAT, "AgriculturalCommodityGrain3", path, "", res.getError());
				}
				return success("AgriculturalCommodityGrain3", ValidationType.TYPE_FORMAT, "AgriculturalCommodityGrain3", path, "");
			})
			.collect(toList());
	}

}
