package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.NoReasonCode;
import iso20022.auth030.fca.Tranche3__1;
import iso20022.auth030.fca.Tranche3__1.Tranche3__1Builder;
import iso20022.auth030.fca.TrancheIndicator3Choice__1;
import iso20022.auth030.fca.TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder;
import iso20022.auth030.fca.TrancheIndicator3Choice__1.TrancheIndicator3Choice__1BuilderImpl;
import iso20022.auth030.fca.TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Impl;
import iso20022.auth030.fca.meta.TrancheIndicator3Choice__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Indication whether a derivative contract is tranched.
 * @version ${project.version}
 */
@RosettaDataType(value="TrancheIndicator3Choice__1", builder=TrancheIndicator3Choice__1.TrancheIndicator3Choice__1BuilderImpl.class, version="${project.version}")
public interface TrancheIndicator3Choice__1 extends RosettaModelObject {

	TrancheIndicator3Choice__1Meta metaData = new TrancheIndicator3Choice__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Indication that derivative contract is tranched.
	 */
	Tranche3__1 getTrnchd();
	/**
	 * Indicates that derivative contract is untranched.
	 */
	NoReasonCode getUtrnchd();

	/*********************** Build Methods  ***********************/
	TrancheIndicator3Choice__1 build();
	
	TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder toBuilder();
	
	static TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder builder() {
		return new TrancheIndicator3Choice__1.TrancheIndicator3Choice__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends TrancheIndicator3Choice__1> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends TrancheIndicator3Choice__1> getType() {
		return TrancheIndicator3Choice__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("trnchd"), processor, Tranche3__1.class, getTrnchd());
		processor.processBasic(path.newSubPath("utrnchd"), NoReasonCode.class, getUtrnchd(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface TrancheIndicator3Choice__1Builder extends TrancheIndicator3Choice__1, RosettaModelObjectBuilder {
		Tranche3__1.Tranche3__1Builder getOrCreateTrnchd();
		@Override
		Tranche3__1.Tranche3__1Builder getTrnchd();
		TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder setTrnchd(Tranche3__1 trnchd);
		TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder setUtrnchd(NoReasonCode utrnchd);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("trnchd"), processor, Tranche3__1.Tranche3__1Builder.class, getTrnchd());
			processor.processBasic(path.newSubPath("utrnchd"), NoReasonCode.class, getUtrnchd(), this);
		}
		

		TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder prune();
	}

	/*********************** Immutable Implementation of TrancheIndicator3Choice__1  ***********************/
	class TrancheIndicator3Choice__1Impl implements TrancheIndicator3Choice__1 {
		private final Tranche3__1 trnchd;
		private final NoReasonCode utrnchd;
		
		protected TrancheIndicator3Choice__1Impl(TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder builder) {
			this.trnchd = ofNullable(builder.getTrnchd()).map(f->f.build()).orElse(null);
			this.utrnchd = builder.getUtrnchd();
		}
		
		@Override
		@RosettaAttribute("trnchd")
		public Tranche3__1 getTrnchd() {
			return trnchd;
		}
		
		@Override
		@RosettaAttribute("utrnchd")
		public NoReasonCode getUtrnchd() {
			return utrnchd;
		}
		
		@Override
		public TrancheIndicator3Choice__1 build() {
			return this;
		}
		
		@Override
		public TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder toBuilder() {
			TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder builder) {
			ofNullable(getTrnchd()).ifPresent(builder::setTrnchd);
			ofNullable(getUtrnchd()).ifPresent(builder::setUtrnchd);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			TrancheIndicator3Choice__1 _that = getType().cast(o);
		
			if (!Objects.equals(trnchd, _that.getTrnchd())) return false;
			if (!Objects.equals(utrnchd, _that.getUtrnchd())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (trnchd != null ? trnchd.hashCode() : 0);
			_result = 31 * _result + (utrnchd != null ? utrnchd.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "TrancheIndicator3Choice__1 {" +
				"trnchd=" + this.trnchd + ", " +
				"utrnchd=" + this.utrnchd +
			'}';
		}
	}

	/*********************** Builder Implementation of TrancheIndicator3Choice__1  ***********************/
	class TrancheIndicator3Choice__1BuilderImpl implements TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder {
	
		protected Tranche3__1.Tranche3__1Builder trnchd;
		protected NoReasonCode utrnchd;
		
		@Override
		@RosettaAttribute("trnchd")
		public Tranche3__1.Tranche3__1Builder getTrnchd() {
			return trnchd;
		}
		
		@Override
		public Tranche3__1.Tranche3__1Builder getOrCreateTrnchd() {
			Tranche3__1.Tranche3__1Builder result;
			if (trnchd!=null) {
				result = trnchd;
			}
			else {
				result = trnchd = Tranche3__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("utrnchd")
		public NoReasonCode getUtrnchd() {
			return utrnchd;
		}
		
		@Override
		@RosettaAttribute("trnchd")
		public TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder setTrnchd(Tranche3__1 _trnchd) {
			this.trnchd = _trnchd == null ? null : _trnchd.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("utrnchd")
		public TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder setUtrnchd(NoReasonCode _utrnchd) {
			this.utrnchd = _utrnchd == null ? null : _utrnchd;
			return this;
		}
		
		@Override
		public TrancheIndicator3Choice__1 build() {
			return new TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Impl(this);
		}
		
		@Override
		public TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder prune() {
			if (trnchd!=null && !trnchd.prune().hasData()) trnchd = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getTrnchd()!=null && getTrnchd().hasData()) return true;
			if (getUtrnchd()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder o = (TrancheIndicator3Choice__1.TrancheIndicator3Choice__1Builder) other;
			
			merger.mergeRosetta(getTrnchd(), o.getTrnchd(), this::setTrnchd);
			
			merger.mergeBasic(getUtrnchd(), o.getUtrnchd(), this::setUtrnchd);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			TrancheIndicator3Choice__1 _that = getType().cast(o);
		
			if (!Objects.equals(trnchd, _that.getTrnchd())) return false;
			if (!Objects.equals(utrnchd, _that.getUtrnchd())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (trnchd != null ? trnchd.hashCode() : 0);
			_result = 31 * _result + (utrnchd != null ? utrnchd.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "TrancheIndicator3Choice__1Builder {" +
				"trnchd=" + this.trnchd + ", " +
				"utrnchd=" + this.utrnchd +
			'}';
		}
	}
}
