package iso20022.auth030.fca.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.fca.AssetClassProductType8Code;
import iso20022.auth030.fca.AssetClassSubProductType37Code;
import iso20022.auth030.fca.PaperCommodityPulp2__1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class PaperCommodityPulp2__1Validator implements Validator<PaperCommodityPulp2__1> {

	private List<ComparisonResult> getComparisonResults(PaperCommodityPulp2__1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("basePdct", (AssetClassProductType8Code) o.getBasePdct() != null ? 1 : 0, 1, 1), 
				checkCardinality("subPdct", (AssetClassSubProductType37Code) o.getSubPdct() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public ValidationResult<PaperCommodityPulp2__1> validate(RosettaPath path, PaperCommodityPulp2__1 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("PaperCommodityPulp2__1", ValidationType.CARDINALITY, "PaperCommodityPulp2__1", path, "", error);
		}
		return success("PaperCommodityPulp2__1", ValidationType.CARDINALITY, "PaperCommodityPulp2__1", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, PaperCommodityPulp2__1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("PaperCommodityPulp2__1", ValidationType.CARDINALITY, "PaperCommodityPulp2__1", path, "", res.getError());
				}
				return success("PaperCommodityPulp2__1", ValidationType.CARDINALITY, "PaperCommodityPulp2__1", path, "");
			})
			.collect(toList());
	}

}
