package iso20022.auth030.fca.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.fca.CommonTradeDataReport69__6;
import iso20022.auth030.fca.CounterpartySpecificData36__3;
import iso20022.auth030.fca.ModificationLevel1Code;
import iso20022.auth030.fca.TradeData42__7;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class TradeData42__7Validator implements Validator<TradeData42__7> {

	private List<ComparisonResult> getComparisonResults(TradeData42__7 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("ctrPtySpcfcData", (CounterpartySpecificData36__3) o.getCtrPtySpcfcData() != null ? 1 : 0, 1, 1), 
				checkCardinality("cmonTradData", (CommonTradeDataReport69__6) o.getCmonTradData() != null ? 1 : 0, 1, 1), 
				checkCardinality("lvl", (ModificationLevel1Code) o.getLvl() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public ValidationResult<TradeData42__7> validate(RosettaPath path, TradeData42__7 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("TradeData42__7", ValidationType.CARDINALITY, "TradeData42__7", path, "", error);
		}
		return success("TradeData42__7", ValidationType.CARDINALITY, "TradeData42__7", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradeData42__7 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("TradeData42__7", ValidationType.CARDINALITY, "TradeData42__7", path, "", res.getError());
				}
				return success("TradeData42__7", ValidationType.CARDINALITY, "TradeData42__7", path, "");
			})
			.collect(toList());
	}

}
