package iso20022.auth030.hkma.dtcc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.dtcc.AssetClassProductType5Code;
import iso20022.auth030.hkma.dtcc.AssetClassSubProductType41Code;
import iso20022.auth030.hkma.dtcc.FertilizerCommodityPotash2;
import iso20022.auth030.hkma.dtcc.FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder;
import iso20022.auth030.hkma.dtcc.FertilizerCommodityPotash2.FertilizerCommodityPotash2BuilderImpl;
import iso20022.auth030.hkma.dtcc.FertilizerCommodityPotash2.FertilizerCommodityPotash2Impl;
import iso20022.auth030.hkma.dtcc.meta.FertilizerCommodityPotash2Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of a fertilizer derivative of type potash.
 * @version ${project.version}
 */
@RosettaDataType(value="FertilizerCommodityPotash2", builder=FertilizerCommodityPotash2.FertilizerCommodityPotash2BuilderImpl.class, version="${project.version}")
public interface FertilizerCommodityPotash2 extends RosettaModelObject {

	FertilizerCommodityPotash2Meta metaData = new FertilizerCommodityPotash2Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType5Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType41Code getSubPdct();

	/*********************** Build Methods  ***********************/
	FertilizerCommodityPotash2 build();
	
	FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder toBuilder();
	
	static FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder builder() {
		return new FertilizerCommodityPotash2.FertilizerCommodityPotash2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends FertilizerCommodityPotash2> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends FertilizerCommodityPotash2> getType() {
		return FertilizerCommodityPotash2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType5Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType41Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface FertilizerCommodityPotash2Builder extends FertilizerCommodityPotash2, RosettaModelObjectBuilder {
		FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder setBasePdct(AssetClassProductType5Code basePdct);
		FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder setSubPdct(AssetClassSubProductType41Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType5Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType41Code.class, getSubPdct(), this);
		}
		

		FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder prune();
	}

	/*********************** Immutable Implementation of FertilizerCommodityPotash2  ***********************/
	class FertilizerCommodityPotash2Impl implements FertilizerCommodityPotash2 {
		private final AssetClassProductType5Code basePdct;
		private final AssetClassSubProductType41Code subPdct;
		
		protected FertilizerCommodityPotash2Impl(FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType5Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType41Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public FertilizerCommodityPotash2 build() {
			return this;
		}
		
		@Override
		public FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder toBuilder() {
			FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FertilizerCommodityPotash2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FertilizerCommodityPotash2 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of FertilizerCommodityPotash2  ***********************/
	class FertilizerCommodityPotash2BuilderImpl implements FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder {
	
		protected AssetClassProductType5Code basePdct;
		protected AssetClassSubProductType41Code subPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType5Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType41Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder setBasePdct(AssetClassProductType5Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder setSubPdct(AssetClassSubProductType41Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public FertilizerCommodityPotash2 build() {
			return new FertilizerCommodityPotash2.FertilizerCommodityPotash2Impl(this);
		}
		
		@Override
		public FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder o = (FertilizerCommodityPotash2.FertilizerCommodityPotash2Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FertilizerCommodityPotash2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FertilizerCommodityPotash2Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
