package iso20022.auth030.hkma.dtcc.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.GenericIdentification184;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class GenericIdentification184TypeFormatValidator implements Validator<GenericIdentification184> {

	private List<ComparisonResult> getComparisonResults(GenericIdentification184 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("id", o.getId(), 1, of(210), empty()), 
				checkString("src", o.getSrc(), 1, of(100), empty())
			);
	}

	@Override
	public ValidationResult<GenericIdentification184> validate(RosettaPath path, GenericIdentification184 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("GenericIdentification184", ValidationType.TYPE_FORMAT, "GenericIdentification184", path, "", error);
		}
		return success("GenericIdentification184", ValidationType.TYPE_FORMAT, "GenericIdentification184", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, GenericIdentification184 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("GenericIdentification184", ValidationType.TYPE_FORMAT, "GenericIdentification184", path, "", res.getError());
				}
				return success("GenericIdentification184", ValidationType.TYPE_FORMAT, "GenericIdentification184", path, "");
			})
			.collect(toList());
	}

}
