package iso20022.auth030.hkma.dtcc.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.MetalCommodityPrecious2;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class MetalCommodityPrecious2TypeFormatValidator implements Validator<MetalCommodityPrecious2> {

	private List<ComparisonResult> getComparisonResults(MetalCommodityPrecious2 o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public ValidationResult<MetalCommodityPrecious2> validate(RosettaPath path, MetalCommodityPrecious2 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("MetalCommodityPrecious2", ValidationType.TYPE_FORMAT, "MetalCommodityPrecious2", path, "", error);
		}
		return success("MetalCommodityPrecious2", ValidationType.TYPE_FORMAT, "MetalCommodityPrecious2", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, MetalCommodityPrecious2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("MetalCommodityPrecious2", ValidationType.TYPE_FORMAT, "MetalCommodityPrecious2", path, "", res.getError());
				}
				return success("MetalCommodityPrecious2", ValidationType.TYPE_FORMAT, "MetalCommodityPrecious2", path, "");
			})
			.collect(toList());
	}

}
