package iso20022.auth030.hkma.dtcc.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.Tranche3;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class Tranche3TypeFormatValidator implements Validator<Tranche3> {

	private List<ComparisonResult> getComparisonResults(Tranche3 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("attchmntPt", o.getAttchmntPt(), of(11), of(10), empty(), empty()), 
				checkNumber("dtchmntPt", o.getDtchmntPt(), of(11), of(10), empty(), empty())
			);
	}

	@Override
	public ValidationResult<Tranche3> validate(RosettaPath path, Tranche3 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("Tranche3", ValidationType.TYPE_FORMAT, "Tranche3", path, "", error);
		}
		return success("Tranche3", ValidationType.TYPE_FORMAT, "Tranche3", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, Tranche3 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("Tranche3", ValidationType.TYPE_FORMAT, "Tranche3", path, "", res.getError());
				}
				return success("Tranche3", ValidationType.TYPE_FORMAT, "Tranche3", path, "");
			})
			.collect(toList());
	}

}
