package iso20022.auth030.hkma.tr.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.tr.GenericIdentification175__1;
import iso20022.auth030.hkma.tr.OrganisationIdentification38__4;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class OrganisationIdentification38__4Validator implements Validator<OrganisationIdentification38__4> {

	private List<ComparisonResult> getComparisonResults(OrganisationIdentification38__4 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("id", (GenericIdentification175__1) o.getId() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public ValidationResult<OrganisationIdentification38__4> validate(RosettaPath path, OrganisationIdentification38__4 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("OrganisationIdentification38__4", ValidationType.CARDINALITY, "OrganisationIdentification38__4", path, "", error);
		}
		return success("OrganisationIdentification38__4", ValidationType.CARDINALITY, "OrganisationIdentification38__4", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, OrganisationIdentification38__4 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("OrganisationIdentification38__4", ValidationType.CARDINALITY, "OrganisationIdentification38__4", path, "", res.getError());
				}
				return success("OrganisationIdentification38__4", ValidationType.CARDINALITY, "OrganisationIdentification38__4", path, "");
			})
			.collect(toList());
	}

}
