package iso20022.auth030.jfsa;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.jfsa.DateAndDateTime2Choice__1;
import iso20022.auth030.jfsa.DateAndDateTime2Choice__1.DateAndDateTime2Choice__1Builder;
import iso20022.auth030.jfsa.DerivativeEvent6__2;
import iso20022.auth030.jfsa.DerivativeEvent6__2.DerivativeEvent6__2Builder;
import iso20022.auth030.jfsa.DerivativeEvent6__2.DerivativeEvent6__2BuilderImpl;
import iso20022.auth030.jfsa.DerivativeEvent6__2.DerivativeEvent6__2Impl;
import iso20022.auth030.jfsa.EventIdentifier1Choice__1;
import iso20022.auth030.jfsa.EventIdentifier1Choice__1.EventIdentifier1Choice__1Builder;
import iso20022.auth030.jfsa.meta.DerivativeEvent6__2Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version ${project.version}
 */
@RosettaDataType(value="DerivativeEvent6__2", builder=DerivativeEvent6__2.DerivativeEvent6__2BuilderImpl.class, version="${project.version}")
public interface DerivativeEvent6__2 extends RosettaModelObject {

	DerivativeEvent6__2Meta metaData = new DerivativeEvent6__2Meta();

	/*********************** Getter Methods  ***********************/
	EventIdentifier1Choice__1 getId();
	DateAndDateTime2Choice__1 getTmStmp();

	/*********************** Build Methods  ***********************/
	DerivativeEvent6__2 build();
	
	DerivativeEvent6__2.DerivativeEvent6__2Builder toBuilder();
	
	static DerivativeEvent6__2.DerivativeEvent6__2Builder builder() {
		return new DerivativeEvent6__2.DerivativeEvent6__2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends DerivativeEvent6__2> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends DerivativeEvent6__2> getType() {
		return DerivativeEvent6__2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("id"), processor, EventIdentifier1Choice__1.class, getId());
		processRosetta(path.newSubPath("tmStmp"), processor, DateAndDateTime2Choice__1.class, getTmStmp());
	}
	

	/*********************** Builder Interface  ***********************/
	interface DerivativeEvent6__2Builder extends DerivativeEvent6__2, RosettaModelObjectBuilder {
		EventIdentifier1Choice__1.EventIdentifier1Choice__1Builder getOrCreateId();
		@Override
		EventIdentifier1Choice__1.EventIdentifier1Choice__1Builder getId();
		DateAndDateTime2Choice__1.DateAndDateTime2Choice__1Builder getOrCreateTmStmp();
		@Override
		DateAndDateTime2Choice__1.DateAndDateTime2Choice__1Builder getTmStmp();
		DerivativeEvent6__2.DerivativeEvent6__2Builder setId(EventIdentifier1Choice__1 id);
		DerivativeEvent6__2.DerivativeEvent6__2Builder setTmStmp(DateAndDateTime2Choice__1 tmStmp);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("id"), processor, EventIdentifier1Choice__1.EventIdentifier1Choice__1Builder.class, getId());
			processRosetta(path.newSubPath("tmStmp"), processor, DateAndDateTime2Choice__1.DateAndDateTime2Choice__1Builder.class, getTmStmp());
		}
		

		DerivativeEvent6__2.DerivativeEvent6__2Builder prune();
	}

	/*********************** Immutable Implementation of DerivativeEvent6__2  ***********************/
	class DerivativeEvent6__2Impl implements DerivativeEvent6__2 {
		private final EventIdentifier1Choice__1 id;
		private final DateAndDateTime2Choice__1 tmStmp;
		
		protected DerivativeEvent6__2Impl(DerivativeEvent6__2.DerivativeEvent6__2Builder builder) {
			this.id = ofNullable(builder.getId()).map(f->f.build()).orElse(null);
			this.tmStmp = ofNullable(builder.getTmStmp()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("id")
		public EventIdentifier1Choice__1 getId() {
			return id;
		}
		
		@Override
		@RosettaAttribute("tmStmp")
		public DateAndDateTime2Choice__1 getTmStmp() {
			return tmStmp;
		}
		
		@Override
		public DerivativeEvent6__2 build() {
			return this;
		}
		
		@Override
		public DerivativeEvent6__2.DerivativeEvent6__2Builder toBuilder() {
			DerivativeEvent6__2.DerivativeEvent6__2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(DerivativeEvent6__2.DerivativeEvent6__2Builder builder) {
			ofNullable(getId()).ifPresent(builder::setId);
			ofNullable(getTmStmp()).ifPresent(builder::setTmStmp);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			DerivativeEvent6__2 _that = getType().cast(o);
		
			if (!Objects.equals(id, _that.getId())) return false;
			if (!Objects.equals(tmStmp, _that.getTmStmp())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (id != null ? id.hashCode() : 0);
			_result = 31 * _result + (tmStmp != null ? tmStmp.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "DerivativeEvent6__2 {" +
				"id=" + this.id + ", " +
				"tmStmp=" + this.tmStmp +
			'}';
		}
	}

	/*********************** Builder Implementation of DerivativeEvent6__2  ***********************/
	class DerivativeEvent6__2BuilderImpl implements DerivativeEvent6__2.DerivativeEvent6__2Builder {
	
		protected EventIdentifier1Choice__1.EventIdentifier1Choice__1Builder id;
		protected DateAndDateTime2Choice__1.DateAndDateTime2Choice__1Builder tmStmp;
		
		@Override
		@RosettaAttribute("id")
		public EventIdentifier1Choice__1.EventIdentifier1Choice__1Builder getId() {
			return id;
		}
		
		@Override
		public EventIdentifier1Choice__1.EventIdentifier1Choice__1Builder getOrCreateId() {
			EventIdentifier1Choice__1.EventIdentifier1Choice__1Builder result;
			if (id!=null) {
				result = id;
			}
			else {
				result = id = EventIdentifier1Choice__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("tmStmp")
		public DateAndDateTime2Choice__1.DateAndDateTime2Choice__1Builder getTmStmp() {
			return tmStmp;
		}
		
		@Override
		public DateAndDateTime2Choice__1.DateAndDateTime2Choice__1Builder getOrCreateTmStmp() {
			DateAndDateTime2Choice__1.DateAndDateTime2Choice__1Builder result;
			if (tmStmp!=null) {
				result = tmStmp;
			}
			else {
				result = tmStmp = DateAndDateTime2Choice__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("id")
		public DerivativeEvent6__2.DerivativeEvent6__2Builder setId(EventIdentifier1Choice__1 _id) {
			this.id = _id == null ? null : _id.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("tmStmp")
		public DerivativeEvent6__2.DerivativeEvent6__2Builder setTmStmp(DateAndDateTime2Choice__1 _tmStmp) {
			this.tmStmp = _tmStmp == null ? null : _tmStmp.toBuilder();
			return this;
		}
		
		@Override
		public DerivativeEvent6__2 build() {
			return new DerivativeEvent6__2.DerivativeEvent6__2Impl(this);
		}
		
		@Override
		public DerivativeEvent6__2.DerivativeEvent6__2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public DerivativeEvent6__2.DerivativeEvent6__2Builder prune() {
			if (id!=null && !id.prune().hasData()) id = null;
			if (tmStmp!=null && !tmStmp.prune().hasData()) tmStmp = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getId()!=null && getId().hasData()) return true;
			if (getTmStmp()!=null && getTmStmp().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public DerivativeEvent6__2.DerivativeEvent6__2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			DerivativeEvent6__2.DerivativeEvent6__2Builder o = (DerivativeEvent6__2.DerivativeEvent6__2Builder) other;
			
			merger.mergeRosetta(getId(), o.getId(), this::setId);
			merger.mergeRosetta(getTmStmp(), o.getTmStmp(), this::setTmStmp);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			DerivativeEvent6__2 _that = getType().cast(o);
		
			if (!Objects.equals(id, _that.getId())) return false;
			if (!Objects.equals(tmStmp, _that.getTmStmp())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (id != null ? id.hashCode() : 0);
			_result = 31 * _result + (tmStmp != null ? tmStmp.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "DerivativeEvent6__2Builder {" +
				"id=" + this.id + ", " +
				"tmStmp=" + this.tmStmp +
			'}';
		}
	}
}
