package iso20022.auth030.jfsa.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.jfsa.DateAndDateTime2Choice__1;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class DateAndDateTime2Choice__1Validator implements Validator<DateAndDateTime2Choice__1> {

	private List<ComparisonResult> getComparisonResults(DateAndDateTime2Choice__1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("dtTm", (ZonedDateTime) o.getDtTm() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public ValidationResult<DateAndDateTime2Choice__1> validate(RosettaPath path, DateAndDateTime2Choice__1 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("DateAndDateTime2Choice__1", ValidationType.CARDINALITY, "DateAndDateTime2Choice__1", path, "", error);
		}
		return success("DateAndDateTime2Choice__1", ValidationType.CARDINALITY, "DateAndDateTime2Choice__1", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, DateAndDateTime2Choice__1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("DateAndDateTime2Choice__1", ValidationType.CARDINALITY, "DateAndDateTime2Choice__1", path, "", res.getError());
				}
				return success("DateAndDateTime2Choice__1", ValidationType.CARDINALITY, "DateAndDateTime2Choice__1", path, "");
			})
			.collect(toList());
	}

}
