package iso20022.auth030.jfsa.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.jfsa.InterestRate33Choice__1;
import iso20022.auth030.jfsa.InterestRateLegs14__2;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class InterestRateLegs14__2Validator implements Validator<InterestRateLegs14__2> {

	private List<ComparisonResult> getComparisonResults(InterestRateLegs14__2 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("frstLeg", (InterestRate33Choice__1) o.getFrstLeg() != null ? 1 : 0, 0, 1), 
				checkCardinality("scndLeg", (InterestRate33Choice__1) o.getScndLeg() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public ValidationResult<InterestRateLegs14__2> validate(RosettaPath path, InterestRateLegs14__2 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("InterestRateLegs14__2", ValidationType.CARDINALITY, "InterestRateLegs14__2", path, "", error);
		}
		return success("InterestRateLegs14__2", ValidationType.CARDINALITY, "InterestRateLegs14__2", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, InterestRateLegs14__2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("InterestRateLegs14__2", ValidationType.CARDINALITY, "InterestRateLegs14__2", path, "", res.getError());
				}
				return success("InterestRateLegs14__2", ValidationType.CARDINALITY, "InterestRateLegs14__2", path, "");
			})
			.collect(toList());
	}

}
