package iso20022.auth030.jfsa.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.jfsa.Cleared23Choice__2;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("Cleared23Choice__2Choice")
@ImplementedBy(Cleared23Choice2Choice.Default.class)
public interface Cleared23Choice2Choice extends Validator<Cleared23Choice__2> {
	
	String NAME = "Cleared23Choice__2Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<Cleared23Choice__2> validate(RosettaPath path, Cleared23Choice__2 cleared23Choice__2);
	
	class Default implements Cleared23Choice2Choice {
	
		@Override
		public ValidationResult<Cleared23Choice__2> validate(RosettaPath path, Cleared23Choice__2 cleared23Choice__2) {
			ComparisonResult result = executeDataRule(cleared23Choice__2);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "Cleared23Choice__2", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "Cleared23Choice__2", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(Cleared23Choice__2 cleared23Choice__2) {
			try {
				return choice(MapperS.of(cleared23Choice__2), Arrays.asList("clrd", "intndToClear", "nonClrd"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements Cleared23Choice2Choice {
	
		@Override
		public ValidationResult<Cleared23Choice__2> validate(RosettaPath path, Cleared23Choice__2 cleared23Choice__2) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "Cleared23Choice__2", path, DEFINITION);
		}
	}
}
