package iso20022.auth030.mas.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.mas.UniqueTransactionIdentifier3Choice__1;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("UniqueTransactionIdentifier3Choice__1Choice")
@ImplementedBy(UniqueTransactionIdentifier3Choice1Choice.Default.class)
public interface UniqueTransactionIdentifier3Choice1Choice extends Validator<UniqueTransactionIdentifier3Choice__1> {
	
	String NAME = "UniqueTransactionIdentifier3Choice__1Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<UniqueTransactionIdentifier3Choice__1> validate(RosettaPath path, UniqueTransactionIdentifier3Choice__1 uniqueTransactionIdentifier3Choice__1);
	
	class Default implements UniqueTransactionIdentifier3Choice1Choice {
	
		@Override
		public ValidationResult<UniqueTransactionIdentifier3Choice__1> validate(RosettaPath path, UniqueTransactionIdentifier3Choice__1 uniqueTransactionIdentifier3Choice__1) {
			ComparisonResult result = executeDataRule(uniqueTransactionIdentifier3Choice__1);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "UniqueTransactionIdentifier3Choice__1", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "UniqueTransactionIdentifier3Choice__1", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(UniqueTransactionIdentifier3Choice__1 uniqueTransactionIdentifier3Choice__1) {
			try {
				return choice(MapperS.of(uniqueTransactionIdentifier3Choice__1), Arrays.asList("unqTxIdr", "prtry"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements UniqueTransactionIdentifier3Choice1Choice {
	
		@Override
		public ValidationResult<UniqueTransactionIdentifier3Choice__1> validate(RosettaPath path, UniqueTransactionIdentifier3Choice__1 uniqueTransactionIdentifier3Choice__1) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "UniqueTransactionIdentifier3Choice__1", path, DEFINITION);
		}
	}
}
