package iso20022.auth108.hkma.tr.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth108.hkma.tr.PortfolioIdentification3;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class PortfolioIdentification3TypeFormatValidator implements Validator<PortfolioIdentification3> {

	private List<ComparisonResult> getComparisonResults(PortfolioIdentification3 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("cd", o.getCd(), 1, of(52), empty())
			);
	}

	@Override
	public ValidationResult<PortfolioIdentification3> validate(RosettaPath path, PortfolioIdentification3 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("PortfolioIdentification3", ValidationType.TYPE_FORMAT, "PortfolioIdentification3", path, "", error);
		}
		return success("PortfolioIdentification3", ValidationType.TYPE_FORMAT, "PortfolioIdentification3", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, PortfolioIdentification3 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("PortfolioIdentification3", ValidationType.TYPE_FORMAT, "PortfolioIdentification3", path, "", res.getError());
				}
				return success("PortfolioIdentification3", ValidationType.TYPE_FORMAT, "PortfolioIdentification3", path, "");
			})
			.collect(toList());
	}

}
