/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator;

import com.regnosys.rosetta.generator.external.ExternalGenerator;
import com.regnosys.rosetta.generator.external.ExternalGenerators;
import com.regnosys.rosetta.generator.external.ExternalOutputConfiguration;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationProvider;

public class RosettaOutputConfigurationProvider
extends OutputConfigurationProvider {
    @Inject
    private ExternalGenerators externalGeneratorsProvider;
    public static final String SRC_GEN_JAVA_OUTPUT = "DEFAULT_OUTPUT";
    public static final String SRC_TEST_GEN_JAVA_OUTPUT = "SRC_TEST_GEN_JAVA_OUTPUT";

    public Set<OutputConfiguration> getOutputConfigurations() {
        HashSet<OutputConfiguration> result = new HashSet<OutputConfiguration>(this.getOutConfigMap().values());
        for (ExternalGenerator gen : this.externalGeneratorsProvider) {
            ExternalOutputConfiguration ext = gen.getOutputConfiguration();
            if (ext == null) continue;
            result.add(this.inflate(ext));
        }
        return result;
    }

    public Map<String, OutputConfiguration> getOutConfigMap() {
        OutputConfiguration srcGenJava = new OutputConfiguration(SRC_GEN_JAVA_OUTPUT);
        srcGenJava.setOutputDirectory("./src/generated/java");
        srcGenJava.setDescription("Generated Java Output Folder");
        srcGenJava.setOverrideExistingResources(true);
        srcGenJava.setCanClearOutputDirectory(true);
        srcGenJava.setCreateOutputDirectory(true);
        srcGenJava.setCleanUpDerivedResources(true);
        srcGenJava.setSetDerivedProperty(true);
        srcGenJava.setKeepLocalHistory(Boolean.valueOf(true));
        OutputConfiguration srcTestJava = new OutputConfiguration(SRC_TEST_GEN_JAVA_OUTPUT);
        srcTestJava.setOutputDirectory("./src/test/generated/java");
        srcTestJava.setDescription("Java Tests Output Folder");
        srcTestJava.setOverrideExistingResources(true);
        srcTestJava.setCanClearOutputDirectory(true);
        srcTestJava.setCreateOutputDirectory(true);
        srcTestJava.setCleanUpDerivedResources(true);
        srcTestJava.setSetDerivedProperty(true);
        srcTestJava.setKeepLocalHistory(Boolean.valueOf(false));
        HashMap<String, OutputConfiguration> result = new HashMap<String, OutputConfiguration>();
        result.put(SRC_GEN_JAVA_OUTPUT, srcGenJava);
        result.put(SRC_TEST_GEN_JAVA_OUTPUT, srcTestJava);
        return result;
    }

    private OutputConfiguration inflate(ExternalOutputConfiguration minimalConfig) {
        OutputConfiguration config = new OutputConfiguration(minimalConfig.getName());
        config.setOutputDirectory("./src/generated/" + minimalConfig.getDirectory());
        config.setDescription(minimalConfig.getDescription());
        config.setOverrideExistingResources(true);
        config.setCanClearOutputDirectory(true);
        config.setCreateOutputDirectory(true);
        config.setCleanUpDerivedResources(true);
        config.setSetDerivedProperty(true);
        config.setKeepLocalHistory(Boolean.valueOf(true));
        return config;
    }
}

