/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.maven;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.regnosys.rosetta.maven.RuneLanguageAccessFactory;
import com.regnosys.rosetta.maven.RuneMavenStandaloneBuilderModule;
import com.regnosys.rosetta.maven.RuneStandaloneBuilder;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.xtext.builder.standalone.ILanguageConfiguration;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.compiler.CompilerConfiguration;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.maven.AbstractXtextGeneratorMojo;
import org.eclipse.xtext.maven.ClusteringConfig;
import org.eclipse.xtext.maven.Language;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class AbstractRuneGeneratorMojo
extends AbstractXtextGeneratorMojo {
    @Parameter(defaultValue="true")
    boolean addOutputDirectoriesToCompileSourceRoots = Boolean.TRUE;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private List<Language> languages;
    @Parameter
    private String classPathLookupFilter;
    @Parameter
    private String rosettaConfig;
    @Parameter(defaultValue="${project.compileSourceRoots}", required=true)
    private List<String> javaSourceRoots;
    @Parameter(defaultValue="true")
    private Boolean failOnValidationError;
    @Parameter(defaultValue="${project.build.directory}/xtext-temp")
    private String tmpClassDirectory;
    @Parameter
    private ClusteringConfig clusteringConfig;
    @Parameter(property="maven.compiler.source", defaultValue="1.6")
    private String compilerSourceLevel;
    @Parameter(property="maven.compiler.target", defaultValue="1.6")
    private String compilerTargetLevel;
    @Parameter(defaultValue="false")
    private Boolean compilerSkipAnnotationProcessing;
    @Parameter(defaultValue="false")
    private Boolean compilerPreserveInformationAboutFormalParameters;
    @Parameter(defaultValue="false")
    private boolean writeStorageResources;
    @Parameter(defaultValue="false")
    private boolean writeClasspathConfiguration = false;
    @Parameter(defaultValue="${project.build.directory}/xtext.classpath")
    private String classpathConfigurationLocation;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojoExecution;
    @Parameter(readonly=true, defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginDependencies;
    @Parameter(defaultValue="true")
    private boolean incrementalXtextBuild;

    protected Module createModule() {
        return new RuneMavenStandaloneBuilderModule();
    }

    public MavenProject getProject() {
        return this.project;
    }

    public List<Language> getLanguages() {
        return this.languages;
    }

    protected void internalExecute() throws MojoExecutionException {
        boolean errorDetected;
        if (this.addOutputDirectoriesToCompileSourceRoots) {
            this.configureMavenOutputs();
        }
        Language language = (Language)this.getLanguages().stream().findFirst().orElseThrow(() -> new MojoExecutionException("Only one language supported by the Rosetta Plugin."));
        language.setJavaSupport(false);
        Map<String, LanguageAccess> languages = new RuneLanguageAccessFactory().createLanguageAccess((ILanguageConfiguration)language, this.rosettaConfig, ((Object)((Object)this)).getClass().getClassLoader());
        Injector injector = Guice.createInjector((Module[])new Module[]{this.createModule()});
        RuneStandaloneBuilder builder = (RuneStandaloneBuilder)((Object)injector.getInstance(RuneStandaloneBuilder.class));
        builder.setBaseDir(this.getProject().getBasedir().getAbsolutePath());
        builder.setLanguages(languages);
        builder.setEncoding(this.getEncoding());
        builder.setClassPathEntries(this.getClasspathEntries());
        builder.setClassPathLookUpFilter(this.classPathLookupFilter);
        builder.setSourceDirs(this.getSourceRoots());
        builder.setJavaSourceDirs(this.javaSourceRoots);
        builder.setFailOnValidationError(this.failOnValidationError);
        builder.setTempDir(this.createTempDir().getAbsolutePath());
        builder.setDebugLog(this.getLog().isDebugEnabled());
        builder.setIncrementalBuild(this.incrementalXtextBuild);
        builder.setWriteStorageResources(this.writeStorageResources);
        if (this.writeClasspathConfiguration) {
            builder.setClasspathConfigurationLocation(this.classpathConfigurationLocation, this.mojoExecution.getGoal(), this.getClassOutputDirectory());
        }
        if (this.clusteringConfig != null) {
            builder.setClusteringConfig(this.clusteringConfig.convertToStandaloneConfig());
        }
        this.configureCompiler(builder.getCompiler());
        this.logState();
        boolean bl = errorDetected = !builder.launch();
        if (errorDetected && this.failOnValidationError.booleanValue()) {
            throw new MojoExecutionException("Execution failed due to a severe validation error.");
        }
    }

    protected void addCompileSourceRoots(Language language) {
        if (language.getOutputConfigurations() == null) {
            return;
        }
        for (OutputConfiguration configuration : language.getOutputConfigurations()) {
            for (String output : configuration.getOutputDirectories()) {
                this.getLog().debug((CharSequence)("Adding output folder " + output + " to compile roots"));
                this.getProject().addCompileSourceRoot(output);
            }
        }
    }

    protected void addTestCompileSourceRoots(Language language) {
        if (language.getOutputConfigurations() == null) {
            return;
        }
        for (OutputConfiguration configuration : language.getOutputConfigurations()) {
            for (String output : configuration.getOutputDirectories()) {
                this.getLog().debug((CharSequence)("Adding output folder " + output + " to test compile roots"));
                this.getProject().addTestCompileSourceRoot(output);
            }
        }
    }

    private void configureCompiler(IJavaCompiler compiler) {
        CompilerConfiguration conf = compiler.getConfiguration();
        conf.setSourceLevel(this.compilerSourceLevel);
        conf.setTargetLevel(this.compilerTargetLevel);
        conf.setVerbose(this.getLog().isDebugEnabled());
        conf.setSkipAnnotationProcessing(this.compilerSkipAnnotationProcessing.booleanValue());
        conf.setPreserveInformationAboutFormalParameters(this.compilerPreserveInformationAboutFormalParameters.booleanValue());
    }

    private File createTempDir() {
        File tmpDir = new File(this.tmpClassDirectory + this.tmpDirSuffix());
        if (!tmpDir.mkdirs() && !tmpDir.exists()) {
            throw new IllegalArgumentException("Couldn't create directory '" + this.tmpClassDirectory + "'.");
        }
        return tmpDir;
    }

    private void logState() {
        this.getLog().info((CharSequence)("Encoding: " + (this.getEncoding() == null ? "not set. Encoding provider will be used." : this.getEncoding())));
        this.getLog().info((CharSequence)("Compiler source level: " + this.compilerSourceLevel));
        this.getLog().info((CharSequence)("Compiler target level: " + this.compilerTargetLevel));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Source dirs: " + IterableExtensions.join((Iterable)this.getSourceRoots(), (CharSequence)", ")));
            this.getLog().debug((CharSequence)("Java source dirs: " + IterableExtensions.join(this.javaSourceRoots, (CharSequence)", ")));
            this.getLog().debug((CharSequence)("Classpath entries: " + IterableExtensions.join(this.getClasspathEntries(), (CharSequence)", ")));
        }
    }

    private Set<String> getClasspathEntries() {
        Set classpathElements = this.getClasspathElements();
        if (this.isIncludePluginDependencies()) {
            this.getLog().info((CharSequence)"Including plugin dependencies");
            List pluginClasspathElements = this.pluginDependencies.stream().map(e -> e.getFile().toPath().toString()).collect(Collectors.toList());
            classpathElements.addAll(pluginClasspathElements);
        }
        return classpathElements;
    }
}

