/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.CurrencyDataLoader;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class Currency
implements Comparable<Currency>,
Serializable {
    private static final long serialVersionUID = 1L;
    static final CharMatcher CODE_MATCHER = CharMatcher.inRange((char)'A', (char)'Z');
    private static final ImmutableMap<String, Currency> CONFIGURED = CurrencyDataLoader.loadCurrencies(false);
    private static final ConcurrentMap<String, Currency> DYNAMIC = new ConcurrentHashMap<String, Currency>((Map<String, Currency>)CurrencyDataLoader.loadCurrencies(true));
    public static final Currency USD = Currency.of("USD");
    public static final Currency EUR = Currency.of("EUR");
    public static final Currency JPY = Currency.of("JPY");
    public static final Currency GBP = Currency.of("GBP");
    public static final Currency CHF = Currency.of("CHF");
    public static final Currency AUD = Currency.of("AUD");
    public static final Currency CAD = Currency.of("CAD");
    public static final Currency NZD = Currency.of("NZD");
    public static final Currency AED = Currency.of("AED");
    public static final Currency ARS = Currency.of("ARS");
    public static final Currency BGN = Currency.of("BGN");
    public static final Currency BHD = Currency.of("BHD");
    public static final Currency BRL = Currency.of("BRL");
    public static final Currency CLP = Currency.of("CLP");
    public static final Currency CNY = Currency.of("CNY");
    public static final Currency COP = Currency.of("COP");
    public static final Currency CZK = Currency.of("CZK");
    public static final Currency DKK = Currency.of("DKK");
    public static final Currency EGP = Currency.of("EGP");
    public static final Currency HKD = Currency.of("HKD");
    public static final Currency HRK = Currency.of("HRK");
    public static final Currency HUF = Currency.of("HUF");
    public static final Currency IDR = Currency.of("IDR");
    public static final Currency ILS = Currency.of("ILS");
    public static final Currency INR = Currency.of("INR");
    public static final Currency ISK = Currency.of("ISK");
    public static final Currency KRW = Currency.of("KRW");
    public static final Currency MXN = Currency.of("MXN");
    public static final Currency MYR = Currency.of("MYR");
    public static final Currency NOK = Currency.of("NOK");
    public static final Currency PEN = Currency.of("PEN");
    public static final Currency PHP = Currency.of("PHP");
    public static final Currency PKR = Currency.of("PKR");
    public static final Currency PLN = Currency.of("PLN");
    public static final Currency RON = Currency.of("RON");
    public static final Currency RUB = Currency.of("RUB");
    public static final Currency SAR = Currency.of("SAR");
    public static final Currency SEK = Currency.of("SEK");
    public static final Currency SGD = Currency.of("SGD");
    public static final Currency THB = Currency.of("THB");
    public static final Currency TRY = Currency.of("TRY");
    public static final Currency TWD = Currency.of("TWD");
    public static final Currency UAH = Currency.of("UAH");
    public static final Currency ZAR = Currency.of("ZAR");
    public static final Currency XXX = Currency.of("XXX");
    public static final Currency XAG = Currency.of("XAG");
    public static final Currency XAU = Currency.of("XAU");
    public static final Currency XPD = Currency.of("XPD");
    public static final Currency XPT = Currency.of("XPT");
    private final String code;
    private final transient int minorUnitDigits;
    private final transient String triangulationCurrency;
    private final transient int cachedHashCode;

    public static Set<Currency> getAvailableCurrencies() {
        return ImmutableSet.copyOf((Collection)CONFIGURED.values());
    }

    @FromString
    public static Currency of(String currencyCode) {
        ArgChecker.notNull((Object)currencyCode, (String)"currencyCode");
        Currency currency = (Currency)CONFIGURED.get((Object)currencyCode);
        if (currency == null) {
            return Currency.addCode(currencyCode);
        }
        return currency;
    }

    private static Currency addCode(String currencyCode) {
        ArgChecker.matches((CharMatcher)CODE_MATCHER, (int)3, (int)3, (String)currencyCode, (String)"currencyCode", (String)"[A-Z][A-Z][A-Z]");
        return DYNAMIC.computeIfAbsent(currencyCode, code -> new Currency((String)code, 0, "USD"));
    }

    public static Currency parse(String currencyCode) {
        ArgChecker.notNull((Object)currencyCode, (String)"currencyCode");
        return Currency.of(currencyCode.toUpperCase(Locale.ENGLISH));
    }

    Currency(String code, int fractionDigits, String triangulationCurrency) {
        this.code = code;
        this.minorUnitDigits = fractionDigits;
        this.triangulationCurrency = triangulationCurrency;
        this.cachedHashCode = (code.charAt(0) - 64 << 16) + (code.charAt(1) - 64 << 8) + (code.charAt(2) - 64);
    }

    private Object readResolve() {
        return Currency.of(this.code);
    }

    public String getCode() {
        return this.code;
    }

    public int getMinorUnitDigits() {
        return this.minorUnitDigits;
    }

    public Currency getTriangulationCurrency() {
        return Currency.of(this.triangulationCurrency);
    }

    @Override
    public int compareTo(Currency other) {
        return this.cachedHashCode - other.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Currency) {
            return this.equals((Currency)obj);
        }
        return false;
    }

    boolean equals(Currency other) {
        return other.cachedHashCode == this.cachedHashCode;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    @ToString
    public String toString() {
        return this.code;
    }
}

