/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.io.IniFile;
import com.opengamma.strata.collect.io.PropertySet;
import com.opengamma.strata.collect.io.ResourceConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

final class CurrencyDataLoader {
    private static final Logger log = Logger.getLogger(CurrencyDataLoader.class.getName());
    private static final String CURRENCY_INI = "Currency.ini";
    private static final String PAIR_INI = "CurrencyPair.ini";
    private static final String CURRENCY_DATA_INI = "CurrencyData.ini";

    private CurrencyDataLoader() {
    }

    static ImmutableMap<String, Currency> loadCurrencies(boolean loadHistoric) {
        try {
            IniFile ini = ResourceConfig.combinedIniFile((List)ResourceConfig.orderedResources((String)CURRENCY_INI));
            return CurrencyDataLoader.parseCurrencies(ini, loadHistoric);
        }
        catch (RuntimeException ex) {
            log.severe(Throwables.getStackTraceAsString((Throwable)ex));
            return ImmutableMap.of();
        }
    }

    private static ImmutableMap<String, Currency> parseCurrencies(IniFile ini, boolean loadHistoric) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : ini.asMap().entrySet()) {
            PropertySet properties;
            boolean isHistoric;
            String currencyCode = (String)entry.getKey();
            if (currencyCode.length() != 3 || !Currency.CODE_MATCHER.matchesAllOf((CharSequence)currencyCode) || (isHistoric = (properties = (PropertySet)entry.getValue()).keys().contains((Object)"historic") && Boolean.parseBoolean(properties.value("historic"))) != loadHistoric) continue;
            Integer minorUnits = Integer.parseInt(properties.value("minorUnitDigits"));
            String triangulationCurrency = properties.value("triangulationCurrency");
            builder.put((Object)currencyCode, (Object)new Currency(currencyCode, minorUnits, triangulationCurrency));
        }
        return builder.build();
    }

    static ImmutableMap<CurrencyPair, Integer> loadPairs() {
        try {
            IniFile ini = ResourceConfig.combinedIniFile((List)ResourceConfig.orderedResources((String)PAIR_INI));
            return CurrencyDataLoader.parsePairs(ini);
        }
        catch (RuntimeException ex) {
            log.severe(Throwables.getStackTraceAsString((Throwable)ex));
            return ImmutableMap.of();
        }
    }

    private static ImmutableMap<CurrencyPair, Integer> parsePairs(IniFile ini) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : ini.asMap().entrySet()) {
            String pairStr = (String)entry.getKey();
            if (!CurrencyPair.REGEX_FORMAT.matcher(pairStr).matches()) continue;
            CurrencyPair pair = CurrencyPair.parse(pairStr);
            PropertySet properties = (PropertySet)entry.getValue();
            Integer rateDigits = Integer.parseInt(properties.value("rateDigits"));
            builder.put((Object)pair, (Object)rateDigits);
        }
        return builder.build();
    }

    static ImmutableMap<Currency, Integer> loadOrdering() {
        try {
            IniFile ini = ResourceConfig.combinedIniFile((List)ResourceConfig.orderedResources((String)CURRENCY_DATA_INI));
            PropertySet section = ini.section("marketConventionPriority");
            String list = section.value("ordering");
            List currencies = (List)Arrays.stream(list.split(",")).map(String::trim).map(Currency::of).collect(Guavate.toImmutableList());
            ImmutableMap.Builder orderBuilder = ImmutableMap.builder();
            for (int i = 0; i < currencies.size(); ++i) {
                orderBuilder.put(currencies.get(i), (Object)(i + 1));
            }
            return orderBuilder.build();
        }
        catch (Exception ex) {
            log.severe(Throwables.getStackTraceAsString((Throwable)ex));
            return ImmutableMap.of();
        }
    }
}

