/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyDataLoader;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class CurrencyPair
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Pattern REGEX_FORMAT = Pattern.compile("([A-Z]{3})/([A-Z]{3})");
    private static final ImmutableMap<CurrencyPair, Integer> CONFIGURED = CurrencyDataLoader.loadPairs();
    private static final ImmutableMap<Currency, Integer> CURRENCY_ORDERING = CurrencyDataLoader.loadOrdering();
    private final Currency base;
    private final Currency counter;

    public static Set<CurrencyPair> getAvailablePairs() {
        return CONFIGURED.keySet();
    }

    public static CurrencyPair of(Currency base, Currency counter) {
        ArgChecker.notNull((Object)base, (String)"base");
        ArgChecker.notNull((Object)counter, (String)"counter");
        return new CurrencyPair(base, counter);
    }

    @FromString
    public static CurrencyPair parse(String pairStr) {
        ArgChecker.notNull((Object)pairStr, (String)"pairStr");
        Matcher matcher = REGEX_FORMAT.matcher(pairStr.toUpperCase(Locale.ENGLISH));
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid currency pair: " + pairStr);
        }
        Currency base = Currency.parse(matcher.group(1));
        Currency counter = Currency.parse(matcher.group(2));
        return new CurrencyPair(base, counter);
    }

    private CurrencyPair(Currency base, Currency counter) {
        this.base = base;
        this.counter = counter;
    }

    public CurrencyPair inverse() {
        return new CurrencyPair(this.counter, this.base);
    }

    public boolean contains(Currency currency) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        return this.base.equals(currency) || this.counter.equals(currency);
    }

    public Currency other(Currency currency) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        if (currency.equals(this.base)) {
            return this.counter;
        }
        if (currency.equals(this.counter)) {
            return this.base;
        }
        throw new IllegalArgumentException("Unable to find other currency, " + currency + " is not present in " + this.toString());
    }

    public boolean isIdentity() {
        return this.base.equals(this.counter);
    }

    public boolean isInverse(CurrencyPair other) {
        ArgChecker.notNull((Object)other, (String)"currencyPair");
        return this.base.equals(other.counter) && this.counter.equals(other.base);
    }

    public Optional<CurrencyPair> cross(CurrencyPair other) {
        ArgChecker.notNull((Object)other, (String)"other");
        if (this.isIdentity() || other.isIdentity() || this.equals(other) || this.equals(other.inverse())) {
            return Optional.empty();
        }
        if (this.counter.equals(other.base)) {
            return Optional.of(CurrencyPair.of(this.base, other.counter).toConventional());
        }
        if (this.counter.equals(other.counter)) {
            return Optional.of(CurrencyPair.of(this.base, other.base).toConventional());
        }
        if (this.base.equals(other.base)) {
            return Optional.of(CurrencyPair.of(this.counter, other.counter).toConventional());
        }
        if (this.base.equals(other.counter)) {
            return Optional.of(CurrencyPair.of(this.counter, other.base).toConventional());
        }
        return Optional.empty();
    }

    public boolean isConventional() {
        if (CONFIGURED.containsKey((Object)this)) {
            return true;
        }
        Integer basePriority = (Integer)CURRENCY_ORDERING.getOrDefault((Object)this.base, (Object)Integer.MAX_VALUE);
        Integer counterPriority = (Integer)CURRENCY_ORDERING.getOrDefault((Object)this.counter, (Object)Integer.MAX_VALUE);
        if (basePriority < counterPriority) {
            return true;
        }
        if (basePriority > counterPriority) {
            return false;
        }
        return this.base.compareTo(this.counter) <= 0;
    }

    public CurrencyPair toConventional() {
        return this.isConventional() ? this : this.inverse();
    }

    public int getRateDigits() {
        Integer digits = (Integer)CONFIGURED.get((Object)this);
        if (digits != null) {
            return digits;
        }
        Integer inverseDigits = (Integer)CONFIGURED.get((Object)this.inverse());
        if (inverseDigits != null) {
            return inverseDigits;
        }
        return this.base.getMinorUnitDigits() + this.counter.getMinorUnitDigits();
    }

    public Currency getBase() {
        return this.base;
    }

    public Currency getCounter() {
        return this.counter;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CurrencyPair other = (CurrencyPair)obj;
            return this.base.equals(other.base) && this.counter.equals(other.counter);
        }
        return false;
    }

    public int hashCode() {
        return this.base.hashCode() ^ this.counter.hashCode();
    }

    @ToString
    public String toString() {
        return this.base.getCode() + "/" + this.counter.getCode();
    }
}

