/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ImmutableHolidayCalendar
implements HolidayCalendar,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final HolidayCalendarId id;
    @PropertyDefinition(validate="notNull")
    private final ImmutableSortedSet<LocalDate> holidays;
    @PropertyDefinition(validate="notNull")
    private final ImmutableSet<DayOfWeek> weekendDays;
    private final transient int startYear;
    private final transient int[] lookup;
    private static final long serialVersionUID = 1L;

    public static ImmutableHolidayCalendar of(HolidayCalendarId id, Iterable<LocalDate> holidays, DayOfWeek firstWeekendDay, DayOfWeek secondWeekendDay) {
        ImmutableSet weekendDays = Sets.immutableEnumSet((Enum)firstWeekendDay, (Enum[])new DayOfWeek[]{secondWeekendDay});
        return new ImmutableHolidayCalendar(id, (SortedSet<LocalDate>)ImmutableSortedSet.copyOf(holidays), (Set<DayOfWeek>)weekendDays);
    }

    public static ImmutableHolidayCalendar of(HolidayCalendarId id, Iterable<LocalDate> holidays, Iterable<DayOfWeek> weekendDays) {
        return new ImmutableHolidayCalendar(id, (SortedSet<LocalDate>)ImmutableSortedSet.copyOf(holidays), (Set<DayOfWeek>)Sets.immutableEnumSet(weekendDays));
    }

    public static ImmutableHolidayCalendar combined(ImmutableHolidayCalendar cal1, ImmutableHolidayCalendar cal2) {
        if (cal1 == cal2) {
            return (ImmutableHolidayCalendar)ArgChecker.notNull((Object)cal1, (String)"cal1");
        }
        ImmutableSortedSet newHolidays = ImmutableSortedSet.copyOf((Iterable)Iterables.concat(cal1.holidays, cal2.holidays));
        ImmutableSet newWeekends = ImmutableSet.copyOf((Iterable)Iterables.concat(cal1.weekendDays, cal2.weekendDays));
        return new ImmutableHolidayCalendar(cal1.id.combinedWith(cal2.id), (SortedSet<LocalDate>)newHolidays, (Set<DayOfWeek>)newWeekends);
    }

    private ImmutableHolidayCalendar(HolidayCalendarId id, SortedSet<LocalDate> holidays, Set<DayOfWeek> weekendDays) {
        ArgChecker.notNull((Object)id, (String)"id");
        ArgChecker.notNull(holidays, (String)"holidays");
        ArgChecker.notNull(weekendDays, (String)"weekendDays");
        this.id = id;
        this.holidays = ImmutableSortedSet.copyOfSorted(holidays);
        this.weekendDays = Sets.immutableEnumSet(weekendDays);
        if (holidays.isEmpty()) {
            this.startYear = 0;
            this.lookup = new int[0];
        } else {
            this.startYear = holidays.first().getYear();
            int endYearExclusive = holidays.last().getYear() + 1;
            this.lookup = ImmutableHolidayCalendar.buildLookupArray(holidays, weekendDays, this.startYear, endYearExclusive);
        }
    }

    private static int[] buildLookupArray(SortedSet<LocalDate> holidays, Set<DayOfWeek> weekendDays, int startYear, int endYearExclusive) {
        int[] array = new int[(endYearExclusive - startYear) * 12];
        LocalDate firstOfMonth = LocalDate.of(startYear, 1, 1);
        for (int i = 0; i < array.length; ++i) {
            int monthLen = firstOfMonth.lengthOfMonth();
            array[i] = (1 << monthLen) - 1;
            for (DayOfWeek weekendDow : weekendDays) {
                int daysDiff = weekendDow.getValue() - firstOfMonth.getDayOfWeek().getValue();
                int offset = daysDiff < 0 ? daysDiff + 7 : daysDiff;
                int n = i;
                array[n] = array[n] & ~(270549121 << offset);
            }
            firstOfMonth = firstOfMonth.plusMonths(1L);
        }
        for (LocalDate date : holidays) {
            int index;
            int n = index = (date.getYear() - startYear) * 12 + date.getMonthValue() - 1;
            array[n] = array[n] & ~(1 << date.getDayOfMonth() - 1);
        }
        return array;
    }

    private Object readResolve() {
        return new ImmutableHolidayCalendar(this.id, (SortedSet<LocalDate>)this.holidays, (Set<DayOfWeek>)this.weekendDays);
    }

    @Override
    public boolean isHoliday(LocalDate date) {
        try {
            int index = (date.getYear() - this.startYear) * 12 + date.getMonthValue() - 1;
            return (this.lookup[index] & 1 << date.getDayOfMonth() - 1) == 0;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.isHolidayOutOfRange(date);
        }
    }

    private boolean isHolidayOutOfRange(LocalDate date) {
        if (date.getYear() >= 0 && date.getYear() < 10000) {
            return this.weekendDays.contains((Object)date.getDayOfWeek());
        }
        throw new IllegalArgumentException("Date is outside the accepted range (year 0000 to 10,000): " + date);
    }

    @Override
    public LocalDate shift(LocalDate date, int amount) {
        try {
            if (amount > 0) {
                return this.shiftNext(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), amount);
            }
            if (amount < 0) {
                return this.shiftPrev(date.getYear(), date.getMonthValue(), date.getDayOfMonth() - 1, amount);
            }
            return date;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.shiftOutOfRange(date, amount);
        }
    }

    private LocalDate shiftOutOfRange(LocalDate date, int amount) {
        if (date.getYear() >= 0 && date.getYear() < 10000) {
            return HolidayCalendar.super.shift(date, amount);
        }
        throw new IllegalArgumentException("Date is outside the accepted range (year 0000 to 10,000): " + date);
    }

    @Override
    public LocalDate next(LocalDate date) {
        try {
            return this.shiftNext(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 1);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return HolidayCalendar.super.next(date);
        }
    }

    private LocalDate shiftNext(int baseYear, int baseMonth, int baseDom0, int amount) {
        int index = (baseYear - this.startYear) * 12 + baseMonth - 1;
        int monthData = this.lookup[index];
        int domOffset = baseDom0;
        for (int amt = amount; amt > 0; --amt) {
            int shifted = monthData >> domOffset;
            if (shifted == 0) {
                return baseMonth == 12 ? this.shiftNext(baseYear + 1, 1, 0, amt) : this.shiftNext(baseYear, baseMonth + 1, 0, amt);
            }
            domOffset += Integer.numberOfTrailingZeros(shifted) + 1;
        }
        return LocalDate.of(baseYear, baseMonth, domOffset);
    }

    @Override
    public LocalDate previous(LocalDate date) {
        try {
            return this.shiftPrev(date.getYear(), date.getMonthValue(), date.getDayOfMonth() - 1, -1);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.previousOutOfRange(date);
        }
    }

    private LocalDate shiftPrev(int baseYear, int baseMonth, int baseDom, int amount) {
        int index = (baseYear - this.startYear) * 12 + baseMonth - 1;
        int monthData = this.lookup[index];
        int domOffset = baseDom;
        for (int amt = amount; amt < 0; ++amt) {
            int shifted = monthData << 32 - domOffset;
            if (shifted == 0 || domOffset <= 0) {
                return baseMonth == 1 ? this.shiftPrev(baseYear - 1, 12, 31, amt) : this.shiftPrev(baseYear, baseMonth - 1, 31, amt);
            }
            domOffset -= Integer.numberOfLeadingZeros(shifted) + 1;
        }
        return LocalDate.of(baseYear, baseMonth, domOffset + 1);
    }

    private LocalDate previousOutOfRange(LocalDate date) {
        if (date.getYear() >= 0 && date.getYear() < 10000) {
            return HolidayCalendar.super.previous(date);
        }
        throw new IllegalArgumentException("Date is outside the accepted range (year 0000 to 10,000): " + date);
    }

    @Override
    public LocalDate nextSameOrLastInMonth(LocalDate date) {
        try {
            return this.shiftNextSameLast(date);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return HolidayCalendar.super.nextSameOrLastInMonth(date);
        }
    }

    private LocalDate shiftNextSameLast(LocalDate baseDate) {
        int dom;
        int baseDom;
        int baseMonth;
        int baseYear = baseDate.getYear();
        int index = (baseYear - this.startYear) * 12 + (baseMonth = baseDate.getMonthValue()) - 1;
        int monthData = this.lookup[index];
        int shifted = monthData >> (baseDom = baseDate.getDayOfMonth()) - 1;
        if (shifted == 0) {
            int leading = Integer.numberOfLeadingZeros(monthData);
            dom = 32 - leading;
        } else {
            dom = baseDom + Integer.numberOfTrailingZeros(shifted);
        }
        return baseDate.withDayOfMonth(dom);
    }

    @Override
    public boolean isLastBusinessDayOfMonth(LocalDate date) {
        try {
            int index = (date.getYear() - this.startYear) * 12 + date.getMonthValue() - 1;
            return this.lookup[index] >>> date.getDayOfMonth() - 1 == 1;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.isLastBusinessDayOfMonthOutOfRange(date);
        }
    }

    private boolean isLastBusinessDayOfMonthOutOfRange(LocalDate date) {
        if (date.getYear() >= 0 && date.getYear() < 10000) {
            return HolidayCalendar.super.isLastBusinessDayOfMonth(date);
        }
        throw new IllegalArgumentException("Date is outside the accepted range (year 0000 to 10,000): " + date);
    }

    @Override
    public LocalDate lastBusinessDayOfMonth(LocalDate date) {
        try {
            int index = (date.getYear() - this.startYear) * 12 + date.getMonthValue() - 1;
            int leading = Integer.numberOfLeadingZeros(this.lookup[index]);
            return date.withDayOfMonth(32 - leading);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.lastBusinessDayOfMonthOutOfRange(date);
        }
    }

    private LocalDate lastBusinessDayOfMonthOutOfRange(LocalDate date) {
        if (date.getYear() >= 0 && date.getYear() < 10000) {
            return HolidayCalendar.super.lastBusinessDayOfMonth(date);
        }
        throw new IllegalArgumentException("Date is outside the accepted range (year 0000 to 10,000): " + date);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImmutableHolidayCalendar) {
            return this.id.equals(((ImmutableHolidayCalendar)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "HolidayCalendar[" + this.getName() + ']';
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public HolidayCalendarId getId() {
        return this.id;
    }

    public ImmutableSortedSet<LocalDate> getHolidays() {
        return this.holidays;
    }

    public ImmutableSet<DayOfWeek> getWeekendDays() {
        return this.weekendDays;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ImmutableHolidayCalendar> {
        private HolidayCalendarId id;
        private SortedSet<LocalDate> holidays = ImmutableSortedSet.of();
        private Set<DayOfWeek> weekendDays = ImmutableSet.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case -510663909: {
                    return this.holidays;
                }
                case 563236190: {
                    return this.weekendDays;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    this.id = (HolidayCalendarId)newValue;
                    break;
                }
                case -510663909: {
                    this.holidays = (SortedSet)newValue;
                    break;
                }
                case 563236190: {
                    this.weekendDays = (Set)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ImmutableHolidayCalendar build() {
            return new ImmutableHolidayCalendar(this.id, this.holidays, this.weekendDays);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ImmutableHolidayCalendar.Builder{");
            buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
            buf.append("holidays").append('=').append(JodaBeanUtils.toString(this.holidays)).append(',').append(' ');
            buf.append("weekendDays").append('=').append(JodaBeanUtils.toString(this.weekendDays));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<HolidayCalendarId> id = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"id", ImmutableHolidayCalendar.class, HolidayCalendarId.class);
        private final MetaProperty<ImmutableSortedSet<LocalDate>> holidays = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"holidays", ImmutableHolidayCalendar.class, ImmutableSortedSet.class);
        private final MetaProperty<ImmutableSet<DayOfWeek>> weekendDays = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"weekendDays", ImmutableHolidayCalendar.class, ImmutableSet.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"id", "holidays", "weekendDays"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case -510663909: {
                    return this.holidays;
                }
                case 563236190: {
                    return this.weekendDays;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ImmutableHolidayCalendar> builder() {
            return new Builder();
        }

        public Class<? extends ImmutableHolidayCalendar> beanType() {
            return ImmutableHolidayCalendar.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<HolidayCalendarId> id() {
            return this.id;
        }

        public MetaProperty<ImmutableSortedSet<LocalDate>> holidays() {
            return this.holidays;
        }

        public MetaProperty<ImmutableSet<DayOfWeek>> weekendDays() {
            return this.weekendDays;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return ((ImmutableHolidayCalendar)bean).getId();
                }
                case -510663909: {
                    return ((ImmutableHolidayCalendar)bean).getHolidays();
                }
                case 563236190: {
                    return ((ImmutableHolidayCalendar)bean).getWeekendDays();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

