/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
final class WeekendHolidayCalendar
implements HolidayCalendar,
ImmutableBean,
Serializable {
    static final WeekendHolidayCalendar SAT_SUN = new WeekendHolidayCalendar(HolidayCalendarIds.SAT_SUN, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    static final WeekendHolidayCalendar FRI_SAT = new WeekendHolidayCalendar(HolidayCalendarIds.FRI_SAT, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY);
    static final WeekendHolidayCalendar THU_FRI = new WeekendHolidayCalendar(HolidayCalendarIds.THU_FRI, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final HolidayCalendarId id;
    @PropertyDefinition(validate="notNull")
    private final DayOfWeek day1;
    @PropertyDefinition(validate="notNull")
    private final DayOfWeek day2;
    private static final long serialVersionUID = 1L;

    private Object readResolve() throws InvalidObjectException {
        if (this.id == HolidayCalendarIds.SAT_SUN) {
            return SAT_SUN;
        }
        if (this.id == HolidayCalendarIds.FRI_SAT) {
            return FRI_SAT;
        }
        if (this.id == HolidayCalendarIds.THU_FRI) {
            return THU_FRI;
        }
        throw new InvalidObjectException("Invalid WeekendHolidayCalendar identifier");
    }

    @Override
    public boolean isHoliday(LocalDate date) {
        DayOfWeek dow = date.getDayOfWeek();
        return dow == this.day1 || dow == this.day2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WeekendHolidayCalendar) {
            return this.id.equals(((WeekendHolidayCalendar)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "HolidayCalendar[" + this.id.getName() + ']';
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private WeekendHolidayCalendar(HolidayCalendarId id, DayOfWeek day1, DayOfWeek day2) {
        JodaBeanUtils.notNull((Object)id, (String)"id");
        JodaBeanUtils.notNull((Object)day1, (String)"day1");
        JodaBeanUtils.notNull((Object)day2, (String)"day2");
        this.id = id;
        this.day1 = day1;
        this.day2 = day2;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public HolidayCalendarId getId() {
        return this.id;
    }

    public DayOfWeek getDay1() {
        return this.day1;
    }

    public DayOfWeek getDay2() {
        return this.day2;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<WeekendHolidayCalendar> {
        private HolidayCalendarId id;
        private DayOfWeek day1;
        private DayOfWeek day2;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case 3076117: {
                    return this.day1;
                }
                case 3076118: {
                    return this.day2;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    this.id = (HolidayCalendarId)newValue;
                    break;
                }
                case 3076117: {
                    this.day1 = (DayOfWeek)newValue;
                    break;
                }
                case 3076118: {
                    this.day2 = (DayOfWeek)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public WeekendHolidayCalendar build() {
            return new WeekendHolidayCalendar(this.id, this.day1, this.day2);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("WeekendHolidayCalendar.Builder{");
            buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
            buf.append("day1").append('=').append(JodaBeanUtils.toString((Object)this.day1)).append(',').append(' ');
            buf.append("day2").append('=').append(JodaBeanUtils.toString((Object)this.day2));
            buf.append('}');
            return buf.toString();
        }
    }

    static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<HolidayCalendarId> id = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"id", WeekendHolidayCalendar.class, HolidayCalendarId.class);
        private final MetaProperty<DayOfWeek> day1 = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"day1", WeekendHolidayCalendar.class, DayOfWeek.class);
        private final MetaProperty<DayOfWeek> day2 = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"day2", WeekendHolidayCalendar.class, DayOfWeek.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"id", "day1", "day2"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case 3076117: {
                    return this.day1;
                }
                case 3076118: {
                    return this.day2;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends WeekendHolidayCalendar> builder() {
            return new Builder();
        }

        public Class<? extends WeekendHolidayCalendar> beanType() {
            return WeekendHolidayCalendar.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<HolidayCalendarId> id() {
            return this.id;
        }

        public MetaProperty<DayOfWeek> day1() {
            return this.day1;
        }

        public MetaProperty<DayOfWeek> day2() {
            return this.day2;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return ((WeekendHolidayCalendar)bean).getId();
                }
                case 3076117: {
                    return ((WeekendHolidayCalendar)bean).getDay1();
                }
                case 3076118: {
                    return ((WeekendHolidayCalendar)bean).getDay2();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

