/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.beans.gen.PropertyData;
import org.joda.beans.gen.PropertyGen;

abstract class BuilderGen {
    BuilderGen() {
    }

    abstract List<String> generateField(String var1, PropertyData var2);

    abstract boolean isSpecialInit(PropertyData var1);

    abstract String generateInit(PropertyData var1);

    String generateType(PropertyData prop) {
        return prop.getBuilderType();
    }

    private static String defaultType(PropertyData prop) {
        if (prop.getType().equals("long")) {
            return "0L";
        }
        if (prop.getType().equals("int")) {
            return "0";
        }
        if (prop.getType().equals("short")) {
            return "Short.valueOf(0)";
        }
        if (prop.getType().equals("byte")) {
            return "Byte.valueOf(0)";
        }
        if (prop.getType().equals("double")) {
            return "0d";
        }
        if (prop.getType().equals("float")) {
            return "0f";
        }
        if (prop.getType().equals("char")) {
            return "Character.valueOf((char) 0)";
        }
        if (prop.getType().equals("boolean")) {
            return "Boolean.FALSE";
        }
        return "null";
    }

    static class NoBuilderGen
    extends BuilderGen {
        static final BuilderGen INSTANCE = new NoBuilderGen();

        NoBuilderGen() {
        }

        @Override
        List<String> generateField(String indent, PropertyData prop) {
            return Collections.emptyList();
        }

        @Override
        boolean isSpecialInit(PropertyData prop) {
            return false;
        }

        @Override
        String generateInit(PropertyData prop) {
            return BuilderGen.defaultType(prop);
        }
    }

    static class SimpleBuilderGen
    extends BuilderGen {
        SimpleBuilderGen() {
        }

        @Override
        List<String> generateField(String indent, PropertyData prop) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(indent + "private " + this.generateType(prop) + " " + prop.getFieldName() + ";");
            return list;
        }

        @Override
        boolean isSpecialInit(PropertyData prop) {
            return false;
        }

        @Override
        String generateInit(PropertyData prop) {
            return BuilderGen.defaultType(prop);
        }

        @Override
        String generateType(PropertyData prop) {
            return prop.getBuilderType().replace("<>", prop.getTypeGenerics());
        }
    }

    static class PatternBuilderGen
    extends BuilderGen {
        private final String type;
        private final String init;

        PatternBuilderGen(String type, String init) {
            this.type = type;
            this.init = init;
        }

        @Override
        List<String> generateField(String indent, PropertyData prop) {
            ArrayList<String> list = new ArrayList<String>();
            if (prop.isNotNull()) {
                String init = this.init;
                init = init.replace("<>", PropertyGen.resolveWildcard(prop.getTypeGenerics()));
                list.add(indent + "private " + this.generateType(prop) + " " + prop.getFieldName() + " = " + init + ";");
            } else {
                list.add(indent + "private " + this.generateType(prop) + " " + prop.getFieldName() + ";");
            }
            return list;
        }

        @Override
        boolean isSpecialInit(PropertyData prop) {
            return true;
        }

        @Override
        String generateInit(PropertyData prop) {
            return this.init;
        }

        @Override
        String generateType(PropertyData prop) {
            if (!"smart".equals(prop.getBuilderTypeStyle())) {
                return prop.getBuilderType().replace("<>", prop.getTypeGenerics());
            }
            return this.type.replace("<>", prop.getTypeGenerics());
        }
    }
}

