/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common;

import cdm.base.staticdata.party.Counterparty;
import cdm.legaldocumentation.common.meta.AgreementTermsMeta;
import cdm.legaldocumentation.contract.Agreement;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AgreementTerms", builder=AgreementTermsBuilderImpl.class, version="5.29.0")
@RuneDataType(value="AgreementTerms", model="cdm", builder=AgreementTermsBuilderImpl.class, version="5.29.0")
public interface AgreementTerms
extends RosettaModelObject {
    public static final AgreementTermsMeta metaData = new AgreementTermsMeta();

    public Agreement getAgreement();

    public Boolean getClauseLibrary();

    public List<? extends Counterparty> getCounterparty();

    public AgreementTerms build();

    public AgreementTermsBuilder toBuilder();

    public static AgreementTermsBuilder builder() {
        return new AgreementTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends AgreementTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AgreementTerms> getType() {
        return AgreementTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("agreement"), processor, Agreement.class, this.getAgreement(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clauseLibrary"), Boolean.class, (Object)this.getClauseLibrary(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterparty"), processor, Counterparty.class, this.getCounterparty(), new AttributeMeta[0]);
    }

    public static class AgreementTermsBuilderImpl
    implements AgreementTermsBuilder {
        protected Agreement.AgreementBuilder agreement;
        protected Boolean clauseLibrary;
        protected List<Counterparty.CounterpartyBuilder> counterparty = new ArrayList<Counterparty.CounterpartyBuilder>();

        @Override
        @RosettaAttribute(value="agreement", isRequired=true)
        @RuneAttribute(value="agreement", isRequired=true)
        public Agreement.AgreementBuilder getAgreement() {
            return this.agreement;
        }

        @Override
        public Agreement.AgreementBuilder getOrCreateAgreement() {
            Agreement.AgreementBuilder result = this.agreement != null ? this.agreement : (this.agreement = Agreement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="clauseLibrary")
        @RuneAttribute(value="clauseLibrary")
        public Boolean getClauseLibrary() {
            return this.clauseLibrary;
        }

        @Override
        @RosettaAttribute(value="counterparty", isRequired=true)
        @RuneAttribute(value="counterparty", isRequired=true)
        public List<? extends Counterparty.CounterpartyBuilder> getCounterparty() {
            return this.counterparty;
        }

        @Override
        public Counterparty.CounterpartyBuilder getOrCreateCounterparty(int index) {
            if (this.counterparty == null) {
                this.counterparty = new ArrayList<Counterparty.CounterpartyBuilder>();
            }
            return (Counterparty.CounterpartyBuilder)this.getIndex(this.counterparty, index, () -> {
                Counterparty.CounterpartyBuilder newCounterparty = Counterparty.builder();
                return newCounterparty;
            });
        }

        @Override
        @RosettaAttribute(value="agreement", isRequired=true)
        @RuneAttribute(value="agreement", isRequired=true)
        public AgreementTermsBuilder setAgreement(Agreement _agreement) {
            this.agreement = _agreement == null ? null : _agreement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clauseLibrary")
        @RuneAttribute(value="clauseLibrary")
        public AgreementTermsBuilder setClauseLibrary(Boolean _clauseLibrary) {
            this.clauseLibrary = _clauseLibrary == null ? null : _clauseLibrary;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty", isRequired=true)
        @RuneAttribute(value="counterparty", isRequired=true)
        public AgreementTermsBuilder addCounterparty(Counterparty _counterparty) {
            if (_counterparty != null) {
                this.counterparty.add(_counterparty.toBuilder());
            }
            return this;
        }

        @Override
        public AgreementTermsBuilder addCounterparty(Counterparty _counterparty, int idx) {
            this.getIndex(this.counterparty, idx, () -> _counterparty.toBuilder());
            return this;
        }

        @Override
        public AgreementTermsBuilder addCounterparty(List<? extends Counterparty> counterpartys) {
            if (counterpartys != null) {
                for (Counterparty counterparty : counterpartys) {
                    this.counterparty.add(counterparty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="counterparty")
        public AgreementTermsBuilder setCounterparty(List<? extends Counterparty> counterpartys) {
            this.counterparty = counterpartys == null ? new ArrayList<Counterparty.CounterpartyBuilder>() : (List)counterpartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AgreementTerms build() {
            return new AgreementTermsImpl(this);
        }

        @Override
        public AgreementTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public AgreementTermsBuilder prune() {
            if (this.agreement != null && !this.agreement.prune().hasData()) {
                this.agreement = null;
            }
            this.counterparty = this.counterparty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAgreement() != null && this.getAgreement().hasData()) {
                return true;
            }
            if (this.getClauseLibrary() != null) {
                return true;
            }
            return this.getCounterparty() != null && this.getCounterparty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public AgreementTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AgreementTermsBuilder o = (AgreementTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreement(), (RosettaModelObjectBuilder)o.getAgreement(), this::setAgreement);
            merger.mergeRosetta(this.getCounterparty(), o.getCounterparty(), this::getOrCreateCounterparty);
            merger.mergeBasic((Object)this.getClauseLibrary(), (Object)o.getClauseLibrary(), this::setClauseLibrary, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AgreementTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.agreement, _that.getAgreement())) {
                return false;
            }
            if (!Objects.equals(this.clauseLibrary, _that.getClauseLibrary())) {
                return false;
            }
            return ListEquals.listEquals(this.counterparty, _that.getCounterparty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.agreement != null ? this.agreement.hashCode() : 0);
            _result = 31 * _result + (this.clauseLibrary != null ? this.clauseLibrary.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AgreementTermsBuilder {agreement=" + this.agreement + ", clauseLibrary=" + this.clauseLibrary + ", counterparty=" + this.counterparty + '}';
        }
    }

    public static interface AgreementTermsBuilder
    extends AgreementTerms,
    RosettaModelObjectBuilder {
        public Agreement.AgreementBuilder getOrCreateAgreement();

        @Override
        public Agreement.AgreementBuilder getAgreement();

        public Counterparty.CounterpartyBuilder getOrCreateCounterparty(int var1);

        public List<? extends Counterparty.CounterpartyBuilder> getCounterparty();

        public AgreementTermsBuilder setAgreement(Agreement var1);

        public AgreementTermsBuilder setClauseLibrary(Boolean var1);

        public AgreementTermsBuilder addCounterparty(Counterparty var1);

        public AgreementTermsBuilder addCounterparty(Counterparty var1, int var2);

        public AgreementTermsBuilder addCounterparty(List<? extends Counterparty> var1);

        public AgreementTermsBuilder setCounterparty(List<? extends Counterparty> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("agreement"), processor, Agreement.AgreementBuilder.class, this.getAgreement(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clauseLibrary"), Boolean.class, (Object)this.getClauseLibrary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterparty"), processor, Counterparty.CounterpartyBuilder.class, this.getCounterparty(), new AttributeMeta[0]);
        }

        public AgreementTermsBuilder prune();
    }

    public static class AgreementTermsImpl
    implements AgreementTerms {
        private final Agreement agreement;
        private final Boolean clauseLibrary;
        private final List<? extends Counterparty> counterparty;

        protected AgreementTermsImpl(AgreementTermsBuilder builder) {
            this.agreement = Optional.ofNullable(builder.getAgreement()).map(f -> f.build()).orElse(null);
            this.clauseLibrary = builder.getClauseLibrary();
            this.counterparty = Optional.ofNullable(builder.getCounterparty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="agreement", isRequired=true)
        @RuneAttribute(value="agreement", isRequired=true)
        public Agreement getAgreement() {
            return this.agreement;
        }

        @Override
        @RosettaAttribute(value="clauseLibrary")
        @RuneAttribute(value="clauseLibrary")
        public Boolean getClauseLibrary() {
            return this.clauseLibrary;
        }

        @Override
        @RosettaAttribute(value="counterparty", isRequired=true)
        @RuneAttribute(value="counterparty", isRequired=true)
        public List<? extends Counterparty> getCounterparty() {
            return this.counterparty;
        }

        @Override
        public AgreementTerms build() {
            return this;
        }

        @Override
        public AgreementTermsBuilder toBuilder() {
            AgreementTermsBuilder builder = AgreementTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AgreementTermsBuilder builder) {
            Optional.ofNullable(this.getAgreement()).ifPresent(builder::setAgreement);
            Optional.ofNullable(this.getClauseLibrary()).ifPresent(builder::setClauseLibrary);
            Optional.ofNullable(this.getCounterparty()).ifPresent(builder::setCounterparty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AgreementTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.agreement, _that.getAgreement())) {
                return false;
            }
            if (!Objects.equals(this.clauseLibrary, _that.getClauseLibrary())) {
                return false;
            }
            return ListEquals.listEquals(this.counterparty, _that.getCounterparty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.agreement != null ? this.agreement.hashCode() : 0);
            _result = 31 * _result + (this.clauseLibrary != null ? this.clauseLibrary.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AgreementTerms {agreement=" + this.agreement + ", clauseLibrary=" + this.clauseLibrary + ", counterparty=" + this.counterparty + '}';
        }
    }
}

