/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.Observable;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ObservableObservableChoice")
@ImplementedBy(value=Default.class)
public interface ObservableObservableChoice
extends Validator<Observable> {
    public static final String NAME = "ObservableObservableChoice";
    public static final String DEFINITION = "required choice rateOption, commodity, productIdentifier, currencyPair";

    public static class NoOp
    implements ObservableObservableChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Observable observable) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ObservableObservableChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Observable observable) {
            ComparisonResult result = this.executeDataRule(observable);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ObservableObservableChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Observable", (RosettaPath)path, (String)ObservableObservableChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ObservableObservableChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Observable", (RosettaPath)path, (String)ObservableObservableChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Observable observable) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)observable), Arrays.asList("rateOption", "commodity", "productIdentifier", "currencyPair"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

