/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.product.asset.ReferencePool;
import cdm.product.asset.Tranche;
import cdm.product.asset.meta.BasketReferenceInformationMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="BasketReferenceInformation", builder=BasketReferenceInformationBuilderImpl.class, version="5.29.0")
@RuneDataType(value="BasketReferenceInformation", model="cdm", builder=BasketReferenceInformationBuilderImpl.class, version="5.29.0")
public interface BasketReferenceInformation
extends RosettaModelObject {
    public static final BasketReferenceInformationMeta metaData = new BasketReferenceInformationMeta();

    public FieldWithMetaString getBasketName();

    public List<? extends FieldWithMetaString> getBasketId();

    public ReferencePool getReferencePool();

    public Integer getNthToDefault();

    public Integer getMthToDefault();

    public Tranche getTranche();

    public BasketReferenceInformation build();

    public BasketReferenceInformationBuilder toBuilder();

    public static BasketReferenceInformationBuilder builder() {
        return new BasketReferenceInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends BasketReferenceInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BasketReferenceInformation> getType() {
        return BasketReferenceInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("basketName"), processor, FieldWithMetaString.class, this.getBasketName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketId"), processor, FieldWithMetaString.class, this.getBasketId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referencePool"), processor, ReferencePool.class, this.getReferencePool(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nthToDefault"), Integer.class, (Object)this.getNthToDefault(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("mthToDefault"), Integer.class, (Object)this.getMthToDefault(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tranche"), processor, Tranche.class, this.getTranche(), new AttributeMeta[0]);
    }

    public static class BasketReferenceInformationBuilderImpl
    implements BasketReferenceInformationBuilder {
        protected FieldWithMetaString.FieldWithMetaStringBuilder basketName;
        protected List<FieldWithMetaString.FieldWithMetaStringBuilder> basketId = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
        protected ReferencePool.ReferencePoolBuilder referencePool;
        protected Integer nthToDefault;
        protected Integer mthToDefault;
        protected Tranche.TrancheBuilder tranche;

        @Override
        @RosettaAttribute(value="basketName")
        @RuneAttribute(value="basketName")
        public FieldWithMetaString.FieldWithMetaStringBuilder getBasketName() {
            return this.basketName;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateBasketName() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.basketName != null ? this.basketName : (this.basketName = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="basketId")
        @RuneAttribute(value="basketId")
        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getBasketId() {
            return this.basketId;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateBasketId(int index) {
            if (this.basketId == null) {
                this.basketId = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
            }
            return (FieldWithMetaString.FieldWithMetaStringBuilder)this.getIndex(this.basketId, index, () -> {
                FieldWithMetaString.FieldWithMetaStringBuilder newBasketId = FieldWithMetaString.builder();
                return newBasketId;
            });
        }

        @Override
        @RosettaAttribute(value="referencePool", isRequired=true)
        @RuneAttribute(value="referencePool", isRequired=true)
        public ReferencePool.ReferencePoolBuilder getReferencePool() {
            return this.referencePool;
        }

        @Override
        public ReferencePool.ReferencePoolBuilder getOrCreateReferencePool() {
            ReferencePool.ReferencePoolBuilder result = this.referencePool != null ? this.referencePool : (this.referencePool = ReferencePool.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nthToDefault")
        @RuneAttribute(value="nthToDefault")
        public Integer getNthToDefault() {
            return this.nthToDefault;
        }

        @Override
        @RosettaAttribute(value="mthToDefault")
        @RuneAttribute(value="mthToDefault")
        public Integer getMthToDefault() {
            return this.mthToDefault;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public Tranche.TrancheBuilder getTranche() {
            return this.tranche;
        }

        @Override
        public Tranche.TrancheBuilder getOrCreateTranche() {
            Tranche.TrancheBuilder result = this.tranche != null ? this.tranche : (this.tranche = Tranche.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="basketName")
        @RuneAttribute(value="basketName")
        public BasketReferenceInformationBuilder setBasketName(FieldWithMetaString _basketName) {
            this.basketName = _basketName == null ? null : _basketName.toBuilder();
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder setBasketNameValue(String _basketName) {
            this.getOrCreateBasketName().setValue(_basketName);
            return this;
        }

        @Override
        @RosettaAttribute(value="basketId")
        @RuneAttribute(value="basketId")
        public BasketReferenceInformationBuilder addBasketId(FieldWithMetaString _basketId) {
            if (_basketId != null) {
                this.basketId.add(_basketId.toBuilder());
            }
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder addBasketId(FieldWithMetaString _basketId, int idx) {
            this.getIndex(this.basketId, idx, () -> _basketId.toBuilder());
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder addBasketIdValue(String _basketId) {
            this.getOrCreateBasketId(-1).setValue(_basketId);
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder addBasketIdValue(String _basketId, int idx) {
            this.getOrCreateBasketId(idx).setValue(_basketId);
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder addBasketId(List<? extends FieldWithMetaString> basketIds) {
            if (basketIds != null) {
                for (FieldWithMetaString fieldWithMetaString : basketIds) {
                    this.basketId.add(fieldWithMetaString.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketId")
        public BasketReferenceInformationBuilder setBasketId(List<? extends FieldWithMetaString> basketIds) {
            this.basketId = basketIds == null ? new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>() : (List)basketIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder addBasketIdValue(List<? extends String> basketIds) {
            if (basketIds != null) {
                for (String string : basketIds) {
                    this.addBasketIdValue(string);
                }
            }
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder setBasketIdValue(List<? extends String> basketIds) {
            this.basketId.clear();
            if (basketIds != null) {
                basketIds.forEach(this::addBasketIdValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="referencePool", isRequired=true)
        @RuneAttribute(value="referencePool", isRequired=true)
        public BasketReferenceInformationBuilder setReferencePool(ReferencePool _referencePool) {
            this.referencePool = _referencePool == null ? null : _referencePool.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nthToDefault")
        @RuneAttribute(value="nthToDefault")
        public BasketReferenceInformationBuilder setNthToDefault(Integer _nthToDefault) {
            this.nthToDefault = _nthToDefault == null ? null : _nthToDefault;
            return this;
        }

        @Override
        @RosettaAttribute(value="mthToDefault")
        @RuneAttribute(value="mthToDefault")
        public BasketReferenceInformationBuilder setMthToDefault(Integer _mthToDefault) {
            this.mthToDefault = _mthToDefault == null ? null : _mthToDefault;
            return this;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public BasketReferenceInformationBuilder setTranche(Tranche _tranche) {
            this.tranche = _tranche == null ? null : _tranche.toBuilder();
            return this;
        }

        @Override
        public BasketReferenceInformation build() {
            return new BasketReferenceInformationImpl(this);
        }

        @Override
        public BasketReferenceInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder prune() {
            if (this.basketName != null && !this.basketName.prune().hasData()) {
                this.basketName = null;
            }
            this.basketId = this.basketId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.referencePool != null && !this.referencePool.prune().hasData()) {
                this.referencePool = null;
            }
            if (this.tranche != null && !this.tranche.prune().hasData()) {
                this.tranche = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBasketName() != null) {
                return true;
            }
            if (this.getBasketId() != null && !this.getBasketId().isEmpty()) {
                return true;
            }
            if (this.getReferencePool() != null && this.getReferencePool().hasData()) {
                return true;
            }
            if (this.getNthToDefault() != null) {
                return true;
            }
            if (this.getMthToDefault() != null) {
                return true;
            }
            return this.getTranche() != null && this.getTranche().hasData();
        }

        public BasketReferenceInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BasketReferenceInformationBuilder o = (BasketReferenceInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasketName(), (RosettaModelObjectBuilder)o.getBasketName(), this::setBasketName);
            merger.mergeRosetta(this.getBasketId(), o.getBasketId(), this::getOrCreateBasketId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferencePool(), (RosettaModelObjectBuilder)o.getReferencePool(), this::setReferencePool);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTranche(), (RosettaModelObjectBuilder)o.getTranche(), this::setTranche);
            merger.mergeBasic((Object)this.getNthToDefault(), (Object)o.getNthToDefault(), this::setNthToDefault, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMthToDefault(), (Object)o.getMthToDefault(), this::setMthToDefault, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BasketReferenceInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.basketName, _that.getBasketName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketId, _that.getBasketId())) {
                return false;
            }
            if (!Objects.equals(this.referencePool, _that.getReferencePool())) {
                return false;
            }
            if (!Objects.equals(this.nthToDefault, _that.getNthToDefault())) {
                return false;
            }
            if (!Objects.equals(this.mthToDefault, _that.getMthToDefault())) {
                return false;
            }
            return Objects.equals(this.tranche, _that.getTranche());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.basketName != null ? this.basketName.hashCode() : 0);
            _result = 31 * _result + (this.basketId != null ? this.basketId.hashCode() : 0);
            _result = 31 * _result + (this.referencePool != null ? this.referencePool.hashCode() : 0);
            _result = 31 * _result + (this.nthToDefault != null ? this.nthToDefault.hashCode() : 0);
            _result = 31 * _result + (this.mthToDefault != null ? this.mthToDefault.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BasketReferenceInformationBuilder {basketName=" + this.basketName + ", basketId=" + this.basketId + ", referencePool=" + this.referencePool + ", nthToDefault=" + this.nthToDefault + ", mthToDefault=" + this.mthToDefault + ", tranche=" + this.tranche + '}';
        }
    }

    public static interface BasketReferenceInformationBuilder
    extends BasketReferenceInformation,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateBasketName();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getBasketName();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateBasketId(int var1);

        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getBasketId();

        public ReferencePool.ReferencePoolBuilder getOrCreateReferencePool();

        @Override
        public ReferencePool.ReferencePoolBuilder getReferencePool();

        public Tranche.TrancheBuilder getOrCreateTranche();

        @Override
        public Tranche.TrancheBuilder getTranche();

        public BasketReferenceInformationBuilder setBasketName(FieldWithMetaString var1);

        public BasketReferenceInformationBuilder setBasketNameValue(String var1);

        public BasketReferenceInformationBuilder addBasketId(FieldWithMetaString var1);

        public BasketReferenceInformationBuilder addBasketId(FieldWithMetaString var1, int var2);

        public BasketReferenceInformationBuilder addBasketIdValue(String var1);

        public BasketReferenceInformationBuilder addBasketIdValue(String var1, int var2);

        public BasketReferenceInformationBuilder addBasketId(List<? extends FieldWithMetaString> var1);

        public BasketReferenceInformationBuilder setBasketId(List<? extends FieldWithMetaString> var1);

        public BasketReferenceInformationBuilder addBasketIdValue(List<? extends String> var1);

        public BasketReferenceInformationBuilder setBasketIdValue(List<? extends String> var1);

        public BasketReferenceInformationBuilder setReferencePool(ReferencePool var1);

        public BasketReferenceInformationBuilder setNthToDefault(Integer var1);

        public BasketReferenceInformationBuilder setMthToDefault(Integer var1);

        public BasketReferenceInformationBuilder setTranche(Tranche var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("basketName"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getBasketName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketId"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getBasketId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referencePool"), processor, ReferencePool.ReferencePoolBuilder.class, this.getReferencePool(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nthToDefault"), Integer.class, (Object)this.getNthToDefault(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("mthToDefault"), Integer.class, (Object)this.getMthToDefault(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tranche"), processor, Tranche.TrancheBuilder.class, this.getTranche(), new AttributeMeta[0]);
        }

        public BasketReferenceInformationBuilder prune();
    }

    public static class BasketReferenceInformationImpl
    implements BasketReferenceInformation {
        private final FieldWithMetaString basketName;
        private final List<? extends FieldWithMetaString> basketId;
        private final ReferencePool referencePool;
        private final Integer nthToDefault;
        private final Integer mthToDefault;
        private final Tranche tranche;

        protected BasketReferenceInformationImpl(BasketReferenceInformationBuilder builder) {
            this.basketName = Optional.ofNullable(builder.getBasketName()).map(f -> f.build()).orElse(null);
            this.basketId = Optional.ofNullable(builder.getBasketId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.referencePool = Optional.ofNullable(builder.getReferencePool()).map(f -> f.build()).orElse(null);
            this.nthToDefault = builder.getNthToDefault();
            this.mthToDefault = builder.getMthToDefault();
            this.tranche = Optional.ofNullable(builder.getTranche()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="basketName")
        @RuneAttribute(value="basketName")
        public FieldWithMetaString getBasketName() {
            return this.basketName;
        }

        @Override
        @RosettaAttribute(value="basketId")
        @RuneAttribute(value="basketId")
        public List<? extends FieldWithMetaString> getBasketId() {
            return this.basketId;
        }

        @Override
        @RosettaAttribute(value="referencePool", isRequired=true)
        @RuneAttribute(value="referencePool", isRequired=true)
        public ReferencePool getReferencePool() {
            return this.referencePool;
        }

        @Override
        @RosettaAttribute(value="nthToDefault")
        @RuneAttribute(value="nthToDefault")
        public Integer getNthToDefault() {
            return this.nthToDefault;
        }

        @Override
        @RosettaAttribute(value="mthToDefault")
        @RuneAttribute(value="mthToDefault")
        public Integer getMthToDefault() {
            return this.mthToDefault;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public Tranche getTranche() {
            return this.tranche;
        }

        @Override
        public BasketReferenceInformation build() {
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder toBuilder() {
            BasketReferenceInformationBuilder builder = BasketReferenceInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BasketReferenceInformationBuilder builder) {
            Optional.ofNullable(this.getBasketName()).ifPresent(builder::setBasketName);
            Optional.ofNullable(this.getBasketId()).ifPresent(builder::setBasketId);
            Optional.ofNullable(this.getReferencePool()).ifPresent(builder::setReferencePool);
            Optional.ofNullable(this.getNthToDefault()).ifPresent(builder::setNthToDefault);
            Optional.ofNullable(this.getMthToDefault()).ifPresent(builder::setMthToDefault);
            Optional.ofNullable(this.getTranche()).ifPresent(builder::setTranche);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BasketReferenceInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.basketName, _that.getBasketName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketId, _that.getBasketId())) {
                return false;
            }
            if (!Objects.equals(this.referencePool, _that.getReferencePool())) {
                return false;
            }
            if (!Objects.equals(this.nthToDefault, _that.getNthToDefault())) {
                return false;
            }
            if (!Objects.equals(this.mthToDefault, _that.getMthToDefault())) {
                return false;
            }
            return Objects.equals(this.tranche, _that.getTranche());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.basketName != null ? this.basketName.hashCode() : 0);
            _result = 31 * _result + (this.basketId != null ? this.basketId.hashCode() : 0);
            _result = 31 * _result + (this.referencePool != null ? this.referencePool.hashCode() : 0);
            _result = 31 * _result + (this.nthToDefault != null ? this.nthToDefault.hashCode() : 0);
            _result = 31 * _result + (this.mthToDefault != null ? this.mthToDefault.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BasketReferenceInformation {basketName=" + this.basketName + ", basketId=" + this.basketId + ", referencePool=" + this.referencePool + ", nthToDefault=" + this.nthToDefault + ", mthToDefault=" + this.mthToDefault + ", tranche=" + this.tranche + '}';
        }
    }
}

