/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.esma.emir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import iso20022.auth030.esma.CreditDerivative4__1;
import iso20022.auth030.esma.DebtInstrumentSeniorityType2Code;
import iso20022.auth030.esma.DerivativePartyIdentification1Choice;
import iso20022.auth030.esma.Tranche3;
import iso20022.auth030.esma.TrancheIndicator3Choice;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetCdtDefault.class)
public abstract class GetCdt
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public CreditDerivative4__1 evaluate(ESMAEMIRTransactionReport drrReport) {
        CreditDerivative4__1 cdt;
        CreditDerivative4__1.CreditDerivative4__1Builder cdtBuilder = this.doEvaluate(drrReport);
        if (cdtBuilder == null) {
            cdt = null;
        } else {
            cdt = cdtBuilder.build();
            this.objectValidator.validate(CreditDerivative4__1.class, (RosettaModelObject)cdt);
        }
        return cdt;
    }

    protected abstract CreditDerivative4__1.CreditDerivative4__1Builder doEvaluate(ESMAEMIRTransactionReport var1);

    public static class GetCdtDefault
    extends GetCdt {
        @Override
        protected CreditDerivative4__1.CreditDerivative4__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport) {
            CreditDerivative4__1.CreditDerivative4__1Builder cdt = CreditDerivative4__1.builder();
            return this.assignOutput(cdt, drrReport);
        }

        protected CreditDerivative4__1.CreditDerivative4__1Builder assignOutput(CreditDerivative4__1.CreditDerivative4__1Builder cdt, ESMAEMIRTransactionReport drrReport) {
            TrancheIndicator3Choice ifThenElseResult = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getTranche", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getTranche()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult = TrancheIndicator3Choice.builder().setTrnchd(Tranche3.builder().setAttchmntPt((BigDecimal)MapperS.of((Object)drrReport).map("getCdSIndexAttachmentPoint", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getCdSIndexAttachmentPoint()).get()).setDtchmntPt((BigDecimal)MapperS.of((Object)drrReport).map("getCdSIndexDetachmentPoint", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getCdSIndexDetachmentPoint()).get()).build()).build();
            }
            cdt = (CreditDerivative4__1.CreditDerivative4__1Builder)this.toBuilder((RosettaModelObject)CreditDerivative4__1.builder().setSnrty((DebtInstrumentSeniorityType2Code)MapperS.of((Object)drrReport).map("getSeniority", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSeniority()).checkedMap("to-enum", DebtInstrumentSeniorityType2Code::fromDisplayName, IllegalArgumentException.class).get()).setRefPty(DerivativePartyIdentification1Choice.builder().setLei((String)MapperS.of((Object)drrReport).map("getReferenceEntity", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getReferenceEntity()).get()).build()).setSrs((Integer)MapperS.of((Object)drrReport).map("getSeries", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSeries()).get()).setVrsn((Integer)MapperS.of((Object)drrReport).map("getVersion", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getVersion()).get()).setIndxFctr((BigDecimal)MapperS.of((Object)drrReport).map("getIndexFactor", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getIndexFactor()).get()).setTrch(ifThenElseResult).build());
            return Optional.ofNullable(cdt).map(o -> o.prune()).orElse(null);
        }
    }
}

