/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.esma.emir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import java.time.ZonedDateTime;

@ImplementedBy(value=GetExctnTmStmpDefault.class)
public abstract class GetExctnTmStmp
implements RosettaFunction {
    public ZonedDateTime evaluate(ESMAEMIRTransactionReport drrReport) {
        ZonedDateTime exctnTmStmp = this.doEvaluate(drrReport);
        return exctnTmStmp;
    }

    protected abstract ZonedDateTime doEvaluate(ESMAEMIRTransactionReport var1);

    public static class GetExctnTmStmpDefault
    extends GetExctnTmStmp {
        @Override
        protected ZonedDateTime doEvaluate(ESMAEMIRTransactionReport drrReport) {
            ZonedDateTime exctnTmStmp = null;
            return this.assignOutput(exctnTmStmp, drrReport);
        }

        protected ZonedDateTime assignOutput(ZonedDateTime exctnTmStmp, ESMAEMIRTransactionReport drrReport) {
            exctnTmStmp = (ZonedDateTime)MapperS.of((Object)drrReport).map("getExecutionTimestamp", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getExecutionTimestamp()).get();
            return exctnTmStmp;
        }
    }
}

