/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.esma.emir.refit.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.util.functions.StringLength;
import drr.regulation.common.util.functions.SubString;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.esma.ActiveOrHistoricCurrencyAnd13DecimalAmount__1;
import iso20022.auth030.esma.ActiveOrHistoricCurrencyAnd5DecimalAmount__1;
import iso20022.auth030.esma.AmountAndDirection106__1;
import iso20022.auth030.esma.OptionOrSwaption10__1;
import iso20022.auth030.esma.OptionStyle6Code__1;
import iso20022.auth030.esma.OptionType2Code;
import iso20022.auth030.esma.Schedule4__1;
import iso20022.auth030.esma.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetOptnDefault.class)
public abstract class GetOptn
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;
    @Inject
    protected StringLength stringLength;
    @Inject
    protected SubString subString;

    public OptionOrSwaption10__1 evaluate(ESMAEMIRTransactionReport drrReport) {
        OptionOrSwaption10__1 optn;
        OptionOrSwaption10__1.OptionOrSwaption10__1Builder optnBuilder = this.doEvaluate(drrReport);
        if (optnBuilder == null) {
            optn = null;
        } else {
            optn = optnBuilder.build();
            this.objectValidator.validate(OptionOrSwaption10__1.class, (RosettaModelObject)optn);
        }
        return optn;
    }

    protected abstract OptionOrSwaption10__1.OptionOrSwaption10__1Builder doEvaluate(ESMAEMIRTransactionReport var1);

    public static class GetOptnDefault
    extends GetOptn {
        @Override
        protected OptionOrSwaption10__1.OptionOrSwaption10__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport) {
            OptionOrSwaption10__1.OptionOrSwaption10__1Builder optn = OptionOrSwaption10__1.builder();
            return this.assignOutput(optn, drrReport);
        }

        protected OptionOrSwaption10__1.OptionOrSwaption10__1Builder assignOutput(OptionOrSwaption10__1.OptionOrSwaption10__1Builder optn, ESMAEMIRTransactionReport drrReport) {
            optn = (OptionOrSwaption10__1.OptionOrSwaption10__1Builder)this.toBuilder((RosettaModelObject)OptionOrSwaption10__1.builder().setTp((OptionType2Code)MapperS.of((Object)drrReport).map("getOptionType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionType()).checkedMap("to-enum", OptionType2Code::fromDisplayName, IllegalArgumentException.class).get()).setExrcStyle((OptionStyle6Code__1)MapperS.of((Object)drrReport).map("getOptionStyle", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionStyle()).checkedMap("to-enum", OptionStyle6Code__1::fromDisplayName, IllegalArgumentException.class).get()).setStrkPric((SecuritiesTransactionPrice17Choice__1)MapperS.of((Object)drrReport).map("getStrikePrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePrice()).mapSingleToItem(item -> {
                AmountAndDirection106__1 ifThenElseResult2 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getStrikePriceNotation", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    String ifThenElseResult0 = null;
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()), (Mapper)MapperS.of((Object)"OPTN"), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()), (Mapper)MapperS.of((Object)"SWPT"), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)"INTR"), (CardinalityOperator)CardinalityOperator.All), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult0 = ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)this.stringLength.evaluate((String)item.map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get())), (Mapper)MapperS.of((Object)3), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.subString.evaluate((String)item.map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get(), 5, 3) : (String)item.map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get();
                    }
                    Boolean ifThenElseResult1 = null;
                    if (ExpressionOperators.lessThan((Mapper)item.map("getStrikePriceMonetary", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult1 = false;
                    }
                    ifThenElseResult2 = AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getStrikePriceMonetary", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceMonetary()).get())).setCcy(ifThenElseResult0).build()).setSgn(ifThenElseResult1).build();
                }
                BigDecimal ifThenElseResult3 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getStrikePriceNotation", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.PERCENTAGE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult3 = (BigDecimal)item.map("getStrikePricePercentage", strikePriceAndNotation -> strikePriceAndNotation.getStrikePricePercentage()).get();
                }
                return MapperS.of((Object)SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(ifThenElseResult2).setPctg(ifThenElseResult3).build());
            }).get()).setStrkPricSchdl(MapperS.of((Object)drrReport).mapC("getStrikePriceSchedule", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePriceSchedule()).mapItem(item -> {
                AmountAndDirection106__1 ifThenElseResult2 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getStrikePriceNotationInEffectOnAssociatedEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceNotationInEffectOnAssociatedEffectiveDate()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    String ifThenElseResult0 = null;
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()), (Mapper)MapperS.of((Object)"OPTN"), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()), (Mapper)MapperS.of((Object)"SWPT"), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)"INTR"), (CardinalityOperator)CardinalityOperator.All), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult0 = ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)this.stringLength.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePrice()).map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).map("to-string", Object::toString).get())), (Mapper)MapperS.of((Object)3), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePrice()).map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).map("to-string", Object::toString).get(), 5, 3) : (String)MapperS.of((Object)drrReport).map("getStrikePrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePrice()).map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).map("to-string", Object::toString).get();
                    }
                    Boolean ifThenElseResult1 = null;
                    if (ExpressionOperators.lessThan((Mapper)item.map("getStrikePriceInEffectOnAssociatedEffectiveDateMonetary", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult1 = false;
                    }
                    ifThenElseResult2 = AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getStrikePriceInEffectOnAssociatedEffectiveDateMonetary", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()).get())).setCcy(ifThenElseResult0).build()).setSgn(ifThenElseResult1).build();
                }
                BigDecimal ifThenElseResult3 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getStrikePriceNotationInEffectOnAssociatedEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceNotationInEffectOnAssociatedEffectiveDate()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.PERCENTAGE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult3 = (BigDecimal)item.map("getStrikePriceInEffectOnAssociatedEffectiveDatePercentage", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDatePercentage()).get();
                }
                return MapperS.of((Object)Schedule4__1.builder().setUadjstdFctvDt((Date)item.map("getEffectiveDateStrikePrice", strikePriceScheduleReport -> strikePriceScheduleReport.getEffectiveDateStrikePrice()).get()).setUadjstdEndDt((Date)item.map("getEndDateStrikePrice", strikePriceScheduleReport -> strikePriceScheduleReport.getEndDateStrikePrice()).get()).setPric(SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(ifThenElseResult2).setPctg(ifThenElseResult3).build()).build());
            }).getMulti()).setPrmAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount__1.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionPremiumAmount()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setPrmPmtDt((Date)MapperS.of((Object)drrReport).map("getOptionPremiumPaymentDate", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionPremiumPaymentDate()).get()).setMtrtyDtOfUndrlyg((Date)MapperS.of((Object)drrReport).map("getMaturityDateOfTheUnderlying", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getMaturityDateOfTheUnderlying()).get()).build());
            return Optional.ofNullable(optn).map(o -> o.prune()).orElse(null);
        }
    }
}

