/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.asic.rewrite.trade.BasketConstituentsReport;
import drr.regulation.asic.rewrite.trade.meta.BasketMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Basket", builder=BasketBuilderImpl.class, version="5.52.0")
@RuneDataType(value="Basket", model="drr", builder=BasketBuilderImpl.class, version="5.52.0")
public interface Basket
extends RosettaModelObject {
    public static final BasketMeta metaData = new BasketMeta();

    public List<? extends BasketConstituentsReport> getBasketConstituents();

    public Basket build();

    public BasketBuilder toBuilder();

    public static BasketBuilder builder() {
        return new BasketBuilderImpl();
    }

    default public RosettaMetaData<? extends Basket> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Basket> getType() {
        return Basket.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, this.getBasketConstituents(), new AttributeMeta[0]);
    }

    public static class BasketBuilderImpl
    implements BasketBuilder {
        protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> basketConstituents = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents() {
            return this.basketConstituents;
        }

        @Override
        public BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int index) {
            if (this.basketConstituents == null) {
                this.basketConstituents = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
            }
            return (BasketConstituentsReport.BasketConstituentsReportBuilder)this.getIndex(this.basketConstituents, index, () -> {
                BasketConstituentsReport.BasketConstituentsReportBuilder newBasketConstituents = BasketConstituentsReport.builder();
                return newBasketConstituents;
            });
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public BasketBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
            if (_basketConstituents != null) {
                this.basketConstituents.add(_basketConstituents.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
            this.getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            if (basketConstituentss != null) {
                for (BasketConstituentsReport basketConstituentsReport : basketConstituentss) {
                    this.basketConstituents.add(basketConstituentsReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituents")
        public BasketBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            this.basketConstituents = basketConstituentss == null ? new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>() : (List)basketConstituentss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Basket build() {
            return new BasketImpl(this);
        }

        @Override
        public BasketBuilder toBuilder() {
            return this;
        }

        @Override
        public BasketBuilder prune() {
            this.basketConstituents = this.basketConstituents.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            return this.getBasketConstituents() != null && this.getBasketConstituents().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public BasketBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BasketBuilder o = (BasketBuilder)other;
            merger.mergeRosetta(this.getBasketConstituents(), o.getBasketConstituents(), this::getOrCreateBasketConstituents);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Basket _that = this.getType().cast(o);
            return ListEquals.listEquals(this.basketConstituents, _that.getBasketConstituents());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.basketConstituents != null ? this.basketConstituents.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BasketBuilder {basketConstituents=" + String.valueOf(this.basketConstituents) + "}";
        }
    }

    public static interface BasketBuilder
    extends Basket,
    RosettaModelObjectBuilder {
        public BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int var1);

        public List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents();

        public BasketBuilder addBasketConstituents(BasketConstituentsReport var1);

        public BasketBuilder addBasketConstituents(BasketConstituentsReport var1, int var2);

        public BasketBuilder addBasketConstituents(List<? extends BasketConstituentsReport> var1);

        public BasketBuilder setBasketConstituents(List<? extends BasketConstituentsReport> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, this.getBasketConstituents(), new AttributeMeta[0]);
        }

        public BasketBuilder prune();
    }

    public static class BasketImpl
    implements Basket {
        private final List<? extends BasketConstituentsReport> basketConstituents;

        protected BasketImpl(BasketBuilder builder) {
            this.basketConstituents = Optional.ofNullable(builder.getBasketConstituents()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public List<? extends BasketConstituentsReport> getBasketConstituents() {
            return this.basketConstituents;
        }

        @Override
        public Basket build() {
            return this;
        }

        @Override
        public BasketBuilder toBuilder() {
            BasketBuilder builder = Basket.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BasketBuilder builder) {
            Optional.ofNullable(this.getBasketConstituents()).ifPresent(builder::setBasketConstituents);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Basket _that = this.getType().cast(o);
            return ListEquals.listEquals(this.basketConstituents, _that.getBasketConstituents());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.basketConstituents != null ? this.basketConstituents.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Basket {basketConstituents=" + String.valueOf(this.basketConstituents) + "}";
        }
    }
}

