/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsFRA;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.reports.CDEEffectiveDateRule;
import javax.inject.Inject;

@ImplementedBy(value=EffectiveDateRuleDefault.class)
public abstract class EffectiveDateRule
implements ReportFunction<TransactionReportInstruction, Date> {
    @Inject
    protected CDEEffectiveDateRule cDEEffectiveDateRule;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;
    @Inject
    protected IsFRA isFRA;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected TradeForEvent tradeForEvent;

    public Date evaluate(TransactionReportInstruction input) {
        Date output = this.doEvaluate(input);
        return output;
    }

    protected abstract Date doEvaluate(TransactionReportInstruction var1);

    public static class EffectiveDateRuleDefault
    extends EffectiveDateRule {
        @Override
        protected Date doEvaluate(TransactionReportInstruction input) {
            Date output = null;
            return this.assignOutput(output, input);
        }

        protected Date assignOutput(Date output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEvent)item.get()));
            output = (Date)thenArg.mapSingleToItem(item -> {
                Boolean _boolean = this.isFRA.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get()));
                if (_boolean != null && _boolean.booleanValue()) {
                    return MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEvent)item.get())).map("getTradeDate", trade -> trade.getTradeDate()).map("Type coercion", fieldWithMetaDate -> fieldWithMetaDate == null ? null : fieldWithMetaDate.getValue());
                }
                return MapperS.of((Object)this.cDEEffectiveDateRule.evaluate((TransactionReportInstruction)item.get()));
            }).get();
            return output;
        }
    }
}

