/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.party.LegalEntity;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.IsCreditDefaultSwap;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.regulation.common.util.functions.StringContains;
import javax.inject.Inject;

@ImplementedBy(value=ExtractReferenceEntityDefault.class)
public abstract class ExtractReferenceEntity
implements RosettaFunction {
    @Inject
    protected IsCreditDefaultSwap isCreditDefaultSwap;
    @Inject
    protected IsCreditSwaption isCreditSwaption;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected StringContains stringContains;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public String evaluate(ReportableEvent reportableEvent) {
        String referenceEntity = this.doEvaluate(reportableEvent);
        return referenceEntity;
    }

    protected abstract String doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends Product> product(ReportableEvent var1);

    protected abstract MapperS<? extends LegalEntity> referenceEntityProduct(ReportableEvent var1);

    protected abstract MapperS<? extends FieldWithMetaString> referenceEntityByScheme(ReportableEvent var1);

    public static class ExtractReferenceEntityDefault
    extends ExtractReferenceEntity {
        @Override
        protected String doEvaluate(ReportableEvent reportableEvent) {
            String referenceEntity = null;
            return this.assignOutput(referenceEntity, reportableEvent);
        }

        protected String assignOutput(String referenceEntity, ReportableEvent reportableEvent) {
            MapperC thenArg = ExpressionOperators.exists(this.referenceEntityByScheme(reportableEvent)).and(ExpressionOperators.notEqual((Mapper)this.referenceEntityByScheme(reportableEvent).map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), (Mapper)MapperS.of((Object)""), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)) != false ? MapperC.of((MapperBuilder[])new MapperBuilder[]{this.referenceEntityByScheme(reportableEvent)}) : this.referenceEntityProduct(reportableEvent).mapC("getEntityId", legalEntity -> legalEntity.getEntityId());
            FieldWithMetaString fieldWithMetaString1 = (FieldWithMetaString)thenArg.last().get();
            referenceEntity = fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue();
            return referenceEntity;
        }

        @Override
        protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.productForEvent.evaluate(reportableEvent));
        }

        @Override
        protected MapperS<? extends LegalEntity> referenceEntityProduct(ReportableEvent reportableEvent) {
            Boolean boolean0 = this.isCreditSwaption.evaluate((Product)this.product(reportableEvent).get());
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)this.underlierForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity());
            }
            Boolean boolean1 = this.isCreditDefaultSwap.evaluate((Product)this.product(reportableEvent).get());
            if (boolean1 != null && boolean1.booleanValue()) {
                return this.product(reportableEvent).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends FieldWithMetaString> referenceEntityByScheme(ReportableEvent reportableEvent) {
            MapperC thenArg0 = this.referenceEntityProduct(reportableEvent).mapC("getEntityId", legalEntity -> legalEntity.getEntityId());
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ComparisonResult.of((Mapper)MapperS.of((Object)this.stringContains.evaluate((String)item.map("getMeta", a -> a.getMeta()).map("getScheme", a -> a.getScheme()).get(), "http://www.fpml.org/coding-scheme/external/iso17442"))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.stringContains.evaluate((String)item.map("getMeta", a -> a.getMeta()).map("getScheme", a -> a.getScheme()).get(), "http://www.fpml.org/coding-scheme/external/iso3166")))).get());
            return thenArg1.first();
        }
    }
}

