/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.datetime.Frequency;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;

@ImplementedBy(value=FrequencyPeriodDefault.class)
public abstract class FrequencyPeriod
implements RosettaFunction {
    public String evaluate(PriceQuantity priceQuantity, Frequency frequency) {
        String period = this.doEvaluate(priceQuantity, frequency);
        return period;
    }

    protected abstract String doEvaluate(PriceQuantity var1, Frequency var2);

    protected abstract MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity(PriceQuantity var1, Frequency var2);

    public static class FrequencyPeriodDefault
    extends FrequencyPeriod {
        @Override
        protected String doEvaluate(PriceQuantity priceQuantity, Frequency frequency) {
            String period = null;
            return this.assignOutput(period, priceQuantity, frequency);
        }

        protected String assignOutput(String period, PriceQuantity priceQuantity, Frequency frequency) {
            period = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)frequency).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? "DAIL" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)frequency).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.W), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? "WEEK" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)frequency).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.M), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? "MNTH" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)frequency).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.Y), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? "YEAR" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)frequency).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.T), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? "EXPI" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)frequency).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.H), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? "HOUL" : (ExpressionOperators.notExists((Mapper)MapperS.of((Object)frequency)).and(ExpressionOperators.exists(this.quantity(priceQuantity, frequency))).getOrDefault(Boolean.valueOf(false)) != false ? "ADHO" : null))))));
            return period;
        }

        @Override
        protected MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity(PriceQuantity priceQuantity, Frequency frequency) {
            return MapperS.of((Object)priceQuantity).mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity()).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule0 -> fieldWithMetaNonNegativeQuantitySchedule0 == null ? null : fieldWithMetaNonNegativeQuantitySchedule0.getValue()).map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency())).and(ExpressionOperators.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule1 -> fieldWithMetaNonNegativeQuantitySchedule1 == null ? null : fieldWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)ExpressionOperators.distinct((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule2 -> fieldWithMetaNonNegativeQuantitySchedule2 == null ? null : fieldWithMetaNonNegativeQuantitySchedule2.getValue()).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).map("getValue", datedValue -> datedValue.getValue())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All))).get());
        }
    }
}

