/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.observable.asset.PriceSchedule;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.SchedulePeriod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.Contract_StrikePrice;
import drr.regulation.common.functions.Create_PriceReportablePeriod;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.GetPriceNotation;
import drr.regulation.common.functions.IsCommodityOption;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetReportableStrikePricePeriodDefault.class)
public abstract class GetReportableStrikePricePeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Contract_StrikePrice contract_StrikePrice;
    @Inject
    protected Create_PriceReportablePeriod create_PriceReportablePeriod;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected GetPriceNotation getPriceNotation;
    @Inject
    protected IsCommodityOption isCommodityOption;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
    @Inject
    protected TradeForEvent tradeForEvent;

    public List<? extends PriceReportablePeriod> evaluate(ReportableEvent reportableEvent) {
        List reportablePeriod;
        List<PriceReportablePeriod.PriceReportablePeriodBuilder> reportablePeriodBuilder = this.doEvaluate(reportableEvent);
        if (reportablePeriodBuilder == null) {
            reportablePeriod = null;
        } else {
            reportablePeriod = reportablePeriodBuilder.stream().map(PriceReportablePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(PriceReportablePeriod.class, reportablePeriod);
        }
        return reportablePeriod;
    }

    protected abstract List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent var1);

    protected abstract MapperS<? extends PriceSchedule> strikePriceSchedule(ReportableEvent var1);

    protected abstract MapperS<PriceNotationEnum> priceNotation(ReportableEvent var1);

    public static class GetReportableStrikePricePeriodDefault
    extends GetReportableStrikePricePeriod {
        @Override
        protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(ReportableEvent reportableEvent) {
            ArrayList<PriceReportablePeriod.PriceReportablePeriodBuilder> reportablePeriod = new ArrayList<PriceReportablePeriod.PriceReportablePeriodBuilder>();
            return this.assignOutput(reportablePeriod, reportableEvent);
        }

        protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> assignOutput(List<PriceReportablePeriod.PriceReportablePeriodBuilder> reportablePeriod, ReportableEvent reportableEvent) {
            if (ExpressionOperators.exists(this.customizedSchedule(reportableEvent)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                reportablePeriod.addAll(this.toBuilder(this.strikePriceSchedule(reportableEvent).mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue()).mapItem(pricePeriod -> {
                    MapperC thenArg0 = this.customizedSchedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).filterItemNullSafe(customPeriod -> ExpressionOperators.areEqual((Mapper)pricePeriod.map("getDate", datedValue -> datedValue.getDate()), (Mapper)customPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()), (CardinalityOperator)CardinalityOperator.All).get());
                    MapperS thenArg1 = MapperS.of((Object)((SchedulePeriod)thenArg0.get()));
                    return thenArg1.mapSingleToItem(matchingCustomPeriod -> MapperS.of((Object)this.create_PriceReportablePeriod.evaluate((BigDecimal)pricePeriod.map("getValue", datedValue -> datedValue.getValue()).get(), (Date)matchingCustomPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()).get(), (Date)matchingCustomPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getEndDate", dateRange -> dateRange.getEndDate()).get(), (PriceNotationEnum)((Object)((Object)((Object)this.priceNotation(reportableEvent).get()))))));
                }).getMulti()));
            } else {
                reportablePeriod.addAll(this.toBuilder(this.strikePriceSchedule(reportableEvent).mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue()).mapItem(pricePeriod -> MapperS.of((Object)this.create_PriceReportablePeriod.evaluate((BigDecimal)pricePeriod.map("getValue", datedValue -> datedValue.getValue()).get(), (Date)pricePeriod.map("getDate", datedValue -> datedValue.getDate()).get(), null, (PriceNotationEnum)((Object)((Object)this.priceNotation(reportableEvent).get()))))).getMulti()));
            }
            return Optional.ofNullable(reportablePeriod).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent reportableEvent) {
            if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isCommodityOption.evaluate(this.productForTrade.evaluate(this.tradeForEvent.evaluate(reportableEvent))))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swaption.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(this.tradeForEvent.evaluate(reportableEvent))))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((CalculationSchedule)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(this.tradeForEvent.evaluate(reportableEvent)))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getSchedule", optionPayout -> optionPayout.getSchedule()).get()));
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends PriceSchedule> strikePriceSchedule(ReportableEvent reportableEvent) {
            return MapperS.of((Object)((PriceSchedule)MapperC.of(this.contract_StrikePrice.evaluate(reportableEvent)).get()));
        }

        @Override
        protected MapperS<PriceNotationEnum> priceNotation(ReportableEvent reportableEvent) {
            return MapperS.of((Object)((Object)this.getPriceNotation.evaluate((PriceSchedule)this.strikePriceSchedule(reportableEvent).get())));
        }
    }
}

