/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.datetime.Frequency;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.math.CapacityUnitEnum;
import cdm.base.math.Quantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.DeliveryCapacity;
import iso20022.auth030.esma.EnergyQuantityUnit2Code;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=QuantityToDeliveryCapacityDefault.class)
public abstract class QuantityToDeliveryCapacity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public DeliveryCapacity evaluate(Quantity quantity) {
        DeliveryCapacity deliveryCapacity;
        DeliveryCapacity.DeliveryCapacityBuilder deliveryCapacityBuilder = this.doEvaluate(quantity);
        if (deliveryCapacityBuilder == null) {
            deliveryCapacity = null;
        } else {
            deliveryCapacity = deliveryCapacityBuilder.build();
            this.objectValidator.validate(DeliveryCapacity.class, (RosettaModelObject)deliveryCapacity);
        }
        return deliveryCapacity;
    }

    protected abstract DeliveryCapacity.DeliveryCapacityBuilder doEvaluate(Quantity var1);

    protected abstract MapperS<CapacityUnitEnum> capacityUnit(Quantity var1);

    protected abstract MapperS<? extends Frequency> frequency(Quantity var1);

    public static class QuantityToDeliveryCapacityDefault
    extends QuantityToDeliveryCapacity {
        @Override
        protected DeliveryCapacity.DeliveryCapacityBuilder doEvaluate(Quantity quantity) {
            DeliveryCapacity.DeliveryCapacityBuilder deliveryCapacity = DeliveryCapacity.builder();
            return this.assignOutput(deliveryCapacity, quantity);
        }

        protected DeliveryCapacity.DeliveryCapacityBuilder assignOutput(DeliveryCapacity.DeliveryCapacityBuilder deliveryCapacity, Quantity quantity) {
            deliveryCapacity = ExpressionOperators.areEqual(this.capacityUnit(quantity), (Mapper)MapperS.of((Object)CapacityUnitEnum.KW), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()).get()).setUnit(EnergyQuantityUnit2Code.KWAT).build()) : (ExpressionOperators.areEqual(this.capacityUnit(quantity), (Mapper)MapperS.of((Object)CapacityUnitEnum.MW), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()).get()).setUnit(EnergyQuantityUnit2Code.MWAT).build()) : (ExpressionOperators.areEqual(this.capacityUnit(quantity), (Mapper)MapperS.of((Object)CapacityUnitEnum.GW), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()).get()).setUnit(EnergyQuantityUnit2Code.GWAT).build()) : (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)CapacityUnitEnum.GBBTU), MapperS.of((Object)CapacityUnitEnum.ISOBTU), MapperS.of((Object)CapacityUnitEnum.USBTU)}), this.capacityUnit(quantity), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer0 -> integer0 == null ? null : BigDecimal.valueOf(integer0.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.BTUD).build()) : null) : (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)CapacityUnitEnum.GBMBTU), MapperS.of((Object)CapacityUnitEnum.ISOMBTU), MapperS.of((Object)CapacityUnitEnum.USMBTU)}), this.capacityUnit(quantity), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)new BigDecimal("1000.0")), (Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue())), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer1 -> integer1 == null ? null : BigDecimal.valueOf(integer1.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.BTUD).build()) : null) : (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)CapacityUnitEnum.GBMMBTU), MapperS.of((Object)CapacityUnitEnum.ISOMMBTU), MapperS.of((Object)CapacityUnitEnum.USMMBTU)}), this.capacityUnit(quantity), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer2 -> integer2 == null ? null : BigDecimal.valueOf(integer2.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.MBTD).build()) : null) : (ExpressionOperators.areEqual(this.capacityUnit(quantity), (Mapper)MapperS.of((Object)CapacityUnitEnum.CBM), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer3 -> integer3 == null ? null : BigDecimal.valueOf(integer3.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.CMPD).build()) : null) : (ExpressionOperators.areEqual(this.capacityUnit(quantity), (Mapper)MapperS.of((Object)CapacityUnitEnum.L), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)MapperMaths.multiply((Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer4 -> integer4 == null ? null : BigDecimal.valueOf(integer4.intValue())), (Mapper)MapperS.of((Object)new BigDecimal("1000.0")))).get()).setUnit(EnergyQuantityUnit2Code.CMPD).build()) : null) : (ExpressionOperators.areEqual(this.capacityUnit(quantity), (Mapper)MapperS.of((Object)CapacityUnitEnum.HL), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)MapperMaths.multiply((Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer5 -> integer5 == null ? null : BigDecimal.valueOf(integer5.intValue())), (Mapper)MapperS.of((Object)new BigDecimal("10.0")))).get()).setUnit(EnergyQuantityUnit2Code.CMPD).build()) : null) : (ExpressionOperators.areEqual(this.capacityUnit(quantity), (Mapper)MapperS.of((Object)CapacityUnitEnum.KL), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer6 -> integer6 == null ? null : BigDecimal.valueOf(integer6.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.CMPD).build()) : null) : (ExpressionOperators.areEqual(this.capacityUnit(quantity), (Mapper)MapperS.of((Object)CapacityUnitEnum.MJ), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer7 -> integer7 == null ? null : BigDecimal.valueOf(integer7.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.MJDD).build()) : null) : (ExpressionOperators.areEqual(this.capacityUnit(quantity), (Mapper)MapperS.of((Object)CapacityUnitEnum.GJ), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer8 -> integer8 == null ? null : BigDecimal.valueOf(integer8.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.GJDD).build()) : null) : (ExpressionOperators.areEqual(this.capacityUnit(quantity), (Mapper)MapperS.of((Object)CapacityUnitEnum.KWH), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.H), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer9 -> integer9 == null ? null : BigDecimal.valueOf(integer9.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.KWHH).build()) : (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer10 -> integer10 == null ? null : BigDecimal.valueOf(integer10.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.KWHD).build()) : null)) : (ExpressionOperators.areEqual(this.capacityUnit(quantity), (Mapper)MapperS.of((Object)CapacityUnitEnum.MWH), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.H), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer11 -> integer11 == null ? null : BigDecimal.valueOf(integer11.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.MWHH).build()) : (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer12 -> integer12 == null ? null : BigDecimal.valueOf(integer12.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.MWHD).build()) : null)) : (ExpressionOperators.areEqual(this.capacityUnit(quantity), (Mapper)MapperS.of((Object)CapacityUnitEnum.GWH), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.H), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer13 -> integer13 == null ? null : BigDecimal.valueOf(integer13.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.GWHH).build()) : (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer14 -> integer14 == null ? null : BigDecimal.valueOf(integer14.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.GWHD).build()) : null)) : (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)CapacityUnitEnum.GBTHM), MapperS.of((Object)CapacityUnitEnum.ISOTHM), MapperS.of((Object)CapacityUnitEnum.USTHM)}), this.capacityUnit(quantity), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)this.frequency(quantity).map("getPeriod", _frequency -> _frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.D), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryCapacity.DeliveryCapacityBuilder)this.toBuilder(DeliveryCapacity.builder().setAmount((BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()), (Mapper)this.frequency(quantity).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).map("Type coercion", integer15 -> integer15 == null ? null : BigDecimal.valueOf(integer15.intValue()))).get()).setUnit(EnergyQuantityUnit2Code.THMD).build()) : null) : null)))))))))))))));
            return Optional.ofNullable(deliveryCapacity).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<CapacityUnitEnum> capacityUnit(Quantity quantity) {
            return MapperS.of((Object)quantity).map("getUnit", _quantity -> _quantity.getUnit()).map("getCapacityUnit", unitType -> unitType.getCapacityUnit());
        }

        @Override
        protected MapperS<? extends Frequency> frequency(Quantity quantity) {
            return MapperS.of((Object)quantity).map("getFrequency", _quantity -> _quantity.getFrequency());
        }
    }
}

