/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.processor;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.CorporateSector;
import drr.regulation.common.FinancialSectorEnum;
import drr.regulation.common.NonFinancialSector;
import drr.regulation.common.NonFinancialSectorEnum;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegimeInformationMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegimeInformationMappingProcessor.class);
    public static final String ESMA_CORPORATE_SECTOR_SCHEME = "http://www.fpml.org/coding-scheme/esma-emir-refit-regulatory-corporate-sector";

    public RegimeInformationMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent) {
        PartyInformation.PartyInformationBuilder partyInformationBuilder = (PartyInformation.PartyInformationBuilder)parent;
        List<? extends RosettaModelObjectBuilder> reportingRegimeBuilders = builders;
        List<Path> classificationPaths = this.getClassificationPaths(partyInformationBuilder);
        this.setCorporateSector(reportingRegimeBuilders, classificationPaths, SupervisoryBodyEnum.ESMA);
        this.setCorporateSector(reportingRegimeBuilders, classificationPaths, SupervisoryBodyEnum.FCA);
        this.setTechnicalRecordId(reportingRegimeBuilders);
    }

    private void setCorporateSector(List<ReportingRegime.ReportingRegimeBuilder> reportingRegimeBuilders, List<Path> classificationPaths, SupervisoryBodyEnum supervisoryBody) {
        reportingRegimeBuilders.stream().filter(b -> this.isSupervisoryBody((ReportingRegime.ReportingRegimeBuilder)b, supervisoryBody)).findFirst().ifPresent(reportingRegimeBuilder -> {
            for (Path classificationPath : classificationPaths) {
                MappingProcessorUtils.getNonNullMappedValue((Path)classificationPath.addElement("industryClassificationScheme"), (List)this.getMappings()).filter(ESMA_CORPORATE_SECTOR_SCHEME::equals).ifPresent(industryClassificationScheme -> MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)classificationPath, classificationValue -> {
                    CorporateSector.CorporateSectorBuilder corporateSectorBuilder = CorporateSector.builder();
                    this.getFinancialSectorEnum((String)classificationValue).ifPresent(financialSector -> corporateSectorBuilder.addFinancialSector((FinancialSectorEnum)((Object)((Object)((Object)((Object)financialSector))))));
                    this.getNonFinancialSector((String)classificationValue).ifPresent(nonFinancialSector -> corporateSectorBuilder.addNonFinancialSector((NonFinancialSector)nonFinancialSector));
                    if (corporateSectorBuilder.hasData()) {
                        this.updatePartyInformationForRegime((ReportingRegime.ReportingRegimeBuilder)reportingRegimeBuilder, corporateSectorBuilder);
                        return true;
                    }
                    return false;
                }, (List)this.getMappings(), (RosettaPath)this.getModelPath()));
            }
        });
    }

    private void setTechnicalRecordId(List<ReportingRegime.ReportingRegimeBuilder> reportingRegimeBuilders) {
        List messageIdSchemePaths = this.getMappings().stream().filter(m -> m.getXmlPath().endsWith(new String[]{"messageIdScheme"})).map(Mapping::getXmlPath).collect(Collectors.toList());
        for (Path messageIdSchemePath : messageIdSchemePaths) {
            Optional mappedValue = MappingProcessorUtils.getNonNullMappedValue((Path)messageIdSchemePath, (List)this.getMappings());
            if (!mappedValue.isPresent() || !((String)mappedValue.get()).equals("http://www.fpml.org/coding-scheme/external/technical-record-id")) continue;
            Path messageIdPath = messageIdSchemePath.getParent();
            Optional messageId = MappingProcessorUtils.getNonNullMappedValue((Path)messageIdPath, (List)this.getMappings());
            messageId.ifPresent(id -> {
                FieldWithMetaString fieldWithMetaString = FieldWithMetaString.builder().setValue((String)id).build();
                reportingRegimeBuilders.stream().filter(this::isRelevantSupervisoryBody).forEach(reportingRegimeBuilder -> {
                    if (fieldWithMetaString != null) {
                        reportingRegimeBuilder.setTechnicalRecordId(fieldWithMetaString);
                    }
                });
            });
        }
    }

    private boolean isRelevantSupervisoryBody(ReportingRegime.ReportingRegimeBuilder reportingRegimeBuilder) {
        FieldWithMetaSupervisoryBodyEnum.FieldWithMetaSupervisoryBodyEnumBuilder supervisoryBodyField = reportingRegimeBuilder.getSupervisoryBody();
        if (supervisoryBodyField != null) {
            SupervisoryBodyEnum supervisoryBodyEnum = supervisoryBodyField.getValue();
            return supervisoryBodyEnum == SupervisoryBodyEnum.ASIC || supervisoryBodyEnum == SupervisoryBodyEnum.JFSA || supervisoryBodyEnum == SupervisoryBodyEnum.MAS;
        }
        return false;
    }

    private Boolean isSupervisoryBody(ReportingRegime.ReportingRegimeBuilder reportingRegime, SupervisoryBodyEnum supervisoryBody) {
        return Optional.ofNullable(reportingRegime.getSupervisoryBody()).map(FieldWithMetaSupervisoryBodyEnum::getValue).map(supervisoryBody::equals).orElse(false);
    }

    private List<Path> getClassificationPaths(PartyInformation.PartyInformationBuilder partyInformationBuilder) {
        return Optional.ofNullable(partyInformationBuilder.getPartyReference()).map(ReferenceWithMetaParty::getExternalReference).map(partyReference -> this.getClassificationPathsForParty((String)partyReference)).orElse(Collections.emptyList());
    }

    private List<Path> getClassificationPathsForParty(String partyReference) {
        ArrayList<Path> partyClassificationPaths = new ArrayList<Path>();
        Optional<Path> partyPath = this.getPartyPath(partyReference, "party", "id");
        partyPath.ifPresent(path -> {
            String partyPathStr = path.toString();
            for (Mapping mapping : this.getMappings()) {
                Path xmlPath = mapping.getXmlPath();
                if (mapping.getXmlValue() == null || xmlPath == null || !xmlPath.toString().startsWith(partyPathStr) || !xmlPath.endsWith(new String[]{"classification"})) continue;
                partyClassificationPaths.add(xmlPath);
            }
        });
        return partyClassificationPaths;
    }

    private Optional<Path> getPartyPath(String xmlValue, String ... xmlPathEndsWith) {
        return this.getMappings().stream().filter(m -> m.getXmlPath().endsWith(xmlPathEndsWith)).filter(m -> {
            Object xmlValueObj = m.getXmlValue();
            String xmlValueStr = xmlValueObj != null ? xmlValueObj.toString() : null;
            return Objects.equals(xmlValueStr, xmlValue);
        }).map(m -> m.getXmlPath()).map(p -> p.getParent()).findFirst();
    }

    private void updatePartyInformationForRegime(ReportingRegime.ReportingRegimeBuilder reportingRegimeBuilder, CorporateSector.CorporateSectorBuilder corporateSectorBuilder) {
        SupervisoryBodyEnum supervisoryBody = reportingRegimeBuilder.getSupervisoryBody().getValue();
        switch (supervisoryBody) {
            case ESMA: {
                reportingRegimeBuilder.getOrCreateEsmaPartyInformation().setCorporateSector(corporateSectorBuilder);
                break;
            }
            case FCA: {
                reportingRegimeBuilder.getOrCreateFcaPartyInformation().setCorporateSector(corporateSectorBuilder);
                break;
            }
            default: {
                throw new RuntimeException("Cannot updated corporate sector, unexpected supervisoryBody " + String.valueOf((Object)supervisoryBody));
            }
        }
    }

    private Optional<FinancialSectorEnum> getFinancialSectorEnum(String value) {
        try {
            return Optional.of(FinancialSectorEnum.valueOf(value));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private Optional<NonFinancialSector> getNonFinancialSector(String value) {
        try {
            return Optional.of(NonFinancialSectorEnum.valueOf(value)).map(e -> NonFinancialSector.builder().setNonFinancialSectorIndicator((NonFinancialSectorEnum)((Object)e)).setOrdinal(e.ordinal() + 1));
        }
        catch (IllegalArgumentException e2) {
            return Optional.empty();
        }
    }
}

