/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.esma.emir.refit.trade.StrikePriceScheduleReport;
import drr.regulation.esma.emir.refit.trade.functions.EUEMIRReportableStrikePricePeriod;
import drr.regulation.esma.emir.refit.trade.reports.EffectiveDateOfTheStrikePriceRule;
import drr.regulation.esma.emir.refit.trade.reports.EndDateOfTheStrikePriceRule;
import drr.regulation.esma.emir.refit.trade.reports.StrikePriceInEffectOnAssociatedEffectiveDateMonetaryRule;
import drr.regulation.esma.emir.refit.trade.reports.StrikePriceInEffectOnAssociatedEffectiveDatePercentageRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceScheduleRuleDefault.class)
public abstract class StrikePriceScheduleRule
implements ReportFunction<TransactionReportInstruction, List<? extends StrikePriceScheduleReport>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EUEMIRReportableStrikePricePeriod eUEMIRReportableStrikePricePeriod;
    @Inject
    protected EffectiveDateOfTheStrikePriceRule effectiveDateOfTheStrikePriceRule;
    @Inject
    protected EndDateOfTheStrikePriceRule endDateOfTheStrikePriceRule;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected StrikePriceInEffectOnAssociatedEffectiveDateMonetaryRule strikePriceInEffectOnAssociatedEffectiveDateMonetaryRule;
    @Inject
    protected StrikePriceInEffectOnAssociatedEffectiveDatePercentageRule strikePriceInEffectOnAssociatedEffectiveDatePercentageRule;

    public List<? extends StrikePriceScheduleReport> evaluate(TransactionReportInstruction input) {
        List output;
        List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(StrikePriceScheduleReport::build).collect(Collectors.toList());
            this.objectValidator.validate(StrikePriceScheduleReport.class, output);
        }
        return output;
    }

    protected abstract List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class StrikePriceScheduleRuleDefault
    extends StrikePriceScheduleRule {
        @Override
        protected List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> output = new ArrayList<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> assignOutput(List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            MapperC thenArg1 = thenArg0.mapSingleToList(item -> MapperC.of(this.eUEMIRReportableStrikePricePeriod.evaluate((TransactionReportInstruction)item.get())));
            output = this.toBuilder(thenArg1.mapItem(item -> MapperS.of((Object)StrikePriceScheduleReport.builder().setEffectiveDateStrikePrice(this.effectiveDateOfTheStrikePriceRule.evaluate((PriceReportablePeriod)item.get())).setEndDateStrikePrice(this.endDateOfTheStrikePriceRule.evaluate((PriceReportablePeriod)item.get())).setStrikePriceInEffectOnAssociatedEffectiveDateMonetary(this.strikePriceInEffectOnAssociatedEffectiveDateMonetaryRule.evaluate((PriceReportablePeriod)item.get())).setStrikePriceInEffectOnAssociatedEffectiveDatePercentage(this.strikePriceInEffectOnAssociatedEffectiveDatePercentageRule.evaluate((PriceReportablePeriod)item.get())).setStrikePriceNotationInEffectOnAssociatedEffectiveDate(null).build())).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

