/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsCleared;
import drr.regulation.common.functions.IsRegulatedMarketOrThirdCountryEquivalentMarket;
import drr.standards.iosco.cde.reports.CDEConfirmedRule;
import javax.inject.Inject;

@ImplementedBy(value=ConfirmedRuleDefault.class)
public abstract class ConfirmedRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected CDEConfirmedRule cDEConfirmedRule;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected IsCleared isCleared;
    @Inject
    protected IsRegulatedMarketOrThirdCountryEquivalentMarket isRegulatedMarketOrThirdCountryEquivalentMarket;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class ConfirmedRuleDefault
    extends ConfirmedRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            output = (String)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isCleared.evaluate((WorkflowStep)item.map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isRegulatedMarketOrThirdCountryEquivalentMarket.evaluate((ReportableInformation)item.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get(), RegimeNameEnum.UKEMIR)), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.cDEConfirmedRule.evaluate((TransactionReportInstruction)item.get()));
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

