/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.margin.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.mas.rewrite.margin.MASMarginReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MASMarginReportTypeFormatValidator
implements Validator<MASMarginReport> {
    private List<ComparisonResult> getComparisonResults(MASMarginReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"reportingSpecifiedPerson", (String)o.getReportingSpecifiedPerson(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"uniqueTransactionIdentifier", (String)o.getUniqueTransactionIdentifier(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}"))), ExpressionOperators.checkString((String)"uniqueTransactionIdentifierProprietary", (String)o.getUniqueTransactionIdentifierProprietary(), (int)0, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), ExpressionOperators.checkString((String)"initialMarginCollateralPortfolioCode", (String)o.getInitialMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"variationMarginCollateralPortfolioCode", (String)o.getVariationMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkNumber((String)"initialMarginPostedByCounterparty1PreHaircut", (BigDecimal)o.getInitialMarginPostedByCounterparty1PreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"initialMarginPostedByCounterparty1PostHaircut", (BigDecimal)o.getInitialMarginPostedByCounterparty1PostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"initialMarginCollectedByCounterparty1PreHaircut", (BigDecimal)o.getInitialMarginCollectedByCounterparty1PreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"initialMarginCollectedByCounterparty1PostHaircut", (BigDecimal)o.getInitialMarginCollectedByCounterparty1PostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"variationMarginPostedByCounterparty1PreHaircut", (BigDecimal)o.getVariationMarginPostedByCounterparty1PreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"variationMarginPostedByCounterparty1PostHaircut", (BigDecimal)o.getVariationMarginPostedByCounterparty1PostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"variationMarginCollectedByCounterparty1PreHaircut", (BigDecimal)o.getVariationMarginCollectedByCounterparty1PreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"variationMarginCollectedByCounterparty1PostHaircut", (BigDecimal)o.getVariationMarginCollectedByCounterparty1PostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"excessCollateralPostedByCounterparty1", (BigDecimal)o.getExcessCollateralPostedByCounterparty1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"excessCollateralCollectedByCounterparty1", (BigDecimal)o.getExcessCollateralCollectedByCounterparty1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"executionAgentOfTheCounterparty1", (String)o.getExecutionAgentOfTheCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASMarginReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"MASMarginReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"MASMarginReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"MASMarginReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"MASMarginReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

