/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.mas.rewrite.trade.BasketConstituentsReport;
import drr.regulation.mas.rewrite.trade.MASNonReportable;
import drr.regulation.mas.rewrite.trade.NotionalAmountScheduleLeg1Report;
import drr.regulation.mas.rewrite.trade.NotionalAmountScheduleLeg2Report;
import drr.regulation.mas.rewrite.trade.NotionalQuantityScheduleLeg1Report;
import drr.regulation.mas.rewrite.trade.NotionalQuantityScheduleLeg2Report;
import drr.regulation.mas.rewrite.trade.OtherPaymentReport;
import drr.regulation.mas.rewrite.trade.PriceAndNotation;
import drr.regulation.mas.rewrite.trade.PriceScheduleReport;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg1;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg2;
import drr.regulation.mas.rewrite.trade.StrikePriceAndNotation;
import drr.regulation.mas.rewrite.trade.StrikePriceScheduleReport;
import drr.regulation.mas.rewrite.trade.meta.MASTransactionReportMeta;
import iso20022.auth030.mas.Frequency13Code__1;
import iso20022.auth030.mas.InterestComputationMethod4Code;
import iso20022.auth030.mas.TradingCapacity7Code;
import iso20022.auth030.mas.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MASTransactionReport", builder=MASTransactionReportBuilderImpl.class, version="5.52.0")
@RuneDataType(value="MASTransactionReport", model="drr", builder=MASTransactionReportBuilderImpl.class, version="5.52.0")
public interface MASTransactionReport
extends RosettaModelObject {
    public static final MASTransactionReportMeta metaData = new MASTransactionReportMeta();

    public String getCounterparty1();

    public String getCounterparty2();

    public Boolean getCounterparty2IdentifierType();

    public TradingCapacity7Code getTradingCapacityOfSpecifiedPerson();

    public String getDirection();

    public String getDirectionOfLeg1();

    public String getDirectionOfLeg2();

    public String getReportingSpecifiedPerson();

    public String getDataSubmitter();

    public String getUniqueTransactionIdentifier();

    public String getUniqueTransactionIdentifierProprietary();

    public String getUniqueProductIdentifier();

    public String getPriorUTI();

    public String getPriorUTIProprietary();

    public String getContractType();

    public String getAssetClass();

    public String getUnderlying();

    public String getUnderlyingIdentificationType();

    public String getUnderlyingIdOther();

    public String getUnderlyingIdOtherSource();

    public String getNameOfTheUnderlyingIndex();

    public BigDecimal getFixedRateOfLeg1();

    public String getIdentifierOfFloatingRateOfLeg1();

    public String getNameOfTheFloatingRateOfLeg1();

    public SpreadOfLeg1 getSpreadOfLeg1();

    public BigDecimal getFixedRateOfLeg2();

    public String getIdentifierOfFloatingRateOfLeg2();

    public String getNameOfTheFloatingRateOfLeg2();

    public SpreadOfLeg2 getSpreadOfLeg2();

    public String getOptionType();

    public String getOptionStyle();

    public Date getFirstExerciseDate();

    public Date getEffectiveDate();

    public Date getExpirationDate();

    public String getSwapLinkID();

    public String getPackageIdentifier();

    public String getDeliveryType();

    public ISOCurrencyCodeEnum getSettlementCurrency1();

    public ISOCurrencyCodeEnum getSettlementCurrency2();

    public Date getFinalContractualSettlementDate();

    public String getCleared();

    public String getCentralCounterparty();

    public String getClearingMember();

    public ZonedDateTime getClearingTimestamp();

    public String getPlatformIdentifier();

    public String getBookingLocation();

    public String getTraderLocation();

    public String getConfirmed();

    public ZonedDateTime getConfirmationTimestamp();

    public ZonedDateTime getExecutionTimestamp();

    public ZonedDateTime getReportingTimestamp();

    public List<? extends BasketConstituentsReport> getBasketConstituents();

    public BigDecimal getValuationAmount();

    public ISOCurrencyCodeEnum getValuationCurrency();

    public ValuationType1Code getValuationMethod();

    public ZonedDateTime getValuationTimestamp();

    public Boolean getCollateralPortfolioIndicator();

    public String getInitialMarginCollateralPortfolioCode();

    public String getVariationMarginCollateralPortfolioCode();

    public BigDecimal getNotionalAmountOfTheContractOrLeg1();

    public ISOCurrencyCodeEnum getNotionalCurrencyOfTheContractOrLeg1();

    public BigDecimal getNotionalAmountOfLeg2();

    public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg2();

    public BigDecimal getTotalNotionalQuantityOfTheContractOrLeg1();

    public String getQuantityUnitOfMeasureForTheContractOrLeg1();

    public BigDecimal getNotionalQuantityOfTheContractOrLeg1();

    public String getQuantityFrequencyOfTheContractOrLeg1();

    public Integer getQuantityFrequencyMultiplierOfTheContractOrLeg1();

    public BigDecimal getTotalNotionalQuantityLeg2();

    public String getQuantityUnitOfMeasureLeg2();

    public BigDecimal getNotionalQuantityOfLeg2();

    public String getQuantityFrequencyOfLeg2();

    public Integer getQuantityFrequencyMultiplierOfLeg2();

    public BigDecimal getCallAmount();

    public ISOCurrencyCodeEnum getCallCurrency();

    public BigDecimal getPutAmount();

    public ISOCurrencyCodeEnum getPutCurrency();

    public PriceAndNotation getPrice();

    public String getPriceUnitOfMeasure();

    public List<? extends PriceScheduleReport> getPriceSchedule();

    public StrikePriceAndNotation getStrikePrice();

    public List<? extends StrikePriceScheduleReport> getStrikePriceSchedule();

    public BigDecimal getOptionPremiumAmount();

    public ISOCurrencyCodeEnum getOptionPremiumCurrency();

    public BigDecimal getExchangeRate();

    public String getExchangeRateBasis();

    public InterestComputationMethod4Code getFixedRateDayCountConventionOfLeg1();

    public InterestComputationMethod4Code getFixedRateDayCountConventionOfLeg2();

    public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1();

    public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2();

    public String getFloatingRateResetFrequencyPeriodOfLeg1();

    public Integer getFloatingRateResetFrequencyPeriodMultiplierOfLeg1();

    public String getFloatingRateResetFrequencyPeriodOfLeg2();

    public Integer getFloatingRateResetFrequencyPeriodMultiplierOfLeg2();

    public Frequency13Code__1 getFixedRatePaymentFrequencyPeriodOfLeg1();

    public Integer getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1();

    public Frequency13Code__1 getFixedRatePaymentFrequencyPeriodOfLeg2();

    public Integer getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2();

    public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg1();

    public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1();

    public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg2();

    public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2();

    public List<? extends OtherPaymentReport> getOtherPayment();

    public String getActionType();

    public String getEventType();

    public ZonedDateTime getEventDate();

    public MASNonReportable getNonReportable();

    public String getTechnicalRecordId();

    public String getCounterparty2Name();

    public String getExecutionAgentOfCounterparty1();

    public String getExecutionAgentOfCounterparty2DTCC();

    public List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1DTCC();

    public List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2DTCC();

    public List<? extends NotionalQuantityScheduleLeg1Report> getNotionalQuantityScheduleLeg1DTCC();

    public List<? extends NotionalQuantityScheduleLeg2Report> getNotionalQuantityScheduleLeg2DTCC();

    public MASTransactionReport build();

    public MASTransactionReportBuilder toBuilder();

    public static MASTransactionReportBuilder builder() {
        return new MASTransactionReportBuilderImpl();
    }

    default public RosettaMetaData<? extends MASTransactionReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MASTransactionReport> getType() {
        return MASTransactionReport.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradingCapacityOfSpecifiedPerson"), TradingCapacity7Code.class, (Object)this.getTradingCapacityOfSpecifiedPerson(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction"), String.class, (Object)this.getDirection(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("directionOfLeg1"), String.class, (Object)this.getDirectionOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("directionOfLeg2"), String.class, (Object)this.getDirectionOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingSpecifiedPerson"), String.class, (Object)this.getReportingSpecifiedPerson(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dataSubmitter"), String.class, (Object)this.getDataSubmitter(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractType"), String.class, (Object)this.getContractType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), String.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlying"), String.class, (Object)this.getUnderlying(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOtherSource"), String.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRateOfLeg1"), BigDecimal.class, (Object)this.getFixedRateOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg1"), String.class, (Object)this.getIdentifierOfFloatingRateOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg1"), String.class, (Object)this.getNameOfTheFloatingRateOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadOfLeg1"), processor, SpreadOfLeg1.class, this.getSpreadOfLeg1(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRateOfLeg2"), BigDecimal.class, (Object)this.getFixedRateOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg2"), String.class, (Object)this.getIdentifierOfFloatingRateOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg2"), String.class, (Object)this.getNameOfTheFloatingRateOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadOfLeg2"), processor, SpreadOfLeg2.class, this.getSpreadOfLeg2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), String.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionStyle"), String.class, (Object)this.getOptionStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryType"), String.class, (Object)this.getDeliveryType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementCurrency1"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementCurrency2"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), String.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bookingLocation"), String.class, (Object)this.getBookingLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("traderLocation"), String.class, (Object)this.getTraderLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmed"), String.class, (Object)this.getConfirmed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, this.getBasketConstituents(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAmountOfTheContractOrLeg1"), BigDecimal.class, (Object)this.getNotionalAmountOfTheContractOrLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalCurrencyOfTheContractOrLeg1"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrencyOfTheContractOrLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAmountOfLeg2"), BigDecimal.class, (Object)this.getNotionalAmountOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalCurrencyOfLeg2"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrencyOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalNotionalQuantityOfTheContractOrLeg1"), BigDecimal.class, (Object)this.getTotalNotionalQuantityOfTheContractOrLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityUnitOfMeasureForTheContractOrLeg1"), String.class, (Object)this.getQuantityUnitOfMeasureForTheContractOrLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalQuantityOfTheContractOrLeg1"), BigDecimal.class, (Object)this.getNotionalQuantityOfTheContractOrLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityFrequencyOfTheContractOrLeg1"), String.class, (Object)this.getQuantityFrequencyOfTheContractOrLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityFrequencyMultiplierOfTheContractOrLeg1"), Integer.class, (Object)this.getQuantityFrequencyMultiplierOfTheContractOrLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, (Object)this.getTotalNotionalQuantityLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, (Object)this.getQuantityUnitOfMeasureLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalQuantityOfLeg2"), BigDecimal.class, (Object)this.getNotionalQuantityOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityFrequencyOfLeg2"), String.class, (Object)this.getQuantityFrequencyOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityFrequencyMultiplierOfLeg2"), Integer.class, (Object)this.getQuantityFrequencyMultiplierOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, PriceAndNotation.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSchedule"), processor, PriceScheduleReport.class, this.getPriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.class, this.getStrikePrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, StrikePriceScheduleReport.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, (Object)this.getFixedRateDayCountConventionOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, (Object)this.getFixedRateDayCountConventionOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, (Object)this.getFloatingRateDayCountConventionOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, (Object)this.getFloatingRateDayCountConventionOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg1"), String.class, (Object)this.getFloatingRateResetFrequencyPeriodOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierOfLeg1"), Integer.class, (Object)this.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg2"), String.class, (Object)this.getFloatingRateResetFrequencyPeriodOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierOfLeg2"), Integer.class, (Object)this.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodOfLeg1"), Frequency13Code__1.class, (Object)this.getFixedRatePaymentFrequencyPeriodOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1"), Integer.class, (Object)this.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodOfLeg2"), Frequency13Code__1.class, (Object)this.getFixedRatePaymentFrequencyPeriodOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2"), Integer.class, (Object)this.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg1"), Frequency13Code__1.class, (Object)this.getFloatingRatePaymentFrequencyPeriodOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1"), Integer.class, (Object)this.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg2"), Frequency13Code__1.class, (Object)this.getFloatingRatePaymentFrequencyPeriodOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2"), Integer.class, (Object)this.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.class, this.getOtherPayment(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), String.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventType"), String.class, (Object)this.getEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), ZonedDateTime.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonReportable"), processor, MASNonReportable.class, this.getNonReportable(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, (Object)this.getExecutionAgentOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfCounterparty2DTCC"), String.class, (Object)this.getExecutionAgentOfCounterparty2DTCC(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountScheduleLeg1DTCC"), processor, NotionalAmountScheduleLeg1Report.class, this.getNotionalAmountScheduleLeg1DTCC(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountScheduleLeg2DTCC"), processor, NotionalAmountScheduleLeg2Report.class, this.getNotionalAmountScheduleLeg2DTCC(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalQuantityScheduleLeg1DTCC"), processor, NotionalQuantityScheduleLeg1Report.class, this.getNotionalQuantityScheduleLeg1DTCC(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalQuantityScheduleLeg2DTCC"), processor, NotionalQuantityScheduleLeg2Report.class, this.getNotionalQuantityScheduleLeg2DTCC(), new AttributeMeta[0]);
    }

    public static class MASTransactionReportBuilderImpl
    implements MASTransactionReportBuilder {
        protected String counterparty1;
        protected String counterparty2;
        protected Boolean counterparty2IdentifierType;
        protected TradingCapacity7Code tradingCapacityOfSpecifiedPerson;
        protected String direction;
        protected String directionOfLeg1;
        protected String directionOfLeg2;
        protected String reportingSpecifiedPerson;
        protected String dataSubmitter;
        protected String uniqueTransactionIdentifier;
        protected String uniqueTransactionIdentifierProprietary;
        protected String uniqueProductIdentifier;
        protected String priorUTI;
        protected String priorUTIProprietary;
        protected String contractType;
        protected String assetClass;
        protected String underlying;
        protected String underlyingIdentificationType;
        protected String underlyingIdOther;
        protected String underlyingIdOtherSource;
        protected String nameOfTheUnderlyingIndex;
        protected BigDecimal fixedRateOfLeg1;
        protected String identifierOfFloatingRateOfLeg1;
        protected String nameOfTheFloatingRateOfLeg1;
        protected SpreadOfLeg1.SpreadOfLeg1Builder spreadOfLeg1;
        protected BigDecimal fixedRateOfLeg2;
        protected String identifierOfFloatingRateOfLeg2;
        protected String nameOfTheFloatingRateOfLeg2;
        protected SpreadOfLeg2.SpreadOfLeg2Builder spreadOfLeg2;
        protected String optionType;
        protected String optionStyle;
        protected Date firstExerciseDate;
        protected Date effectiveDate;
        protected Date expirationDate;
        protected String swapLinkID;
        protected String packageIdentifier;
        protected String deliveryType;
        protected ISOCurrencyCodeEnum settlementCurrency1;
        protected ISOCurrencyCodeEnum settlementCurrency2;
        protected Date finalContractualSettlementDate;
        protected String cleared;
        protected String centralCounterparty;
        protected String clearingMember;
        protected ZonedDateTime clearingTimestamp;
        protected String platformIdentifier;
        protected String bookingLocation;
        protected String traderLocation;
        protected String confirmed;
        protected ZonedDateTime confirmationTimestamp;
        protected ZonedDateTime executionTimestamp;
        protected ZonedDateTime reportingTimestamp;
        protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> basketConstituents = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
        protected BigDecimal valuationAmount;
        protected ISOCurrencyCodeEnum valuationCurrency;
        protected ValuationType1Code valuationMethod;
        protected ZonedDateTime valuationTimestamp;
        protected Boolean collateralPortfolioIndicator;
        protected String initialMarginCollateralPortfolioCode;
        protected String variationMarginCollateralPortfolioCode;
        protected BigDecimal notionalAmountOfTheContractOrLeg1;
        protected ISOCurrencyCodeEnum notionalCurrencyOfTheContractOrLeg1;
        protected BigDecimal notionalAmountOfLeg2;
        protected ISOCurrencyCodeEnum notionalCurrencyOfLeg2;
        protected BigDecimal totalNotionalQuantityOfTheContractOrLeg1;
        protected String quantityUnitOfMeasureForTheContractOrLeg1;
        protected BigDecimal notionalQuantityOfTheContractOrLeg1;
        protected String quantityFrequencyOfTheContractOrLeg1;
        protected Integer quantityFrequencyMultiplierOfTheContractOrLeg1;
        protected BigDecimal totalNotionalQuantityLeg2;
        protected String quantityUnitOfMeasureLeg2;
        protected BigDecimal notionalQuantityOfLeg2;
        protected String quantityFrequencyOfLeg2;
        protected Integer quantityFrequencyMultiplierOfLeg2;
        protected BigDecimal callAmount;
        protected ISOCurrencyCodeEnum callCurrency;
        protected BigDecimal putAmount;
        protected ISOCurrencyCodeEnum putCurrency;
        protected PriceAndNotation.PriceAndNotationBuilder price;
        protected String priceUnitOfMeasure;
        protected List<PriceScheduleReport.PriceScheduleReportBuilder> priceSchedule = new ArrayList<PriceScheduleReport.PriceScheduleReportBuilder>();
        protected StrikePriceAndNotation.StrikePriceAndNotationBuilder strikePrice;
        protected List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> strikePriceSchedule = new ArrayList<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder>();
        protected BigDecimal optionPremiumAmount;
        protected ISOCurrencyCodeEnum optionPremiumCurrency;
        protected BigDecimal exchangeRate;
        protected String exchangeRateBasis;
        protected InterestComputationMethod4Code fixedRateDayCountConventionOfLeg1;
        protected InterestComputationMethod4Code fixedRateDayCountConventionOfLeg2;
        protected InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1;
        protected InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2;
        protected String floatingRateResetFrequencyPeriodOfLeg1;
        protected Integer floatingRateResetFrequencyPeriodMultiplierOfLeg1;
        protected String floatingRateResetFrequencyPeriodOfLeg2;
        protected Integer floatingRateResetFrequencyPeriodMultiplierOfLeg2;
        protected Frequency13Code__1 fixedRatePaymentFrequencyPeriodOfLeg1;
        protected Integer fixedRatePaymentFrequencyPeriodMultiplierOfLeg1;
        protected Frequency13Code__1 fixedRatePaymentFrequencyPeriodOfLeg2;
        protected Integer fixedRatePaymentFrequencyPeriodMultiplierOfLeg2;
        protected Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg1;
        protected Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
        protected Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg2;
        protected Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
        protected List<OtherPaymentReport.OtherPaymentReportBuilder> otherPayment = new ArrayList<OtherPaymentReport.OtherPaymentReportBuilder>();
        protected String actionType;
        protected String eventType;
        protected ZonedDateTime eventDate;
        protected MASNonReportable.MASNonReportableBuilder nonReportable;
        protected String technicalRecordId;
        protected String counterparty2Name;
        protected String executionAgentOfCounterparty1;
        protected String executionAgentOfCounterparty2DTCC;
        protected List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> notionalAmountScheduleLeg1DTCC = new ArrayList<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>();
        protected List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> notionalAmountScheduleLeg2DTCC = new ArrayList<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>();
        protected List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> notionalQuantityScheduleLeg1DTCC = new ArrayList<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder>();
        protected List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> notionalQuantityScheduleLeg2DTCC = new ArrayList<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder>();

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="tradingCapacityOfSpecifiedPerson")
        @RuneAttribute(value="tradingCapacityOfSpecifiedPerson")
        public TradingCapacity7Code getTradingCapacityOfSpecifiedPerson() {
            return this.tradingCapacityOfSpecifiedPerson;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public String getDirection() {
            return this.direction;
        }

        @Override
        @RosettaAttribute(value="directionOfLeg1")
        @RuneAttribute(value="directionOfLeg1")
        public String getDirectionOfLeg1() {
            return this.directionOfLeg1;
        }

        @Override
        @RosettaAttribute(value="directionOfLeg2")
        @RuneAttribute(value="directionOfLeg2")
        public String getDirectionOfLeg2() {
            return this.directionOfLeg2;
        }

        @Override
        @RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
        @RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
        public String getReportingSpecifiedPerson() {
            return this.reportingSpecifiedPerson;
        }

        @Override
        @RosettaAttribute(value="dataSubmitter", isRequired=true)
        @RuneAttribute(value="dataSubmitter", isRequired=true)
        public String getDataSubmitter() {
            return this.dataSubmitter;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public String getUniqueProductIdentifier() {
            return this.uniqueProductIdentifier;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public String getPriorUTI() {
            return this.priorUTI;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietary")
        @RuneAttribute(value="priorUTIProprietary")
        public String getPriorUTIProprietary() {
            return this.priorUTIProprietary;
        }

        @Override
        @RosettaAttribute(value="contractType")
        @RuneAttribute(value="contractType")
        public String getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public String getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="underlying")
        @RuneAttribute(value="underlying")
        public String getUnderlying() {
            return this.underlying;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public String getUnderlyingIdentificationType() {
            return this.underlyingIdentificationType;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public String getUnderlyingIdOther() {
            return this.underlyingIdOther;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public String getUnderlyingIdOtherSource() {
            return this.underlyingIdOtherSource;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public String getNameOfTheUnderlyingIndex() {
            return this.nameOfTheUnderlyingIndex;
        }

        @Override
        @RosettaAttribute(value="fixedRateOfLeg1")
        @RuneAttribute(value="fixedRateOfLeg1")
        public BigDecimal getFixedRateOfLeg1() {
            return this.fixedRateOfLeg1;
        }

        @Override
        @RosettaAttribute(value="identifierOfFloatingRateOfLeg1")
        @RuneAttribute(value="identifierOfFloatingRateOfLeg1")
        public String getIdentifierOfFloatingRateOfLeg1() {
            return this.identifierOfFloatingRateOfLeg1;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRateOfLeg1")
        @RuneAttribute(value="nameOfTheFloatingRateOfLeg1")
        public String getNameOfTheFloatingRateOfLeg1() {
            return this.nameOfTheFloatingRateOfLeg1;
        }

        @Override
        @RosettaAttribute(value="spreadOfLeg1")
        @RuneAttribute(value="spreadOfLeg1")
        public SpreadOfLeg1.SpreadOfLeg1Builder getSpreadOfLeg1() {
            return this.spreadOfLeg1;
        }

        @Override
        public SpreadOfLeg1.SpreadOfLeg1Builder getOrCreateSpreadOfLeg1() {
            SpreadOfLeg1.SpreadOfLeg1Builder result = this.spreadOfLeg1 != null ? this.spreadOfLeg1 : (this.spreadOfLeg1 = SpreadOfLeg1.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedRateOfLeg2")
        @RuneAttribute(value="fixedRateOfLeg2")
        public BigDecimal getFixedRateOfLeg2() {
            return this.fixedRateOfLeg2;
        }

        @Override
        @RosettaAttribute(value="identifierOfFloatingRateOfLeg2")
        @RuneAttribute(value="identifierOfFloatingRateOfLeg2")
        public String getIdentifierOfFloatingRateOfLeg2() {
            return this.identifierOfFloatingRateOfLeg2;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRateOfLeg2")
        @RuneAttribute(value="nameOfTheFloatingRateOfLeg2")
        public String getNameOfTheFloatingRateOfLeg2() {
            return this.nameOfTheFloatingRateOfLeg2;
        }

        @Override
        @RosettaAttribute(value="spreadOfLeg2")
        @RuneAttribute(value="spreadOfLeg2")
        public SpreadOfLeg2.SpreadOfLeg2Builder getSpreadOfLeg2() {
            return this.spreadOfLeg2;
        }

        @Override
        public SpreadOfLeg2.SpreadOfLeg2Builder getOrCreateSpreadOfLeg2() {
            SpreadOfLeg2.SpreadOfLeg2Builder result = this.spreadOfLeg2 != null ? this.spreadOfLeg2 : (this.spreadOfLeg2 = SpreadOfLeg2.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public String getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public String getOptionStyle() {
            return this.optionStyle;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public Date getFirstExerciseDate() {
            return this.firstExerciseDate;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="swapLinkID")
        @RuneAttribute(value="swapLinkID")
        public String getSwapLinkID() {
            return this.swapLinkID;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public String getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency1")
        @RuneAttribute(value="settlementCurrency1")
        public ISOCurrencyCodeEnum getSettlementCurrency1() {
            return this.settlementCurrency1;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency2")
        @RuneAttribute(value="settlementCurrency2")
        public ISOCurrencyCodeEnum getSettlementCurrency2() {
            return this.settlementCurrency2;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public Date getFinalContractualSettlementDate() {
            return this.finalContractualSettlementDate;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public String getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public String getCentralCounterparty() {
            return this.centralCounterparty;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public String getClearingMember() {
            return this.clearingMember;
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public ZonedDateTime getClearingTimestamp() {
            return this.clearingTimestamp;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public String getPlatformIdentifier() {
            return this.platformIdentifier;
        }

        @Override
        @RosettaAttribute(value="bookingLocation")
        @RuneAttribute(value="bookingLocation")
        public String getBookingLocation() {
            return this.bookingLocation;
        }

        @Override
        @RosettaAttribute(value="traderLocation")
        @RuneAttribute(value="traderLocation")
        public String getTraderLocation() {
            return this.traderLocation;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public String getConfirmed() {
            return this.confirmed;
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public ZonedDateTime getConfirmationTimestamp() {
            return this.confirmationTimestamp;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents() {
            return this.basketConstituents;
        }

        @Override
        public BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int index) {
            if (this.basketConstituents == null) {
                this.basketConstituents = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
            }
            return (BasketConstituentsReport.BasketConstituentsReportBuilder)this.getIndex(this.basketConstituents, index, () -> {
                BasketConstituentsReport.BasketConstituentsReportBuilder newBasketConstituents = BasketConstituentsReport.builder();
                return newBasketConstituents;
            });
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="notionalAmountOfTheContractOrLeg1")
        @RuneAttribute(value="notionalAmountOfTheContractOrLeg1")
        public BigDecimal getNotionalAmountOfTheContractOrLeg1() {
            return this.notionalAmountOfTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyOfTheContractOrLeg1")
        @RuneAttribute(value="notionalCurrencyOfTheContractOrLeg1")
        public ISOCurrencyCodeEnum getNotionalCurrencyOfTheContractOrLeg1() {
            return this.notionalCurrencyOfTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalAmountOfLeg2")
        @RuneAttribute(value="notionalAmountOfLeg2")
        public BigDecimal getNotionalAmountOfLeg2() {
            return this.notionalAmountOfLeg2;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyOfLeg2")
        @RuneAttribute(value="notionalCurrencyOfLeg2")
        public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg2() {
            return this.notionalCurrencyOfLeg2;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityOfTheContractOrLeg1")
        @RuneAttribute(value="totalNotionalQuantityOfTheContractOrLeg1")
        public BigDecimal getTotalNotionalQuantityOfTheContractOrLeg1() {
            return this.totalNotionalQuantityOfTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureForTheContractOrLeg1")
        @RuneAttribute(value="quantityUnitOfMeasureForTheContractOrLeg1")
        public String getQuantityUnitOfMeasureForTheContractOrLeg1() {
            return this.quantityUnitOfMeasureForTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityOfTheContractOrLeg1")
        @RuneAttribute(value="notionalQuantityOfTheContractOrLeg1")
        public BigDecimal getNotionalQuantityOfTheContractOrLeg1() {
            return this.notionalQuantityOfTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyOfTheContractOrLeg1")
        @RuneAttribute(value="quantityFrequencyOfTheContractOrLeg1")
        public String getQuantityFrequencyOfTheContractOrLeg1() {
            return this.quantityFrequencyOfTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyMultiplierOfTheContractOrLeg1")
        @RuneAttribute(value="quantityFrequencyMultiplierOfTheContractOrLeg1")
        public Integer getQuantityFrequencyMultiplierOfTheContractOrLeg1() {
            return this.quantityFrequencyMultiplierOfTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg2")
        @RuneAttribute(value="totalNotionalQuantityLeg2")
        public BigDecimal getTotalNotionalQuantityLeg2() {
            return this.totalNotionalQuantityLeg2;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg2")
        @RuneAttribute(value="quantityUnitOfMeasureLeg2")
        public String getQuantityUnitOfMeasureLeg2() {
            return this.quantityUnitOfMeasureLeg2;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityOfLeg2")
        @RuneAttribute(value="notionalQuantityOfLeg2")
        public BigDecimal getNotionalQuantityOfLeg2() {
            return this.notionalQuantityOfLeg2;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyOfLeg2")
        @RuneAttribute(value="quantityFrequencyOfLeg2")
        public String getQuantityFrequencyOfLeg2() {
            return this.quantityFrequencyOfLeg2;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyMultiplierOfLeg2")
        @RuneAttribute(value="quantityFrequencyMultiplierOfLeg2")
        public Integer getQuantityFrequencyMultiplierOfLeg2() {
            return this.quantityFrequencyMultiplierOfLeg2;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public BigDecimal getCallAmount() {
            return this.callAmount;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public ISOCurrencyCodeEnum getCallCurrency() {
            return this.callCurrency;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public BigDecimal getPutAmount() {
            return this.putAmount;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public ISOCurrencyCodeEnum getPutCurrency() {
            return this.putCurrency;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public PriceAndNotation.PriceAndNotationBuilder getPrice() {
            return this.price;
        }

        @Override
        public PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice() {
            PriceAndNotation.PriceAndNotationBuilder result = this.price != null ? this.price : (this.price = PriceAndNotation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public String getPriceUnitOfMeasure() {
            return this.priceUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public List<? extends PriceScheduleReport.PriceScheduleReportBuilder> getPriceSchedule() {
            return this.priceSchedule;
        }

        @Override
        public PriceScheduleReport.PriceScheduleReportBuilder getOrCreatePriceSchedule(int index) {
            if (this.priceSchedule == null) {
                this.priceSchedule = new ArrayList<PriceScheduleReport.PriceScheduleReportBuilder>();
            }
            return (PriceScheduleReport.PriceScheduleReportBuilder)this.getIndex(this.priceSchedule, index, () -> {
                PriceScheduleReport.PriceScheduleReportBuilder newPriceSchedule = PriceScheduleReport.builder();
                return newPriceSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        public StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice() {
            StrikePriceAndNotation.StrikePriceAndNotationBuilder result = this.strikePrice != null ? this.strikePrice : (this.strikePrice = StrikePriceAndNotation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public List<? extends StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> getStrikePriceSchedule() {
            return this.strikePriceSchedule;
        }

        @Override
        public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder getOrCreateStrikePriceSchedule(int index) {
            if (this.strikePriceSchedule == null) {
                this.strikePriceSchedule = new ArrayList<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder>();
            }
            return (StrikePriceScheduleReport.StrikePriceScheduleReportBuilder)this.getIndex(this.strikePriceSchedule, index, () -> {
                StrikePriceScheduleReport.StrikePriceScheduleReportBuilder newStrikePriceSchedule = StrikePriceScheduleReport.builder();
                return newStrikePriceSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public BigDecimal getOptionPremiumAmount() {
            return this.optionPremiumAmount;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
            return this.optionPremiumCurrency;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public BigDecimal getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public String getExchangeRateBasis() {
            return this.exchangeRateBasis;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConventionOfLeg1")
        @RuneAttribute(value="fixedRateDayCountConventionOfLeg1")
        public InterestComputationMethod4Code getFixedRateDayCountConventionOfLeg1() {
            return this.fixedRateDayCountConventionOfLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConventionOfLeg2")
        @RuneAttribute(value="fixedRateDayCountConventionOfLeg2")
        public InterestComputationMethod4Code getFixedRateDayCountConventionOfLeg2() {
            return this.fixedRateDayCountConventionOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConventionOfLeg1")
        @RuneAttribute(value="floatingRateDayCountConventionOfLeg1")
        public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1() {
            return this.floatingRateDayCountConventionOfLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConventionOfLeg2")
        @RuneAttribute(value="floatingRateDayCountConventionOfLeg2")
        public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2() {
            return this.floatingRateDayCountConventionOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodOfLeg1")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodOfLeg1")
        public String getFloatingRateResetFrequencyPeriodOfLeg1() {
            return this.floatingRateResetFrequencyPeriodOfLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodMultiplierOfLeg1")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodMultiplierOfLeg1")
        public Integer getFloatingRateResetFrequencyPeriodMultiplierOfLeg1() {
            return this.floatingRateResetFrequencyPeriodMultiplierOfLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodOfLeg2")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodOfLeg2")
        public String getFloatingRateResetFrequencyPeriodOfLeg2() {
            return this.floatingRateResetFrequencyPeriodOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodMultiplierOfLeg2")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodMultiplierOfLeg2")
        public Integer getFloatingRateResetFrequencyPeriodMultiplierOfLeg2() {
            return this.floatingRateResetFrequencyPeriodMultiplierOfLeg2;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodOfLeg1")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodOfLeg1")
        public Frequency13Code__1 getFixedRatePaymentFrequencyPeriodOfLeg1() {
            return this.fixedRatePaymentFrequencyPeriodOfLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierOfLeg1")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierOfLeg1")
        public Integer getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1() {
            return this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodOfLeg2")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodOfLeg2")
        public Frequency13Code__1 getFixedRatePaymentFrequencyPeriodOfLeg2() {
            return this.fixedRatePaymentFrequencyPeriodOfLeg2;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierOfLeg2")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierOfLeg2")
        public Integer getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2() {
            return this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodOfLeg1")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodOfLeg1")
        public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg1() {
            return this.floatingRatePaymentFrequencyPeriodOfLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
        public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1() {
            return this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodOfLeg2")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodOfLeg2")
        public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg2() {
            return this.floatingRatePaymentFrequencyPeriodOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
        public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2() {
            return this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment() {
            return this.otherPayment;
        }

        @Override
        public OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index) {
            if (this.otherPayment == null) {
                this.otherPayment = new ArrayList<OtherPaymentReport.OtherPaymentReportBuilder>();
            }
            return (OtherPaymentReport.OtherPaymentReportBuilder)this.getIndex(this.otherPayment, index, () -> {
                OtherPaymentReport.OtherPaymentReportBuilder newOtherPayment = OtherPaymentReport.builder();
                return newOtherPayment;
            });
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public String getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public String getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public ZonedDateTime getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public MASNonReportable.MASNonReportableBuilder getNonReportable() {
            return this.nonReportable;
        }

        @Override
        public MASNonReportable.MASNonReportableBuilder getOrCreateNonReportable() {
            MASNonReportable.MASNonReportableBuilder result = this.nonReportable != null ? this.nonReportable : (this.nonReportable = MASNonReportable.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public String getCounterparty2Name() {
            return this.counterparty2Name;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty1")
        @RuneAttribute(value="executionAgentOfCounterparty1")
        public String getExecutionAgentOfCounterparty1() {
            return this.executionAgentOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty2DTCC")
        @RuneAttribute(value="executionAgentOfCounterparty2DTCC")
        public String getExecutionAgentOfCounterparty2DTCC() {
            return this.executionAgentOfCounterparty2DTCC;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg1DTCC")
        @RuneAttribute(value="notionalAmountScheduleLeg1DTCC")
        public List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1DTCC() {
            return this.notionalAmountScheduleLeg1DTCC;
        }

        @Override
        public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1DTCC(int index) {
            if (this.notionalAmountScheduleLeg1DTCC == null) {
                this.notionalAmountScheduleLeg1DTCC = new ArrayList<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>();
            }
            return (NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder)this.getIndex(this.notionalAmountScheduleLeg1DTCC, index, () -> {
                NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder newNotionalAmountScheduleLeg1DTCC = NotionalAmountScheduleLeg1Report.builder();
                return newNotionalAmountScheduleLeg1DTCC;
            });
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg2DTCC")
        @RuneAttribute(value="notionalAmountScheduleLeg2DTCC")
        public List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2DTCC() {
            return this.notionalAmountScheduleLeg2DTCC;
        }

        @Override
        public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2DTCC(int index) {
            if (this.notionalAmountScheduleLeg2DTCC == null) {
                this.notionalAmountScheduleLeg2DTCC = new ArrayList<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>();
            }
            return (NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder)this.getIndex(this.notionalAmountScheduleLeg2DTCC, index, () -> {
                NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder newNotionalAmountScheduleLeg2DTCC = NotionalAmountScheduleLeg2Report.builder();
                return newNotionalAmountScheduleLeg2DTCC;
            });
        }

        @Override
        @RosettaAttribute(value="notionalQuantityScheduleLeg1DTCC")
        @RuneAttribute(value="notionalQuantityScheduleLeg1DTCC")
        public List<? extends NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> getNotionalQuantityScheduleLeg1DTCC() {
            return this.notionalQuantityScheduleLeg1DTCC;
        }

        @Override
        public NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder getOrCreateNotionalQuantityScheduleLeg1DTCC(int index) {
            if (this.notionalQuantityScheduleLeg1DTCC == null) {
                this.notionalQuantityScheduleLeg1DTCC = new ArrayList<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder>();
            }
            return (NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder)this.getIndex(this.notionalQuantityScheduleLeg1DTCC, index, () -> {
                NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder newNotionalQuantityScheduleLeg1DTCC = NotionalQuantityScheduleLeg1Report.builder();
                return newNotionalQuantityScheduleLeg1DTCC;
            });
        }

        @Override
        @RosettaAttribute(value="notionalQuantityScheduleLeg2DTCC")
        @RuneAttribute(value="notionalQuantityScheduleLeg2DTCC")
        public List<? extends NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> getNotionalQuantityScheduleLeg2DTCC() {
            return this.notionalQuantityScheduleLeg2DTCC;
        }

        @Override
        public NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder getOrCreateNotionalQuantityScheduleLeg2DTCC(int index) {
            if (this.notionalQuantityScheduleLeg2DTCC == null) {
                this.notionalQuantityScheduleLeg2DTCC = new ArrayList<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder>();
            }
            return (NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder)this.getIndex(this.notionalQuantityScheduleLeg2DTCC, index, () -> {
                NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder newNotionalQuantityScheduleLeg2DTCC = NotionalQuantityScheduleLeg2Report.builder();
                return newNotionalQuantityScheduleLeg2DTCC;
            });
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public MASTransactionReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public MASTransactionReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public MASTransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingCapacityOfSpecifiedPerson")
        @RuneAttribute(value="tradingCapacityOfSpecifiedPerson")
        public MASTransactionReportBuilder setTradingCapacityOfSpecifiedPerson(TradingCapacity7Code _tradingCapacityOfSpecifiedPerson) {
            this.tradingCapacityOfSpecifiedPerson = _tradingCapacityOfSpecifiedPerson == null ? null : _tradingCapacityOfSpecifiedPerson;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public MASTransactionReportBuilder setDirection(String _direction) {
            this.direction = _direction == null ? null : _direction;
            return this;
        }

        @Override
        @RosettaAttribute(value="directionOfLeg1")
        @RuneAttribute(value="directionOfLeg1")
        public MASTransactionReportBuilder setDirectionOfLeg1(String _directionOfLeg1) {
            this.directionOfLeg1 = _directionOfLeg1 == null ? null : _directionOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="directionOfLeg2")
        @RuneAttribute(value="directionOfLeg2")
        public MASTransactionReportBuilder setDirectionOfLeg2(String _directionOfLeg2) {
            this.directionOfLeg2 = _directionOfLeg2 == null ? null : _directionOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
        @RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
        public MASTransactionReportBuilder setReportingSpecifiedPerson(String _reportingSpecifiedPerson) {
            this.reportingSpecifiedPerson = _reportingSpecifiedPerson == null ? null : _reportingSpecifiedPerson;
            return this;
        }

        @Override
        @RosettaAttribute(value="dataSubmitter", isRequired=true)
        @RuneAttribute(value="dataSubmitter", isRequired=true)
        public MASTransactionReportBuilder setDataSubmitter(String _dataSubmitter) {
            this.dataSubmitter = _dataSubmitter == null ? null : _dataSubmitter;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public MASTransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public MASTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public MASTransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
            this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public MASTransactionReportBuilder setPriorUTI(String _priorUTI) {
            this.priorUTI = _priorUTI == null ? null : _priorUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietary")
        @RuneAttribute(value="priorUTIProprietary")
        public MASTransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
            this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractType")
        @RuneAttribute(value="contractType")
        public MASTransactionReportBuilder setContractType(String _contractType) {
            this.contractType = _contractType == null ? null : _contractType;
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public MASTransactionReportBuilder setAssetClass(String _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlying")
        @RuneAttribute(value="underlying")
        public MASTransactionReportBuilder setUnderlying(String _underlying) {
            this.underlying = _underlying == null ? null : _underlying;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public MASTransactionReportBuilder setUnderlyingIdentificationType(String _underlyingIdentificationType) {
            this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public MASTransactionReportBuilder setUnderlyingIdOther(String _underlyingIdOther) {
            this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public MASTransactionReportBuilder setUnderlyingIdOtherSource(String _underlyingIdOtherSource) {
            this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public MASTransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
            this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateOfLeg1")
        @RuneAttribute(value="fixedRateOfLeg1")
        public MASTransactionReportBuilder setFixedRateOfLeg1(BigDecimal _fixedRateOfLeg1) {
            this.fixedRateOfLeg1 = _fixedRateOfLeg1 == null ? null : _fixedRateOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="identifierOfFloatingRateOfLeg1")
        @RuneAttribute(value="identifierOfFloatingRateOfLeg1")
        public MASTransactionReportBuilder setIdentifierOfFloatingRateOfLeg1(String _identifierOfFloatingRateOfLeg1) {
            this.identifierOfFloatingRateOfLeg1 = _identifierOfFloatingRateOfLeg1 == null ? null : _identifierOfFloatingRateOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRateOfLeg1")
        @RuneAttribute(value="nameOfTheFloatingRateOfLeg1")
        public MASTransactionReportBuilder setNameOfTheFloatingRateOfLeg1(String _nameOfTheFloatingRateOfLeg1) {
            this.nameOfTheFloatingRateOfLeg1 = _nameOfTheFloatingRateOfLeg1 == null ? null : _nameOfTheFloatingRateOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadOfLeg1")
        @RuneAttribute(value="spreadOfLeg1")
        public MASTransactionReportBuilder setSpreadOfLeg1(SpreadOfLeg1 _spreadOfLeg1) {
            this.spreadOfLeg1 = _spreadOfLeg1 == null ? null : _spreadOfLeg1.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateOfLeg2")
        @RuneAttribute(value="fixedRateOfLeg2")
        public MASTransactionReportBuilder setFixedRateOfLeg2(BigDecimal _fixedRateOfLeg2) {
            this.fixedRateOfLeg2 = _fixedRateOfLeg2 == null ? null : _fixedRateOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="identifierOfFloatingRateOfLeg2")
        @RuneAttribute(value="identifierOfFloatingRateOfLeg2")
        public MASTransactionReportBuilder setIdentifierOfFloatingRateOfLeg2(String _identifierOfFloatingRateOfLeg2) {
            this.identifierOfFloatingRateOfLeg2 = _identifierOfFloatingRateOfLeg2 == null ? null : _identifierOfFloatingRateOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRateOfLeg2")
        @RuneAttribute(value="nameOfTheFloatingRateOfLeg2")
        public MASTransactionReportBuilder setNameOfTheFloatingRateOfLeg2(String _nameOfTheFloatingRateOfLeg2) {
            this.nameOfTheFloatingRateOfLeg2 = _nameOfTheFloatingRateOfLeg2 == null ? null : _nameOfTheFloatingRateOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadOfLeg2")
        @RuneAttribute(value="spreadOfLeg2")
        public MASTransactionReportBuilder setSpreadOfLeg2(SpreadOfLeg2 _spreadOfLeg2) {
            this.spreadOfLeg2 = _spreadOfLeg2 == null ? null : _spreadOfLeg2.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public MASTransactionReportBuilder setOptionType(String _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public MASTransactionReportBuilder setOptionStyle(String _optionStyle) {
            this.optionStyle = _optionStyle == null ? null : _optionStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public MASTransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
            this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public MASTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public MASTransactionReportBuilder setExpirationDate(Date _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="swapLinkID")
        @RuneAttribute(value="swapLinkID")
        public MASTransactionReportBuilder setSwapLinkID(String _swapLinkID) {
            this.swapLinkID = _swapLinkID == null ? null : _swapLinkID;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public MASTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public MASTransactionReportBuilder setDeliveryType(String _deliveryType) {
            this.deliveryType = _deliveryType == null ? null : _deliveryType;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency1")
        @RuneAttribute(value="settlementCurrency1")
        public MASTransactionReportBuilder setSettlementCurrency1(ISOCurrencyCodeEnum _settlementCurrency1) {
            this.settlementCurrency1 = _settlementCurrency1 == null ? null : _settlementCurrency1;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency2")
        @RuneAttribute(value="settlementCurrency2")
        public MASTransactionReportBuilder setSettlementCurrency2(ISOCurrencyCodeEnum _settlementCurrency2) {
            this.settlementCurrency2 = _settlementCurrency2 == null ? null : _settlementCurrency2;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public MASTransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
            this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public MASTransactionReportBuilder setCleared(String _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public MASTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
            this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public MASTransactionReportBuilder setClearingMember(String _clearingMember) {
            this.clearingMember = _clearingMember == null ? null : _clearingMember;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public MASTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
            this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public MASTransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
            this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="bookingLocation")
        @RuneAttribute(value="bookingLocation")
        public MASTransactionReportBuilder setBookingLocation(String _bookingLocation) {
            this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="traderLocation")
        @RuneAttribute(value="traderLocation")
        public MASTransactionReportBuilder setTraderLocation(String _traderLocation) {
            this.traderLocation = _traderLocation == null ? null : _traderLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public MASTransactionReportBuilder setConfirmed(String _confirmed) {
            this.confirmed = _confirmed == null ? null : _confirmed;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public MASTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
            this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public MASTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
            this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public MASTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public MASTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
            if (_basketConstituents != null) {
                this.basketConstituents.add(_basketConstituents.toBuilder());
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
            this.getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
            return this;
        }

        @Override
        public MASTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            if (basketConstituentss != null) {
                for (BasketConstituentsReport basketConstituentsReport : basketConstituentss) {
                    this.basketConstituents.add(basketConstituentsReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituents")
        public MASTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            this.basketConstituents = basketConstituentss == null ? new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>() : (List)basketConstituentss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public MASTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public MASTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public MASTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public MASTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public MASTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public MASTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public MASTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountOfTheContractOrLeg1")
        @RuneAttribute(value="notionalAmountOfTheContractOrLeg1")
        public MASTransactionReportBuilder setNotionalAmountOfTheContractOrLeg1(BigDecimal _notionalAmountOfTheContractOrLeg1) {
            this.notionalAmountOfTheContractOrLeg1 = _notionalAmountOfTheContractOrLeg1 == null ? null : _notionalAmountOfTheContractOrLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyOfTheContractOrLeg1")
        @RuneAttribute(value="notionalCurrencyOfTheContractOrLeg1")
        public MASTransactionReportBuilder setNotionalCurrencyOfTheContractOrLeg1(ISOCurrencyCodeEnum _notionalCurrencyOfTheContractOrLeg1) {
            this.notionalCurrencyOfTheContractOrLeg1 = _notionalCurrencyOfTheContractOrLeg1 == null ? null : _notionalCurrencyOfTheContractOrLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountOfLeg2")
        @RuneAttribute(value="notionalAmountOfLeg2")
        public MASTransactionReportBuilder setNotionalAmountOfLeg2(BigDecimal _notionalAmountOfLeg2) {
            this.notionalAmountOfLeg2 = _notionalAmountOfLeg2 == null ? null : _notionalAmountOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyOfLeg2")
        @RuneAttribute(value="notionalCurrencyOfLeg2")
        public MASTransactionReportBuilder setNotionalCurrencyOfLeg2(ISOCurrencyCodeEnum _notionalCurrencyOfLeg2) {
            this.notionalCurrencyOfLeg2 = _notionalCurrencyOfLeg2 == null ? null : _notionalCurrencyOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityOfTheContractOrLeg1")
        @RuneAttribute(value="totalNotionalQuantityOfTheContractOrLeg1")
        public MASTransactionReportBuilder setTotalNotionalQuantityOfTheContractOrLeg1(BigDecimal _totalNotionalQuantityOfTheContractOrLeg1) {
            this.totalNotionalQuantityOfTheContractOrLeg1 = _totalNotionalQuantityOfTheContractOrLeg1 == null ? null : _totalNotionalQuantityOfTheContractOrLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureForTheContractOrLeg1")
        @RuneAttribute(value="quantityUnitOfMeasureForTheContractOrLeg1")
        public MASTransactionReportBuilder setQuantityUnitOfMeasureForTheContractOrLeg1(String _quantityUnitOfMeasureForTheContractOrLeg1) {
            this.quantityUnitOfMeasureForTheContractOrLeg1 = _quantityUnitOfMeasureForTheContractOrLeg1 == null ? null : _quantityUnitOfMeasureForTheContractOrLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityOfTheContractOrLeg1")
        @RuneAttribute(value="notionalQuantityOfTheContractOrLeg1")
        public MASTransactionReportBuilder setNotionalQuantityOfTheContractOrLeg1(BigDecimal _notionalQuantityOfTheContractOrLeg1) {
            this.notionalQuantityOfTheContractOrLeg1 = _notionalQuantityOfTheContractOrLeg1 == null ? null : _notionalQuantityOfTheContractOrLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyOfTheContractOrLeg1")
        @RuneAttribute(value="quantityFrequencyOfTheContractOrLeg1")
        public MASTransactionReportBuilder setQuantityFrequencyOfTheContractOrLeg1(String _quantityFrequencyOfTheContractOrLeg1) {
            this.quantityFrequencyOfTheContractOrLeg1 = _quantityFrequencyOfTheContractOrLeg1 == null ? null : _quantityFrequencyOfTheContractOrLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyMultiplierOfTheContractOrLeg1")
        @RuneAttribute(value="quantityFrequencyMultiplierOfTheContractOrLeg1")
        public MASTransactionReportBuilder setQuantityFrequencyMultiplierOfTheContractOrLeg1(Integer _quantityFrequencyMultiplierOfTheContractOrLeg1) {
            this.quantityFrequencyMultiplierOfTheContractOrLeg1 = _quantityFrequencyMultiplierOfTheContractOrLeg1 == null ? null : _quantityFrequencyMultiplierOfTheContractOrLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg2")
        @RuneAttribute(value="totalNotionalQuantityLeg2")
        public MASTransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal _totalNotionalQuantityLeg2) {
            this.totalNotionalQuantityLeg2 = _totalNotionalQuantityLeg2 == null ? null : _totalNotionalQuantityLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg2")
        @RuneAttribute(value="quantityUnitOfMeasureLeg2")
        public MASTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
            this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityOfLeg2")
        @RuneAttribute(value="notionalQuantityOfLeg2")
        public MASTransactionReportBuilder setNotionalQuantityOfLeg2(BigDecimal _notionalQuantityOfLeg2) {
            this.notionalQuantityOfLeg2 = _notionalQuantityOfLeg2 == null ? null : _notionalQuantityOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyOfLeg2")
        @RuneAttribute(value="quantityFrequencyOfLeg2")
        public MASTransactionReportBuilder setQuantityFrequencyOfLeg2(String _quantityFrequencyOfLeg2) {
            this.quantityFrequencyOfLeg2 = _quantityFrequencyOfLeg2 == null ? null : _quantityFrequencyOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyMultiplierOfLeg2")
        @RuneAttribute(value="quantityFrequencyMultiplierOfLeg2")
        public MASTransactionReportBuilder setQuantityFrequencyMultiplierOfLeg2(Integer _quantityFrequencyMultiplierOfLeg2) {
            this.quantityFrequencyMultiplierOfLeg2 = _quantityFrequencyMultiplierOfLeg2 == null ? null : _quantityFrequencyMultiplierOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public MASTransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
            this.callAmount = _callAmount == null ? null : _callAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public MASTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
            this.callCurrency = _callCurrency == null ? null : _callCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public MASTransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
            this.putAmount = _putAmount == null ? null : _putAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public MASTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
            this.putCurrency = _putCurrency == null ? null : _putCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public MASTransactionReportBuilder setPrice(PriceAndNotation _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public MASTransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
            this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public MASTransactionReportBuilder addPriceSchedule(PriceScheduleReport _priceSchedule) {
            if (_priceSchedule != null) {
                this.priceSchedule.add(_priceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addPriceSchedule(PriceScheduleReport _priceSchedule, int idx) {
            this.getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
            return this;
        }

        @Override
        public MASTransactionReportBuilder addPriceSchedule(List<? extends PriceScheduleReport> priceSchedules) {
            if (priceSchedules != null) {
                for (PriceScheduleReport priceScheduleReport : priceSchedules) {
                    this.priceSchedule.add(priceScheduleReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceSchedule")
        public MASTransactionReportBuilder setPriceSchedule(List<? extends PriceScheduleReport> priceSchedules) {
            this.priceSchedule = priceSchedules == null ? new ArrayList<PriceScheduleReport.PriceScheduleReportBuilder>() : (List)priceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public MASTransactionReportBuilder setStrikePrice(StrikePriceAndNotation _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public MASTransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport _strikePriceSchedule) {
            if (_strikePriceSchedule != null) {
                this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport _strikePriceSchedule, int idx) {
            this.getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
            return this;
        }

        @Override
        public MASTransactionReportBuilder addStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedules) {
            if (strikePriceSchedules != null) {
                for (StrikePriceScheduleReport strikePriceScheduleReport : strikePriceSchedules) {
                    this.strikePriceSchedule.add(strikePriceScheduleReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePriceSchedule")
        public MASTransactionReportBuilder setStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedules) {
            this.strikePriceSchedule = strikePriceSchedules == null ? new ArrayList<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder>() : (List)strikePriceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public MASTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
            this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public MASTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
            this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public MASTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public MASTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
            this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConventionOfLeg1")
        @RuneAttribute(value="fixedRateDayCountConventionOfLeg1")
        public MASTransactionReportBuilder setFixedRateDayCountConventionOfLeg1(InterestComputationMethod4Code _fixedRateDayCountConventionOfLeg1) {
            this.fixedRateDayCountConventionOfLeg1 = _fixedRateDayCountConventionOfLeg1 == null ? null : _fixedRateDayCountConventionOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConventionOfLeg2")
        @RuneAttribute(value="fixedRateDayCountConventionOfLeg2")
        public MASTransactionReportBuilder setFixedRateDayCountConventionOfLeg2(InterestComputationMethod4Code _fixedRateDayCountConventionOfLeg2) {
            this.fixedRateDayCountConventionOfLeg2 = _fixedRateDayCountConventionOfLeg2 == null ? null : _fixedRateDayCountConventionOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConventionOfLeg1")
        @RuneAttribute(value="floatingRateDayCountConventionOfLeg1")
        public MASTransactionReportBuilder setFloatingRateDayCountConventionOfLeg1(InterestComputationMethod4Code _floatingRateDayCountConventionOfLeg1) {
            this.floatingRateDayCountConventionOfLeg1 = _floatingRateDayCountConventionOfLeg1 == null ? null : _floatingRateDayCountConventionOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConventionOfLeg2")
        @RuneAttribute(value="floatingRateDayCountConventionOfLeg2")
        public MASTransactionReportBuilder setFloatingRateDayCountConventionOfLeg2(InterestComputationMethod4Code _floatingRateDayCountConventionOfLeg2) {
            this.floatingRateDayCountConventionOfLeg2 = _floatingRateDayCountConventionOfLeg2 == null ? null : _floatingRateDayCountConventionOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodOfLeg1")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodOfLeg1")
        public MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg1(String _floatingRateResetFrequencyPeriodOfLeg1) {
            this.floatingRateResetFrequencyPeriodOfLeg1 = _floatingRateResetFrequencyPeriodOfLeg1 == null ? null : _floatingRateResetFrequencyPeriodOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodMultiplierOfLeg1")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodMultiplierOfLeg1")
        public MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierOfLeg1(Integer _floatingRateResetFrequencyPeriodMultiplierOfLeg1) {
            this.floatingRateResetFrequencyPeriodMultiplierOfLeg1 = _floatingRateResetFrequencyPeriodMultiplierOfLeg1 == null ? null : _floatingRateResetFrequencyPeriodMultiplierOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodOfLeg2")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodOfLeg2")
        public MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg2(String _floatingRateResetFrequencyPeriodOfLeg2) {
            this.floatingRateResetFrequencyPeriodOfLeg2 = _floatingRateResetFrequencyPeriodOfLeg2 == null ? null : _floatingRateResetFrequencyPeriodOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodMultiplierOfLeg2")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodMultiplierOfLeg2")
        public MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierOfLeg2(Integer _floatingRateResetFrequencyPeriodMultiplierOfLeg2) {
            this.floatingRateResetFrequencyPeriodMultiplierOfLeg2 = _floatingRateResetFrequencyPeriodMultiplierOfLeg2 == null ? null : _floatingRateResetFrequencyPeriodMultiplierOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodOfLeg1")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodOfLeg1")
        public MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodOfLeg1(Frequency13Code__1 _fixedRatePaymentFrequencyPeriodOfLeg1) {
            this.fixedRatePaymentFrequencyPeriodOfLeg1 = _fixedRatePaymentFrequencyPeriodOfLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierOfLeg1")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierOfLeg1")
        public MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(Integer _fixedRatePaymentFrequencyPeriodMultiplierOfLeg1) {
            this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 = _fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodOfLeg2")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodOfLeg2")
        public MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodOfLeg2(Frequency13Code__1 _fixedRatePaymentFrequencyPeriodOfLeg2) {
            this.fixedRatePaymentFrequencyPeriodOfLeg2 = _fixedRatePaymentFrequencyPeriodOfLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierOfLeg2")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierOfLeg2")
        public MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(Integer _fixedRatePaymentFrequencyPeriodMultiplierOfLeg2) {
            this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 = _fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodOfLeg1")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodOfLeg1")
        public MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg1(Frequency13Code__1 _floatingRatePaymentFrequencyPeriodOfLeg1) {
            this.floatingRatePaymentFrequencyPeriodOfLeg1 = _floatingRatePaymentFrequencyPeriodOfLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
        public MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(Integer _floatingRatePaymentFrequencyPeriodMultiplierOfLeg1) {
            this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 = _floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodOfLeg2")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodOfLeg2")
        public MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg2(Frequency13Code__1 _floatingRatePaymentFrequencyPeriodOfLeg2) {
            this.floatingRatePaymentFrequencyPeriodOfLeg2 = _floatingRatePaymentFrequencyPeriodOfLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
        public MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(Integer _floatingRatePaymentFrequencyPeriodMultiplierOfLeg2) {
            this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 = _floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public MASTransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment) {
            if (_otherPayment != null) {
                this.otherPayment.add(_otherPayment.toBuilder());
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment, int idx) {
            this.getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
            return this;
        }

        @Override
        public MASTransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
            if (otherPayments != null) {
                for (OtherPaymentReport otherPaymentReport : otherPayments) {
                    this.otherPayment.add(otherPaymentReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPayment")
        public MASTransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
            this.otherPayment = otherPayments == null ? new ArrayList<OtherPaymentReport.OtherPaymentReportBuilder>() : (List)otherPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public MASTransactionReportBuilder setActionType(String _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public MASTransactionReportBuilder setEventType(String _eventType) {
            this.eventType = _eventType == null ? null : _eventType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public MASTransactionReportBuilder setEventDate(ZonedDateTime _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public MASTransactionReportBuilder setNonReportable(MASNonReportable _nonReportable) {
            this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public MASTransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public MASTransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
            this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty1")
        @RuneAttribute(value="executionAgentOfCounterparty1")
        public MASTransactionReportBuilder setExecutionAgentOfCounterparty1(String _executionAgentOfCounterparty1) {
            this.executionAgentOfCounterparty1 = _executionAgentOfCounterparty1 == null ? null : _executionAgentOfCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty2DTCC")
        @RuneAttribute(value="executionAgentOfCounterparty2DTCC")
        public MASTransactionReportBuilder setExecutionAgentOfCounterparty2DTCC(String _executionAgentOfCounterparty2DTCC) {
            this.executionAgentOfCounterparty2DTCC = _executionAgentOfCounterparty2DTCC == null ? null : _executionAgentOfCounterparty2DTCC;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg1DTCC")
        @RuneAttribute(value="notionalAmountScheduleLeg1DTCC")
        public MASTransactionReportBuilder addNotionalAmountScheduleLeg1DTCC(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1DTCC) {
            if (_notionalAmountScheduleLeg1DTCC != null) {
                this.notionalAmountScheduleLeg1DTCC.add(_notionalAmountScheduleLeg1DTCC.toBuilder());
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addNotionalAmountScheduleLeg1DTCC(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1DTCC, int idx) {
            this.getIndex(this.notionalAmountScheduleLeg1DTCC, idx, () -> _notionalAmountScheduleLeg1DTCC.toBuilder());
            return this;
        }

        @Override
        public MASTransactionReportBuilder addNotionalAmountScheduleLeg1DTCC(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1DTCCs) {
            if (notionalAmountScheduleLeg1DTCCs != null) {
                for (NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1Report : notionalAmountScheduleLeg1DTCCs) {
                    this.notionalAmountScheduleLeg1DTCC.add(notionalAmountScheduleLeg1Report.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalAmountScheduleLeg1DTCC")
        public MASTransactionReportBuilder setNotionalAmountScheduleLeg1DTCC(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1DTCCs) {
            this.notionalAmountScheduleLeg1DTCC = notionalAmountScheduleLeg1DTCCs == null ? new ArrayList<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>() : (List)notionalAmountScheduleLeg1DTCCs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg2DTCC")
        @RuneAttribute(value="notionalAmountScheduleLeg2DTCC")
        public MASTransactionReportBuilder addNotionalAmountScheduleLeg2DTCC(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2DTCC) {
            if (_notionalAmountScheduleLeg2DTCC != null) {
                this.notionalAmountScheduleLeg2DTCC.add(_notionalAmountScheduleLeg2DTCC.toBuilder());
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addNotionalAmountScheduleLeg2DTCC(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2DTCC, int idx) {
            this.getIndex(this.notionalAmountScheduleLeg2DTCC, idx, () -> _notionalAmountScheduleLeg2DTCC.toBuilder());
            return this;
        }

        @Override
        public MASTransactionReportBuilder addNotionalAmountScheduleLeg2DTCC(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2DTCCs) {
            if (notionalAmountScheduleLeg2DTCCs != null) {
                for (NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2Report : notionalAmountScheduleLeg2DTCCs) {
                    this.notionalAmountScheduleLeg2DTCC.add(notionalAmountScheduleLeg2Report.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalAmountScheduleLeg2DTCC")
        public MASTransactionReportBuilder setNotionalAmountScheduleLeg2DTCC(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2DTCCs) {
            this.notionalAmountScheduleLeg2DTCC = notionalAmountScheduleLeg2DTCCs == null ? new ArrayList<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>() : (List)notionalAmountScheduleLeg2DTCCs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityScheduleLeg1DTCC")
        @RuneAttribute(value="notionalQuantityScheduleLeg1DTCC")
        public MASTransactionReportBuilder addNotionalQuantityScheduleLeg1DTCC(NotionalQuantityScheduleLeg1Report _notionalQuantityScheduleLeg1DTCC) {
            if (_notionalQuantityScheduleLeg1DTCC != null) {
                this.notionalQuantityScheduleLeg1DTCC.add(_notionalQuantityScheduleLeg1DTCC.toBuilder());
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addNotionalQuantityScheduleLeg1DTCC(NotionalQuantityScheduleLeg1Report _notionalQuantityScheduleLeg1DTCC, int idx) {
            this.getIndex(this.notionalQuantityScheduleLeg1DTCC, idx, () -> _notionalQuantityScheduleLeg1DTCC.toBuilder());
            return this;
        }

        @Override
        public MASTransactionReportBuilder addNotionalQuantityScheduleLeg1DTCC(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1DTCCs) {
            if (notionalQuantityScheduleLeg1DTCCs != null) {
                for (NotionalQuantityScheduleLeg1Report notionalQuantityScheduleLeg1Report : notionalQuantityScheduleLeg1DTCCs) {
                    this.notionalQuantityScheduleLeg1DTCC.add(notionalQuantityScheduleLeg1Report.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalQuantityScheduleLeg1DTCC")
        public MASTransactionReportBuilder setNotionalQuantityScheduleLeg1DTCC(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1DTCCs) {
            this.notionalQuantityScheduleLeg1DTCC = notionalQuantityScheduleLeg1DTCCs == null ? new ArrayList<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder>() : (List)notionalQuantityScheduleLeg1DTCCs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityScheduleLeg2DTCC")
        @RuneAttribute(value="notionalQuantityScheduleLeg2DTCC")
        public MASTransactionReportBuilder addNotionalQuantityScheduleLeg2DTCC(NotionalQuantityScheduleLeg2Report _notionalQuantityScheduleLeg2DTCC) {
            if (_notionalQuantityScheduleLeg2DTCC != null) {
                this.notionalQuantityScheduleLeg2DTCC.add(_notionalQuantityScheduleLeg2DTCC.toBuilder());
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addNotionalQuantityScheduleLeg2DTCC(NotionalQuantityScheduleLeg2Report _notionalQuantityScheduleLeg2DTCC, int idx) {
            this.getIndex(this.notionalQuantityScheduleLeg2DTCC, idx, () -> _notionalQuantityScheduleLeg2DTCC.toBuilder());
            return this;
        }

        @Override
        public MASTransactionReportBuilder addNotionalQuantityScheduleLeg2DTCC(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2DTCCs) {
            if (notionalQuantityScheduleLeg2DTCCs != null) {
                for (NotionalQuantityScheduleLeg2Report notionalQuantityScheduleLeg2Report : notionalQuantityScheduleLeg2DTCCs) {
                    this.notionalQuantityScheduleLeg2DTCC.add(notionalQuantityScheduleLeg2Report.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalQuantityScheduleLeg2DTCC")
        public MASTransactionReportBuilder setNotionalQuantityScheduleLeg2DTCC(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2DTCCs) {
            this.notionalQuantityScheduleLeg2DTCC = notionalQuantityScheduleLeg2DTCCs == null ? new ArrayList<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder>() : (List)notionalQuantityScheduleLeg2DTCCs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MASTransactionReport build() {
            return new MASTransactionReportImpl(this);
        }

        @Override
        public MASTransactionReportBuilder toBuilder() {
            return this;
        }

        @Override
        public MASTransactionReportBuilder prune() {
            if (this.spreadOfLeg1 != null && !this.spreadOfLeg1.prune().hasData()) {
                this.spreadOfLeg1 = null;
            }
            if (this.spreadOfLeg2 != null && !this.spreadOfLeg2.prune().hasData()) {
                this.spreadOfLeg2 = null;
            }
            this.basketConstituents = this.basketConstituents.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.price != null && !this.price.prune().hasData()) {
                this.price = null;
            }
            this.priceSchedule = this.priceSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.strikePrice != null && !this.strikePrice.prune().hasData()) {
                this.strikePrice = null;
            }
            this.strikePriceSchedule = this.strikePriceSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.otherPayment = this.otherPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.nonReportable != null && !this.nonReportable.prune().hasData()) {
                this.nonReportable = null;
            }
            this.notionalAmountScheduleLeg1DTCC = this.notionalAmountScheduleLeg1DTCC.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.notionalAmountScheduleLeg2DTCC = this.notionalAmountScheduleLeg2DTCC.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.notionalQuantityScheduleLeg1DTCC = this.notionalQuantityScheduleLeg1DTCC.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.notionalQuantityScheduleLeg2DTCC = this.notionalQuantityScheduleLeg2DTCC.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCounterparty1() != null) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getTradingCapacityOfSpecifiedPerson() != null) {
                return true;
            }
            if (this.getDirection() != null) {
                return true;
            }
            if (this.getDirectionOfLeg1() != null) {
                return true;
            }
            if (this.getDirectionOfLeg2() != null) {
                return true;
            }
            if (this.getReportingSpecifiedPerson() != null) {
                return true;
            }
            if (this.getDataSubmitter() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifier() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifierProprietary() != null) {
                return true;
            }
            if (this.getUniqueProductIdentifier() != null) {
                return true;
            }
            if (this.getPriorUTI() != null) {
                return true;
            }
            if (this.getPriorUTIProprietary() != null) {
                return true;
            }
            if (this.getContractType() != null) {
                return true;
            }
            if (this.getAssetClass() != null) {
                return true;
            }
            if (this.getUnderlying() != null) {
                return true;
            }
            if (this.getUnderlyingIdentificationType() != null) {
                return true;
            }
            if (this.getUnderlyingIdOther() != null) {
                return true;
            }
            if (this.getUnderlyingIdOtherSource() != null) {
                return true;
            }
            if (this.getNameOfTheUnderlyingIndex() != null) {
                return true;
            }
            if (this.getFixedRateOfLeg1() != null) {
                return true;
            }
            if (this.getIdentifierOfFloatingRateOfLeg1() != null) {
                return true;
            }
            if (this.getNameOfTheFloatingRateOfLeg1() != null) {
                return true;
            }
            if (this.getSpreadOfLeg1() != null && this.getSpreadOfLeg1().hasData()) {
                return true;
            }
            if (this.getFixedRateOfLeg2() != null) {
                return true;
            }
            if (this.getIdentifierOfFloatingRateOfLeg2() != null) {
                return true;
            }
            if (this.getNameOfTheFloatingRateOfLeg2() != null) {
                return true;
            }
            if (this.getSpreadOfLeg2() != null && this.getSpreadOfLeg2().hasData()) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getOptionStyle() != null) {
                return true;
            }
            if (this.getFirstExerciseDate() != null) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getExpirationDate() != null) {
                return true;
            }
            if (this.getSwapLinkID() != null) {
                return true;
            }
            if (this.getPackageIdentifier() != null) {
                return true;
            }
            if (this.getDeliveryType() != null) {
                return true;
            }
            if (this.getSettlementCurrency1() != null) {
                return true;
            }
            if (this.getSettlementCurrency2() != null) {
                return true;
            }
            if (this.getFinalContractualSettlementDate() != null) {
                return true;
            }
            if (this.getCleared() != null) {
                return true;
            }
            if (this.getCentralCounterparty() != null) {
                return true;
            }
            if (this.getClearingMember() != null) {
                return true;
            }
            if (this.getClearingTimestamp() != null) {
                return true;
            }
            if (this.getPlatformIdentifier() != null) {
                return true;
            }
            if (this.getBookingLocation() != null) {
                return true;
            }
            if (this.getTraderLocation() != null) {
                return true;
            }
            if (this.getConfirmed() != null) {
                return true;
            }
            if (this.getConfirmationTimestamp() != null) {
                return true;
            }
            if (this.getExecutionTimestamp() != null) {
                return true;
            }
            if (this.getReportingTimestamp() != null) {
                return true;
            }
            if (this.getBasketConstituents() != null && this.getBasketConstituents().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getValuationAmount() != null) {
                return true;
            }
            if (this.getValuationCurrency() != null) {
                return true;
            }
            if (this.getValuationMethod() != null) {
                return true;
            }
            if (this.getValuationTimestamp() != null) {
                return true;
            }
            if (this.getCollateralPortfolioIndicator() != null) {
                return true;
            }
            if (this.getInitialMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getVariationMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getNotionalAmountOfTheContractOrLeg1() != null) {
                return true;
            }
            if (this.getNotionalCurrencyOfTheContractOrLeg1() != null) {
                return true;
            }
            if (this.getNotionalAmountOfLeg2() != null) {
                return true;
            }
            if (this.getNotionalCurrencyOfLeg2() != null) {
                return true;
            }
            if (this.getTotalNotionalQuantityOfTheContractOrLeg1() != null) {
                return true;
            }
            if (this.getQuantityUnitOfMeasureForTheContractOrLeg1() != null) {
                return true;
            }
            if (this.getNotionalQuantityOfTheContractOrLeg1() != null) {
                return true;
            }
            if (this.getQuantityFrequencyOfTheContractOrLeg1() != null) {
                return true;
            }
            if (this.getQuantityFrequencyMultiplierOfTheContractOrLeg1() != null) {
                return true;
            }
            if (this.getTotalNotionalQuantityLeg2() != null) {
                return true;
            }
            if (this.getQuantityUnitOfMeasureLeg2() != null) {
                return true;
            }
            if (this.getNotionalQuantityOfLeg2() != null) {
                return true;
            }
            if (this.getQuantityFrequencyOfLeg2() != null) {
                return true;
            }
            if (this.getQuantityFrequencyMultiplierOfLeg2() != null) {
                return true;
            }
            if (this.getCallAmount() != null) {
                return true;
            }
            if (this.getCallCurrency() != null) {
                return true;
            }
            if (this.getPutAmount() != null) {
                return true;
            }
            if (this.getPutCurrency() != null) {
                return true;
            }
            if (this.getPrice() != null && this.getPrice().hasData()) {
                return true;
            }
            if (this.getPriceUnitOfMeasure() != null) {
                return true;
            }
            if (this.getPriceSchedule() != null && this.getPriceSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getStrikePrice() != null && this.getStrikePrice().hasData()) {
                return true;
            }
            if (this.getStrikePriceSchedule() != null && this.getStrikePriceSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getOptionPremiumAmount() != null) {
                return true;
            }
            if (this.getOptionPremiumCurrency() != null) {
                return true;
            }
            if (this.getExchangeRate() != null) {
                return true;
            }
            if (this.getExchangeRateBasis() != null) {
                return true;
            }
            if (this.getFixedRateDayCountConventionOfLeg1() != null) {
                return true;
            }
            if (this.getFixedRateDayCountConventionOfLeg2() != null) {
                return true;
            }
            if (this.getFloatingRateDayCountConventionOfLeg1() != null) {
                return true;
            }
            if (this.getFloatingRateDayCountConventionOfLeg2() != null) {
                return true;
            }
            if (this.getFloatingRateResetFrequencyPeriodOfLeg1() != null) {
                return true;
            }
            if (this.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1() != null) {
                return true;
            }
            if (this.getFloatingRateResetFrequencyPeriodOfLeg2() != null) {
                return true;
            }
            if (this.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2() != null) {
                return true;
            }
            if (this.getFixedRatePaymentFrequencyPeriodOfLeg1() != null) {
                return true;
            }
            if (this.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1() != null) {
                return true;
            }
            if (this.getFixedRatePaymentFrequencyPeriodOfLeg2() != null) {
                return true;
            }
            if (this.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2() != null) {
                return true;
            }
            if (this.getFloatingRatePaymentFrequencyPeriodOfLeg1() != null) {
                return true;
            }
            if (this.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1() != null) {
                return true;
            }
            if (this.getFloatingRatePaymentFrequencyPeriodOfLeg2() != null) {
                return true;
            }
            if (this.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2() != null) {
                return true;
            }
            if (this.getOtherPayment() != null && this.getOtherPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getEventType() != null) {
                return true;
            }
            if (this.getEventDate() != null) {
                return true;
            }
            if (this.getNonReportable() != null && this.getNonReportable().hasData()) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            if (this.getCounterparty2Name() != null) {
                return true;
            }
            if (this.getExecutionAgentOfCounterparty1() != null) {
                return true;
            }
            if (this.getExecutionAgentOfCounterparty2DTCC() != null) {
                return true;
            }
            if (this.getNotionalAmountScheduleLeg1DTCC() != null && this.getNotionalAmountScheduleLeg1DTCC().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getNotionalAmountScheduleLeg2DTCC() != null && this.getNotionalAmountScheduleLeg2DTCC().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getNotionalQuantityScheduleLeg1DTCC() != null && this.getNotionalQuantityScheduleLeg1DTCC().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getNotionalQuantityScheduleLeg2DTCC() != null && this.getNotionalQuantityScheduleLeg2DTCC().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public MASTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MASTransactionReportBuilder o = (MASTransactionReportBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpreadOfLeg1(), (RosettaModelObjectBuilder)o.getSpreadOfLeg1(), this::setSpreadOfLeg1);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpreadOfLeg2(), (RosettaModelObjectBuilder)o.getSpreadOfLeg2(), this::setSpreadOfLeg2);
            merger.mergeRosetta(this.getBasketConstituents(), o.getBasketConstituents(), this::getOrCreateBasketConstituents);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrice(), (RosettaModelObjectBuilder)o.getPrice(), this::setPrice);
            merger.mergeRosetta(this.getPriceSchedule(), o.getPriceSchedule(), this::getOrCreatePriceSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikePrice(), (RosettaModelObjectBuilder)o.getStrikePrice(), this::setStrikePrice);
            merger.mergeRosetta(this.getStrikePriceSchedule(), o.getStrikePriceSchedule(), this::getOrCreateStrikePriceSchedule);
            merger.mergeRosetta(this.getOtherPayment(), o.getOtherPayment(), this::getOrCreateOtherPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNonReportable(), (RosettaModelObjectBuilder)o.getNonReportable(), this::setNonReportable);
            merger.mergeRosetta(this.getNotionalAmountScheduleLeg1DTCC(), o.getNotionalAmountScheduleLeg1DTCC(), this::getOrCreateNotionalAmountScheduleLeg1DTCC);
            merger.mergeRosetta(this.getNotionalAmountScheduleLeg2DTCC(), o.getNotionalAmountScheduleLeg2DTCC(), this::getOrCreateNotionalAmountScheduleLeg2DTCC);
            merger.mergeRosetta(this.getNotionalQuantityScheduleLeg1DTCC(), o.getNotionalQuantityScheduleLeg1DTCC(), this::getOrCreateNotionalQuantityScheduleLeg1DTCC);
            merger.mergeRosetta(this.getNotionalQuantityScheduleLeg2DTCC(), o.getNotionalQuantityScheduleLeg2DTCC(), this::getOrCreateNotionalQuantityScheduleLeg2DTCC);
            merger.mergeBasic((Object)this.getCounterparty1(), (Object)o.getCounterparty1(), this::setCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradingCapacityOfSpecifiedPerson(), (Object)o.getTradingCapacityOfSpecifiedPerson(), this::setTradingCapacityOfSpecifiedPerson, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection(), (Object)o.getDirection(), this::setDirection, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirectionOfLeg1(), (Object)o.getDirectionOfLeg1(), this::setDirectionOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirectionOfLeg2(), (Object)o.getDirectionOfLeg2(), this::setDirectionOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingSpecifiedPerson(), (Object)o.getReportingSpecifiedPerson(), this::setReportingSpecifiedPerson, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDataSubmitter(), (Object)o.getDataSubmitter(), this::setDataSubmitter, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifier(), (Object)o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifierProprietary(), (Object)o.getUniqueTransactionIdentifierProprietary(), this::setUniqueTransactionIdentifierProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueProductIdentifier(), (Object)o.getUniqueProductIdentifier(), this::setUniqueProductIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorUTI(), (Object)o.getPriorUTI(), this::setPriorUTI, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorUTIProprietary(), (Object)o.getPriorUTIProprietary(), this::setPriorUTIProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getContractType(), (Object)o.getContractType(), this::setContractType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAssetClass(), (Object)o.getAssetClass(), this::setAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlying(), (Object)o.getUnderlying(), this::setUnderlying, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdentificationType(), (Object)o.getUnderlyingIdentificationType(), this::setUnderlyingIdentificationType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdOther(), (Object)o.getUnderlyingIdOther(), this::setUnderlyingIdOther, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdOtherSource(), (Object)o.getUnderlyingIdOtherSource(), this::setUnderlyingIdOtherSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNameOfTheUnderlyingIndex(), (Object)o.getNameOfTheUnderlyingIndex(), this::setNameOfTheUnderlyingIndex, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRateOfLeg1(), (Object)o.getFixedRateOfLeg1(), this::setFixedRateOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIdentifierOfFloatingRateOfLeg1(), (Object)o.getIdentifierOfFloatingRateOfLeg1(), this::setIdentifierOfFloatingRateOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNameOfTheFloatingRateOfLeg1(), (Object)o.getNameOfTheFloatingRateOfLeg1(), this::setNameOfTheFloatingRateOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRateOfLeg2(), (Object)o.getFixedRateOfLeg2(), this::setFixedRateOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIdentifierOfFloatingRateOfLeg2(), (Object)o.getIdentifierOfFloatingRateOfLeg2(), this::setIdentifierOfFloatingRateOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNameOfTheFloatingRateOfLeg2(), (Object)o.getNameOfTheFloatingRateOfLeg2(), this::setNameOfTheFloatingRateOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionStyle(), (Object)o.getOptionStyle(), this::setOptionStyle, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFirstExerciseDate(), (Object)o.getFirstExerciseDate(), this::setFirstExerciseDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExpirationDate(), (Object)o.getExpirationDate(), this::setExpirationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSwapLinkID(), (Object)o.getSwapLinkID(), this::setSwapLinkID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageIdentifier(), (Object)o.getPackageIdentifier(), this::setPackageIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDeliveryType(), (Object)o.getDeliveryType(), this::setDeliveryType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementCurrency1(), (Object)o.getSettlementCurrency1(), this::setSettlementCurrency1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementCurrency2(), (Object)o.getSettlementCurrency2(), this::setSettlementCurrency2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFinalContractualSettlementDate(), (Object)o.getFinalContractualSettlementDate(), this::setFinalContractualSettlementDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCleared(), (Object)o.getCleared(), this::setCleared, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCentralCounterparty(), (Object)o.getCentralCounterparty(), this::setCentralCounterparty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingMember(), (Object)o.getClearingMember(), this::setClearingMember, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingTimestamp(), (Object)o.getClearingTimestamp(), this::setClearingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPlatformIdentifier(), (Object)o.getPlatformIdentifier(), this::setPlatformIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBookingLocation(), (Object)o.getBookingLocation(), this::setBookingLocation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTraderLocation(), (Object)o.getTraderLocation(), this::setTraderLocation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getConfirmed(), (Object)o.getConfirmed(), this::setConfirmed, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getConfirmationTimestamp(), (Object)o.getConfirmationTimestamp(), this::setConfirmationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionTimestamp(), (Object)o.getExecutionTimestamp(), this::setExecutionTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingTimestamp(), (Object)o.getReportingTimestamp(), this::setReportingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationAmount(), (Object)o.getValuationAmount(), this::setValuationAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationCurrency(), (Object)o.getValuationCurrency(), this::setValuationCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationMethod(), (Object)o.getValuationMethod(), this::setValuationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationTimestamp(), (Object)o.getValuationTimestamp(), this::setValuationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralPortfolioIndicator(), (Object)o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollateralPortfolioCode(), (Object)o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollateralPortfolioCode(), (Object)o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalAmountOfTheContractOrLeg1(), (Object)o.getNotionalAmountOfTheContractOrLeg1(), this::setNotionalAmountOfTheContractOrLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalCurrencyOfTheContractOrLeg1(), (Object)o.getNotionalCurrencyOfTheContractOrLeg1(), this::setNotionalCurrencyOfTheContractOrLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalAmountOfLeg2(), (Object)o.getNotionalAmountOfLeg2(), this::setNotionalAmountOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalCurrencyOfLeg2(), (Object)o.getNotionalCurrencyOfLeg2(), this::setNotionalCurrencyOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTotalNotionalQuantityOfTheContractOrLeg1(), (Object)o.getTotalNotionalQuantityOfTheContractOrLeg1(), this::setTotalNotionalQuantityOfTheContractOrLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityUnitOfMeasureForTheContractOrLeg1(), (Object)o.getQuantityUnitOfMeasureForTheContractOrLeg1(), this::setQuantityUnitOfMeasureForTheContractOrLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalQuantityOfTheContractOrLeg1(), (Object)o.getNotionalQuantityOfTheContractOrLeg1(), this::setNotionalQuantityOfTheContractOrLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityFrequencyOfTheContractOrLeg1(), (Object)o.getQuantityFrequencyOfTheContractOrLeg1(), this::setQuantityFrequencyOfTheContractOrLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityFrequencyMultiplierOfTheContractOrLeg1(), (Object)o.getQuantityFrequencyMultiplierOfTheContractOrLeg1(), this::setQuantityFrequencyMultiplierOfTheContractOrLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTotalNotionalQuantityLeg2(), (Object)o.getTotalNotionalQuantityLeg2(), this::setTotalNotionalQuantityLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityUnitOfMeasureLeg2(), (Object)o.getQuantityUnitOfMeasureLeg2(), this::setQuantityUnitOfMeasureLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalQuantityOfLeg2(), (Object)o.getNotionalQuantityOfLeg2(), this::setNotionalQuantityOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityFrequencyOfLeg2(), (Object)o.getQuantityFrequencyOfLeg2(), this::setQuantityFrequencyOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityFrequencyMultiplierOfLeg2(), (Object)o.getQuantityFrequencyMultiplierOfLeg2(), this::setQuantityFrequencyMultiplierOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallAmount(), (Object)o.getCallAmount(), this::setCallAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallCurrency(), (Object)o.getCallCurrency(), this::setCallCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPutAmount(), (Object)o.getPutAmount(), this::setPutAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPutCurrency(), (Object)o.getPutCurrency(), this::setPutCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceUnitOfMeasure(), (Object)o.getPriceUnitOfMeasure(), this::setPriceUnitOfMeasure, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumAmount(), (Object)o.getOptionPremiumAmount(), this::setOptionPremiumAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumCurrency(), (Object)o.getOptionPremiumCurrency(), this::setOptionPremiumCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeRate(), (Object)o.getExchangeRate(), this::setExchangeRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeRateBasis(), (Object)o.getExchangeRateBasis(), this::setExchangeRateBasis, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRateDayCountConventionOfLeg1(), (Object)o.getFixedRateDayCountConventionOfLeg1(), this::setFixedRateDayCountConventionOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRateDayCountConventionOfLeg2(), (Object)o.getFixedRateDayCountConventionOfLeg2(), this::setFixedRateDayCountConventionOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateDayCountConventionOfLeg1(), (Object)o.getFloatingRateDayCountConventionOfLeg1(), this::setFloatingRateDayCountConventionOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateDayCountConventionOfLeg2(), (Object)o.getFloatingRateDayCountConventionOfLeg2(), this::setFloatingRateDayCountConventionOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateResetFrequencyPeriodOfLeg1(), (Object)o.getFloatingRateResetFrequencyPeriodOfLeg1(), this::setFloatingRateResetFrequencyPeriodOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1(), (Object)o.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1(), this::setFloatingRateResetFrequencyPeriodMultiplierOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateResetFrequencyPeriodOfLeg2(), (Object)o.getFloatingRateResetFrequencyPeriodOfLeg2(), this::setFloatingRateResetFrequencyPeriodOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2(), (Object)o.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2(), this::setFloatingRateResetFrequencyPeriodMultiplierOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRatePaymentFrequencyPeriodOfLeg1(), (Object)o.getFixedRatePaymentFrequencyPeriodOfLeg1(), this::setFixedRatePaymentFrequencyPeriodOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(), (Object)o.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(), this::setFixedRatePaymentFrequencyPeriodMultiplierOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRatePaymentFrequencyPeriodOfLeg2(), (Object)o.getFixedRatePaymentFrequencyPeriodOfLeg2(), this::setFixedRatePaymentFrequencyPeriodOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(), (Object)o.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(), this::setFixedRatePaymentFrequencyPeriodMultiplierOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRatePaymentFrequencyPeriodOfLeg1(), (Object)o.getFloatingRatePaymentFrequencyPeriodOfLeg1(), this::setFloatingRatePaymentFrequencyPeriodOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), (Object)o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), this::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRatePaymentFrequencyPeriodOfLeg2(), (Object)o.getFloatingRatePaymentFrequencyPeriodOfLeg2(), this::setFloatingRatePaymentFrequencyPeriodOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), (Object)o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), this::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventType(), (Object)o.getEventType(), this::setEventType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventDate(), (Object)o.getEventDate(), this::setEventDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2Name(), (Object)o.getCounterparty2Name(), this::setCounterparty2Name, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfCounterparty1(), (Object)o.getExecutionAgentOfCounterparty1(), this::setExecutionAgentOfCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfCounterparty2DTCC(), (Object)o.getExecutionAgentOfCounterparty2DTCC(), this::setExecutionAgentOfCounterparty2DTCC, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MASTransactionReport _that = this.getType().cast(o);
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.tradingCapacityOfSpecifiedPerson, _that.getTradingCapacityOfSpecifiedPerson())) {
                return false;
            }
            if (!Objects.equals(this.direction, _that.getDirection())) {
                return false;
            }
            if (!Objects.equals(this.directionOfLeg1, _that.getDirectionOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.directionOfLeg2, _that.getDirectionOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.reportingSpecifiedPerson, _that.getReportingSpecifiedPerson())) {
                return false;
            }
            if (!Objects.equals(this.dataSubmitter, _that.getDataSubmitter())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.uniqueProductIdentifier, _that.getUniqueProductIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.priorUTI, _that.getPriorUTI())) {
                return false;
            }
            if (!Objects.equals(this.priorUTIProprietary, _that.getPriorUTIProprietary())) {
                return false;
            }
            if (!Objects.equals(this.contractType, _that.getContractType())) {
                return false;
            }
            if (!Objects.equals(this.assetClass, _that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.underlying, _that.getUnderlying())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdentificationType, _that.getUnderlyingIdentificationType())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOther, _that.getUnderlyingIdOther())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateOfLeg1, _that.getFixedRateOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.identifierOfFloatingRateOfLeg1, _that.getIdentifierOfFloatingRateOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheFloatingRateOfLeg1, _that.getNameOfTheFloatingRateOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.spreadOfLeg1, _that.getSpreadOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateOfLeg2, _that.getFixedRateOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.identifierOfFloatingRateOfLeg2, _that.getIdentifierOfFloatingRateOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheFloatingRateOfLeg2, _that.getNameOfTheFloatingRateOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.spreadOfLeg2, _that.getSpreadOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.optionType, _that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.optionStyle, _that.getOptionStyle())) {
                return false;
            }
            if (!Objects.equals(this.firstExerciseDate, _that.getFirstExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.swapLinkID, _that.getSwapLinkID())) {
                return false;
            }
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.deliveryType, _that.getDeliveryType())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency1, _that.getSettlementCurrency1())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency2, _that.getSettlementCurrency2())) {
                return false;
            }
            if (!Objects.equals(this.finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.cleared, _that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.centralCounterparty, _that.getCentralCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.clearingMember, _that.getClearingMember())) {
                return false;
            }
            if (!Objects.equals(this.clearingTimestamp, _that.getClearingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.platformIdentifier, _that.getPlatformIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.bookingLocation, _that.getBookingLocation())) {
                return false;
            }
            if (!Objects.equals(this.traderLocation, _that.getTraderLocation())) {
                return false;
            }
            if (!Objects.equals(this.confirmed, _that.getConfirmed())) {
                return false;
            }
            if (!Objects.equals(this.confirmationTimestamp, _that.getConfirmationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituents, _that.getBasketConstituents())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.valuationMethod, _that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmountOfTheContractOrLeg1, _that.getNotionalAmountOfTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrencyOfTheContractOrLeg1, _that.getNotionalCurrencyOfTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmountOfLeg2, _that.getNotionalAmountOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrencyOfLeg2, _that.getNotionalCurrencyOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantityOfTheContractOrLeg1, _that.getTotalNotionalQuantityOfTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasureForTheContractOrLeg1, _that.getQuantityUnitOfMeasureForTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalQuantityOfTheContractOrLeg1, _that.getNotionalQuantityOfTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.quantityFrequencyOfTheContractOrLeg1, _that.getQuantityFrequencyOfTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.quantityFrequencyMultiplierOfTheContractOrLeg1, _that.getQuantityFrequencyMultiplierOfTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) {
                return false;
            }
            if (!Objects.equals(this.notionalQuantityOfLeg2, _that.getNotionalQuantityOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.quantityFrequencyOfLeg2, _that.getQuantityFrequencyOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.quantityFrequencyMultiplierOfLeg2, _that.getQuantityFrequencyMultiplierOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.callAmount, _that.getCallAmount())) {
                return false;
            }
            if (!Objects.equals(this.callCurrency, _that.getCallCurrency())) {
                return false;
            }
            if (!Objects.equals(this.putAmount, _that.getPutAmount())) {
                return false;
            }
            if (!Objects.equals(this.putCurrency, _that.getPutCurrency())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals(this.priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) {
                return false;
            }
            if (!ListEquals.listEquals(this.priceSchedule, _that.getPriceSchedule())) {
                return false;
            }
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePriceSchedule, _that.getStrikePriceSchedule())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumAmount, _that.getOptionPremiumAmount())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumCurrency, _that.getOptionPremiumCurrency())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRateBasis, _that.getExchangeRateBasis())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateDayCountConventionOfLeg1, _that.getFixedRateDayCountConventionOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateDayCountConventionOfLeg2, _that.getFixedRateDayCountConventionOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateDayCountConventionOfLeg1, _that.getFloatingRateDayCountConventionOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateDayCountConventionOfLeg2, _that.getFloatingRateDayCountConventionOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodOfLeg1, _that.getFloatingRateResetFrequencyPeriodOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodMultiplierOfLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodOfLeg2, _that.getFloatingRateResetFrequencyPeriodOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodMultiplierOfLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodOfLeg1, _that.getFixedRatePaymentFrequencyPeriodOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodOfLeg2, _that.getFixedRatePaymentFrequencyPeriodOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPayment, _that.getOtherPayment())) {
                return false;
            }
            if (!Objects.equals(this.actionType, _that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventType, _that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals(this.nonReportable, _that.getNonReportable())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2Name, _that.getCounterparty2Name())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfCounterparty2DTCC, _that.getExecutionAgentOfCounterparty2DTCC())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountScheduleLeg1DTCC, _that.getNotionalAmountScheduleLeg1DTCC())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountScheduleLeg2DTCC, _that.getNotionalAmountScheduleLeg2DTCC())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalQuantityScheduleLeg1DTCC, _that.getNotionalQuantityScheduleLeg1DTCC())) {
                return false;
            }
            return ListEquals.listEquals(this.notionalQuantityScheduleLeg2DTCC, _that.getNotionalQuantityScheduleLeg2DTCC());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.tradingCapacityOfSpecifiedPerson != null ? this.tradingCapacityOfSpecifiedPerson.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.direction != null ? this.direction.hashCode() : 0);
            _result = 31 * _result + (this.directionOfLeg1 != null ? this.directionOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.directionOfLeg2 != null ? this.directionOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.reportingSpecifiedPerson != null ? this.reportingSpecifiedPerson.hashCode() : 0);
            _result = 31 * _result + (this.dataSubmitter != null ? this.dataSubmitter.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifier != null ? this.uniqueProductIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.priorUTI != null ? this.priorUTI.hashCode() : 0);
            _result = 31 * _result + (this.priorUTIProprietary != null ? this.priorUTIProprietary.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? this.contractType.hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? this.assetClass.hashCode() : 0);
            _result = 31 * _result + (this.underlying != null ? this.underlying.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdentificationType != null ? this.underlyingIdentificationType.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOther != null ? this.underlyingIdOther.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOtherSource != null ? this.underlyingIdOtherSource.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheUnderlyingIndex != null ? this.nameOfTheUnderlyingIndex.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateOfLeg1 != null ? this.fixedRateOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.identifierOfFloatingRateOfLeg1 != null ? this.identifierOfFloatingRateOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheFloatingRateOfLeg1 != null ? this.nameOfTheFloatingRateOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.spreadOfLeg1 != null ? this.spreadOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateOfLeg2 != null ? this.fixedRateOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.identifierOfFloatingRateOfLeg2 != null ? this.identifierOfFloatingRateOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheFloatingRateOfLeg2 != null ? this.nameOfTheFloatingRateOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.spreadOfLeg2 != null ? this.spreadOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? this.optionType.hashCode() : 0);
            _result = 31 * _result + (this.optionStyle != null ? this.optionStyle.hashCode() : 0);
            _result = 31 * _result + (this.firstExerciseDate != null ? this.firstExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.swapLinkID != null ? this.swapLinkID.hashCode() : 0);
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? this.deliveryType.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency1 != null ? this.settlementCurrency1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency2 != null ? this.settlementCurrency2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.finalContractualSettlementDate != null ? this.finalContractualSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? this.cleared.hashCode() : 0);
            _result = 31 * _result + (this.centralCounterparty != null ? this.centralCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.clearingMember != null ? this.clearingMember.hashCode() : 0);
            _result = 31 * _result + (this.clearingTimestamp != null ? this.clearingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.platformIdentifier != null ? this.platformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.bookingLocation != null ? this.bookingLocation.hashCode() : 0);
            _result = 31 * _result + (this.traderLocation != null ? this.traderLocation.hashCode() : 0);
            _result = 31 * _result + (this.confirmed != null ? this.confirmed.hashCode() : 0);
            _result = 31 * _result + (this.confirmationTimestamp != null ? this.confirmationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.basketConstituents != null ? this.basketConstituents.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? this.valuationMethod.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountOfTheContractOrLeg1 != null ? this.notionalAmountOfTheContractOrLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrencyOfTheContractOrLeg1 != null ? this.notionalCurrencyOfTheContractOrLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountOfLeg2 != null ? this.notionalAmountOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrencyOfLeg2 != null ? this.notionalCurrencyOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantityOfTheContractOrLeg1 != null ? this.totalNotionalQuantityOfTheContractOrLeg1.hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasureForTheContractOrLeg1 != null ? this.quantityUnitOfMeasureForTheContractOrLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityOfTheContractOrLeg1 != null ? this.notionalQuantityOfTheContractOrLeg1.hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequencyOfTheContractOrLeg1 != null ? this.quantityFrequencyOfTheContractOrLeg1.hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequencyMultiplierOfTheContractOrLeg1 != null ? this.quantityFrequencyMultiplierOfTheContractOrLeg1.hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantityLeg2 != null ? this.totalNotionalQuantityLeg2.hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasureLeg2 != null ? this.quantityUnitOfMeasureLeg2.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityOfLeg2 != null ? this.notionalQuantityOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequencyOfLeg2 != null ? this.quantityFrequencyOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequencyMultiplierOfLeg2 != null ? this.quantityFrequencyMultiplierOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.callAmount != null ? this.callAmount.hashCode() : 0);
            _result = 31 * _result + (this.callCurrency != null ? this.callCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.putAmount != null ? this.putAmount.hashCode() : 0);
            _result = 31 * _result + (this.putCurrency != null ? this.putCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.priceUnitOfMeasure != null ? this.priceUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.priceSchedule != null ? this.priceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceSchedule != null ? this.strikePriceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumAmount != null ? this.optionPremiumAmount.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumCurrency != null ? this.optionPremiumCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRateBasis != null ? this.exchangeRateBasis.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateDayCountConventionOfLeg1 != null ? this.fixedRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRateDayCountConventionOfLeg2 != null ? this.fixedRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDayCountConventionOfLeg1 != null ? this.floatingRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDayCountConventionOfLeg2 != null ? this.floatingRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodOfLeg1 != null ? this.floatingRateResetFrequencyPeriodOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodMultiplierOfLeg1 != null ? this.floatingRateResetFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodOfLeg2 != null ? this.floatingRateResetFrequencyPeriodOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodMultiplierOfLeg2 != null ? this.floatingRateResetFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodOfLeg1 != null ? this.fixedRatePaymentFrequencyPeriodOfLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 != null ? this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodOfLeg2 != null ? this.fixedRatePaymentFrequencyPeriodOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 != null ? this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodOfLeg1 != null ? this.floatingRatePaymentFrequencyPeriodOfLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 != null ? this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodOfLeg2 != null ? this.floatingRatePaymentFrequencyPeriodOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 != null ? this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.otherPayment != null ? this.otherPayment.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? this.actionType.hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? this.eventType.hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.nonReportable != null ? this.nonReportable.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2Name != null ? this.counterparty2Name.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfCounterparty1 != null ? this.executionAgentOfCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfCounterparty2DTCC != null ? this.executionAgentOfCounterparty2DTCC.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountScheduleLeg1DTCC != null ? this.notionalAmountScheduleLeg1DTCC.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountScheduleLeg2DTCC != null ? this.notionalAmountScheduleLeg2DTCC.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityScheduleLeg1DTCC != null ? this.notionalQuantityScheduleLeg1DTCC.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityScheduleLeg2DTCC != null ? this.notionalQuantityScheduleLeg2DTCC.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MASTransactionReportBuilder {counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", tradingCapacityOfSpecifiedPerson=" + String.valueOf(this.tradingCapacityOfSpecifiedPerson) + ", direction=" + this.direction + ", directionOfLeg1=" + this.directionOfLeg1 + ", directionOfLeg2=" + this.directionOfLeg2 + ", reportingSpecifiedPerson=" + this.reportingSpecifiedPerson + ", dataSubmitter=" + this.dataSubmitter + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", priorUTI=" + this.priorUTI + ", priorUTIProprietary=" + this.priorUTIProprietary + ", contractType=" + this.contractType + ", assetClass=" + this.assetClass + ", underlying=" + this.underlying + ", underlyingIdentificationType=" + this.underlyingIdentificationType + ", underlyingIdOther=" + this.underlyingIdOther + ", underlyingIdOtherSource=" + this.underlyingIdOtherSource + ", nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", fixedRateOfLeg1=" + String.valueOf(this.fixedRateOfLeg1) + ", identifierOfFloatingRateOfLeg1=" + this.identifierOfFloatingRateOfLeg1 + ", nameOfTheFloatingRateOfLeg1=" + this.nameOfTheFloatingRateOfLeg1 + ", spreadOfLeg1=" + String.valueOf(this.spreadOfLeg1) + ", fixedRateOfLeg2=" + String.valueOf(this.fixedRateOfLeg2) + ", identifierOfFloatingRateOfLeg2=" + this.identifierOfFloatingRateOfLeg2 + ", nameOfTheFloatingRateOfLeg2=" + this.nameOfTheFloatingRateOfLeg2 + ", spreadOfLeg2=" + String.valueOf(this.spreadOfLeg2) + ", optionType=" + this.optionType + ", optionStyle=" + this.optionStyle + ", firstExerciseDate=" + String.valueOf(this.firstExerciseDate) + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", expirationDate=" + String.valueOf(this.expirationDate) + ", swapLinkID=" + this.swapLinkID + ", packageIdentifier=" + this.packageIdentifier + ", deliveryType=" + this.deliveryType + ", settlementCurrency1=" + String.valueOf(this.settlementCurrency1) + ", settlementCurrency2=" + String.valueOf(this.settlementCurrency2) + ", finalContractualSettlementDate=" + String.valueOf(this.finalContractualSettlementDate) + ", cleared=" + this.cleared + ", centralCounterparty=" + this.centralCounterparty + ", clearingMember=" + this.clearingMember + ", clearingTimestamp=" + String.valueOf(this.clearingTimestamp) + ", platformIdentifier=" + this.platformIdentifier + ", bookingLocation=" + this.bookingLocation + ", traderLocation=" + this.traderLocation + ", confirmed=" + this.confirmed + ", confirmationTimestamp=" + String.valueOf(this.confirmationTimestamp) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", basketConstituents=" + String.valueOf(this.basketConstituents) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf(this.valuationMethod) + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", notionalAmountOfTheContractOrLeg1=" + String.valueOf(this.notionalAmountOfTheContractOrLeg1) + ", notionalCurrencyOfTheContractOrLeg1=" + String.valueOf(this.notionalCurrencyOfTheContractOrLeg1) + ", notionalAmountOfLeg2=" + String.valueOf(this.notionalAmountOfLeg2) + ", notionalCurrencyOfLeg2=" + String.valueOf(this.notionalCurrencyOfLeg2) + ", totalNotionalQuantityOfTheContractOrLeg1=" + String.valueOf(this.totalNotionalQuantityOfTheContractOrLeg1) + ", quantityUnitOfMeasureForTheContractOrLeg1=" + this.quantityUnitOfMeasureForTheContractOrLeg1 + ", notionalQuantityOfTheContractOrLeg1=" + String.valueOf(this.notionalQuantityOfTheContractOrLeg1) + ", quantityFrequencyOfTheContractOrLeg1=" + this.quantityFrequencyOfTheContractOrLeg1 + ", quantityFrequencyMultiplierOfTheContractOrLeg1=" + this.quantityFrequencyMultiplierOfTheContractOrLeg1 + ", totalNotionalQuantityLeg2=" + String.valueOf(this.totalNotionalQuantityLeg2) + ", quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", notionalQuantityOfLeg2=" + String.valueOf(this.notionalQuantityOfLeg2) + ", quantityFrequencyOfLeg2=" + this.quantityFrequencyOfLeg2 + ", quantityFrequencyMultiplierOfLeg2=" + this.quantityFrequencyMultiplierOfLeg2 + ", callAmount=" + String.valueOf(this.callAmount) + ", callCurrency=" + String.valueOf(this.callCurrency) + ", putAmount=" + String.valueOf(this.putAmount) + ", putCurrency=" + String.valueOf(this.putCurrency) + ", price=" + String.valueOf(this.price) + ", priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", priceSchedule=" + String.valueOf(this.priceSchedule) + ", strikePrice=" + String.valueOf(this.strikePrice) + ", strikePriceSchedule=" + String.valueOf(this.strikePriceSchedule) + ", optionPremiumAmount=" + String.valueOf(this.optionPremiumAmount) + ", optionPremiumCurrency=" + String.valueOf(this.optionPremiumCurrency) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + ", exchangeRateBasis=" + this.exchangeRateBasis + ", fixedRateDayCountConventionOfLeg1=" + String.valueOf(this.fixedRateDayCountConventionOfLeg1) + ", fixedRateDayCountConventionOfLeg2=" + String.valueOf(this.fixedRateDayCountConventionOfLeg2) + ", floatingRateDayCountConventionOfLeg1=" + String.valueOf(this.floatingRateDayCountConventionOfLeg1) + ", floatingRateDayCountConventionOfLeg2=" + String.valueOf(this.floatingRateDayCountConventionOfLeg2) + ", floatingRateResetFrequencyPeriodOfLeg1=" + this.floatingRateResetFrequencyPeriodOfLeg1 + ", floatingRateResetFrequencyPeriodMultiplierOfLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierOfLeg1 + ", floatingRateResetFrequencyPeriodOfLeg2=" + this.floatingRateResetFrequencyPeriodOfLeg2 + ", floatingRateResetFrequencyPeriodMultiplierOfLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierOfLeg2 + ", fixedRatePaymentFrequencyPeriodOfLeg1=" + String.valueOf(this.fixedRatePaymentFrequencyPeriodOfLeg1) + ", fixedRatePaymentFrequencyPeriodMultiplierOfLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 + ", fixedRatePaymentFrequencyPeriodOfLeg2=" + String.valueOf(this.fixedRatePaymentFrequencyPeriodOfLeg2) + ", fixedRatePaymentFrequencyPeriodMultiplierOfLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 + ", floatingRatePaymentFrequencyPeriodOfLeg1=" + String.valueOf(this.floatingRatePaymentFrequencyPeriodOfLeg1) + ", floatingRatePaymentFrequencyPeriodMultiplierOfLeg1=" + (this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 + ", floatingRatePaymentFrequencyPeriodOfLeg2=" + String.valueOf(this.floatingRatePaymentFrequencyPeriodOfLeg2) + ", floatingRatePaymentFrequencyPeriodMultiplierOfLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 + ", otherPayment=" + String.valueOf(this.otherPayment) + ", actionType=" + this.actionType + ", eventType=" + this.eventType + ", eventDate=" + String.valueOf(this.eventDate) + ", nonReportable=" + String.valueOf(this.nonReportable) + ", technicalRecordId=" + this.technicalRecordId + ", counterparty2Name=" + this.counterparty2Name + ", executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 + ", executionAgentOfCounterparty2DTCC=" + this.executionAgentOfCounterparty2DTCC + ", notionalAmountScheduleLeg1DTCC=" + String.valueOf(this.notionalAmountScheduleLeg1DTCC) + ", notionalAmountScheduleLeg2DTCC=" + String.valueOf(this.notionalAmountScheduleLeg2DTCC) + ", notionalQuantityScheduleLeg1DTCC=" + String.valueOf(this.notionalQuantityScheduleLeg1DTCC) + ", notionalQuantityScheduleLeg2DTCC=" + String.valueOf(this.notionalQuantityScheduleLeg2DTCC) + "}");
        }
    }

    public static interface MASTransactionReportBuilder
    extends MASTransactionReport,
    RosettaModelObjectBuilder {
        public SpreadOfLeg1.SpreadOfLeg1Builder getOrCreateSpreadOfLeg1();

        @Override
        public SpreadOfLeg1.SpreadOfLeg1Builder getSpreadOfLeg1();

        public SpreadOfLeg2.SpreadOfLeg2Builder getOrCreateSpreadOfLeg2();

        @Override
        public SpreadOfLeg2.SpreadOfLeg2Builder getSpreadOfLeg2();

        public BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int var1);

        public List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents();

        public PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice();

        @Override
        public PriceAndNotation.PriceAndNotationBuilder getPrice();

        public PriceScheduleReport.PriceScheduleReportBuilder getOrCreatePriceSchedule(int var1);

        public List<? extends PriceScheduleReport.PriceScheduleReportBuilder> getPriceSchedule();

        public StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice();

        @Override
        public StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice();

        public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder getOrCreateStrikePriceSchedule(int var1);

        public List<? extends StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> getStrikePriceSchedule();

        public OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int var1);

        public List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment();

        public MASNonReportable.MASNonReportableBuilder getOrCreateNonReportable();

        @Override
        public MASNonReportable.MASNonReportableBuilder getNonReportable();

        public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1DTCC(int var1);

        public List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1DTCC();

        public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2DTCC(int var1);

        public List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2DTCC();

        public NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder getOrCreateNotionalQuantityScheduleLeg1DTCC(int var1);

        public List<? extends NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> getNotionalQuantityScheduleLeg1DTCC();

        public NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder getOrCreateNotionalQuantityScheduleLeg2DTCC(int var1);

        public List<? extends NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> getNotionalQuantityScheduleLeg2DTCC();

        public MASTransactionReportBuilder setCounterparty1(String var1);

        public MASTransactionReportBuilder setCounterparty2(String var1);

        public MASTransactionReportBuilder setCounterparty2IdentifierType(Boolean var1);

        public MASTransactionReportBuilder setTradingCapacityOfSpecifiedPerson(TradingCapacity7Code var1);

        public MASTransactionReportBuilder setDirection(String var1);

        public MASTransactionReportBuilder setDirectionOfLeg1(String var1);

        public MASTransactionReportBuilder setDirectionOfLeg2(String var1);

        public MASTransactionReportBuilder setReportingSpecifiedPerson(String var1);

        public MASTransactionReportBuilder setDataSubmitter(String var1);

        public MASTransactionReportBuilder setUniqueTransactionIdentifier(String var1);

        public MASTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        public MASTransactionReportBuilder setUniqueProductIdentifier(String var1);

        public MASTransactionReportBuilder setPriorUTI(String var1);

        public MASTransactionReportBuilder setPriorUTIProprietary(String var1);

        public MASTransactionReportBuilder setContractType(String var1);

        public MASTransactionReportBuilder setAssetClass(String var1);

        public MASTransactionReportBuilder setUnderlying(String var1);

        public MASTransactionReportBuilder setUnderlyingIdentificationType(String var1);

        public MASTransactionReportBuilder setUnderlyingIdOther(String var1);

        public MASTransactionReportBuilder setUnderlyingIdOtherSource(String var1);

        public MASTransactionReportBuilder setNameOfTheUnderlyingIndex(String var1);

        public MASTransactionReportBuilder setFixedRateOfLeg1(BigDecimal var1);

        public MASTransactionReportBuilder setIdentifierOfFloatingRateOfLeg1(String var1);

        public MASTransactionReportBuilder setNameOfTheFloatingRateOfLeg1(String var1);

        public MASTransactionReportBuilder setSpreadOfLeg1(SpreadOfLeg1 var1);

        public MASTransactionReportBuilder setFixedRateOfLeg2(BigDecimal var1);

        public MASTransactionReportBuilder setIdentifierOfFloatingRateOfLeg2(String var1);

        public MASTransactionReportBuilder setNameOfTheFloatingRateOfLeg2(String var1);

        public MASTransactionReportBuilder setSpreadOfLeg2(SpreadOfLeg2 var1);

        public MASTransactionReportBuilder setOptionType(String var1);

        public MASTransactionReportBuilder setOptionStyle(String var1);

        public MASTransactionReportBuilder setFirstExerciseDate(Date var1);

        public MASTransactionReportBuilder setEffectiveDate(Date var1);

        public MASTransactionReportBuilder setExpirationDate(Date var1);

        public MASTransactionReportBuilder setSwapLinkID(String var1);

        public MASTransactionReportBuilder setPackageIdentifier(String var1);

        public MASTransactionReportBuilder setDeliveryType(String var1);

        public MASTransactionReportBuilder setSettlementCurrency1(ISOCurrencyCodeEnum var1);

        public MASTransactionReportBuilder setSettlementCurrency2(ISOCurrencyCodeEnum var1);

        public MASTransactionReportBuilder setFinalContractualSettlementDate(Date var1);

        public MASTransactionReportBuilder setCleared(String var1);

        public MASTransactionReportBuilder setCentralCounterparty(String var1);

        public MASTransactionReportBuilder setClearingMember(String var1);

        public MASTransactionReportBuilder setClearingTimestamp(ZonedDateTime var1);

        public MASTransactionReportBuilder setPlatformIdentifier(String var1);

        public MASTransactionReportBuilder setBookingLocation(String var1);

        public MASTransactionReportBuilder setTraderLocation(String var1);

        public MASTransactionReportBuilder setConfirmed(String var1);

        public MASTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime var1);

        public MASTransactionReportBuilder setExecutionTimestamp(ZonedDateTime var1);

        public MASTransactionReportBuilder setReportingTimestamp(ZonedDateTime var1);

        public MASTransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1);

        public MASTransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1, int var2);

        public MASTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> var1);

        public MASTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> var1);

        public MASTransactionReportBuilder setValuationAmount(BigDecimal var1);

        public MASTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        public MASTransactionReportBuilder setValuationMethod(ValuationType1Code var1);

        public MASTransactionReportBuilder setValuationTimestamp(ZonedDateTime var1);

        public MASTransactionReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        public MASTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        public MASTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        public MASTransactionReportBuilder setNotionalAmountOfTheContractOrLeg1(BigDecimal var1);

        public MASTransactionReportBuilder setNotionalCurrencyOfTheContractOrLeg1(ISOCurrencyCodeEnum var1);

        public MASTransactionReportBuilder setNotionalAmountOfLeg2(BigDecimal var1);

        public MASTransactionReportBuilder setNotionalCurrencyOfLeg2(ISOCurrencyCodeEnum var1);

        public MASTransactionReportBuilder setTotalNotionalQuantityOfTheContractOrLeg1(BigDecimal var1);

        public MASTransactionReportBuilder setQuantityUnitOfMeasureForTheContractOrLeg1(String var1);

        public MASTransactionReportBuilder setNotionalQuantityOfTheContractOrLeg1(BigDecimal var1);

        public MASTransactionReportBuilder setQuantityFrequencyOfTheContractOrLeg1(String var1);

        public MASTransactionReportBuilder setQuantityFrequencyMultiplierOfTheContractOrLeg1(Integer var1);

        public MASTransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal var1);

        public MASTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String var1);

        public MASTransactionReportBuilder setNotionalQuantityOfLeg2(BigDecimal var1);

        public MASTransactionReportBuilder setQuantityFrequencyOfLeg2(String var1);

        public MASTransactionReportBuilder setQuantityFrequencyMultiplierOfLeg2(Integer var1);

        public MASTransactionReportBuilder setCallAmount(BigDecimal var1);

        public MASTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum var1);

        public MASTransactionReportBuilder setPutAmount(BigDecimal var1);

        public MASTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum var1);

        public MASTransactionReportBuilder setPrice(PriceAndNotation var1);

        public MASTransactionReportBuilder setPriceUnitOfMeasure(String var1);

        public MASTransactionReportBuilder addPriceSchedule(PriceScheduleReport var1);

        public MASTransactionReportBuilder addPriceSchedule(PriceScheduleReport var1, int var2);

        public MASTransactionReportBuilder addPriceSchedule(List<? extends PriceScheduleReport> var1);

        public MASTransactionReportBuilder setPriceSchedule(List<? extends PriceScheduleReport> var1);

        public MASTransactionReportBuilder setStrikePrice(StrikePriceAndNotation var1);

        public MASTransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport var1);

        public MASTransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport var1, int var2);

        public MASTransactionReportBuilder addStrikePriceSchedule(List<? extends StrikePriceScheduleReport> var1);

        public MASTransactionReportBuilder setStrikePriceSchedule(List<? extends StrikePriceScheduleReport> var1);

        public MASTransactionReportBuilder setOptionPremiumAmount(BigDecimal var1);

        public MASTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum var1);

        public MASTransactionReportBuilder setExchangeRate(BigDecimal var1);

        public MASTransactionReportBuilder setExchangeRateBasis(String var1);

        public MASTransactionReportBuilder setFixedRateDayCountConventionOfLeg1(InterestComputationMethod4Code var1);

        public MASTransactionReportBuilder setFixedRateDayCountConventionOfLeg2(InterestComputationMethod4Code var1);

        public MASTransactionReportBuilder setFloatingRateDayCountConventionOfLeg1(InterestComputationMethod4Code var1);

        public MASTransactionReportBuilder setFloatingRateDayCountConventionOfLeg2(InterestComputationMethod4Code var1);

        public MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg1(String var1);

        public MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierOfLeg1(Integer var1);

        public MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg2(String var1);

        public MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierOfLeg2(Integer var1);

        public MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodOfLeg1(Frequency13Code__1 var1);

        public MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(Integer var1);

        public MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodOfLeg2(Frequency13Code__1 var1);

        public MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(Integer var1);

        public MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg1(Frequency13Code__1 var1);

        public MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(Integer var1);

        public MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg2(Frequency13Code__1 var1);

        public MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(Integer var1);

        public MASTransactionReportBuilder addOtherPayment(OtherPaymentReport var1);

        public MASTransactionReportBuilder addOtherPayment(OtherPaymentReport var1, int var2);

        public MASTransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> var1);

        public MASTransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> var1);

        public MASTransactionReportBuilder setActionType(String var1);

        public MASTransactionReportBuilder setEventType(String var1);

        public MASTransactionReportBuilder setEventDate(ZonedDateTime var1);

        public MASTransactionReportBuilder setNonReportable(MASNonReportable var1);

        public MASTransactionReportBuilder setTechnicalRecordId(String var1);

        public MASTransactionReportBuilder setCounterparty2Name(String var1);

        public MASTransactionReportBuilder setExecutionAgentOfCounterparty1(String var1);

        public MASTransactionReportBuilder setExecutionAgentOfCounterparty2DTCC(String var1);

        public MASTransactionReportBuilder addNotionalAmountScheduleLeg1DTCC(NotionalAmountScheduleLeg1Report var1);

        public MASTransactionReportBuilder addNotionalAmountScheduleLeg1DTCC(NotionalAmountScheduleLeg1Report var1, int var2);

        public MASTransactionReportBuilder addNotionalAmountScheduleLeg1DTCC(List<? extends NotionalAmountScheduleLeg1Report> var1);

        public MASTransactionReportBuilder setNotionalAmountScheduleLeg1DTCC(List<? extends NotionalAmountScheduleLeg1Report> var1);

        public MASTransactionReportBuilder addNotionalAmountScheduleLeg2DTCC(NotionalAmountScheduleLeg2Report var1);

        public MASTransactionReportBuilder addNotionalAmountScheduleLeg2DTCC(NotionalAmountScheduleLeg2Report var1, int var2);

        public MASTransactionReportBuilder addNotionalAmountScheduleLeg2DTCC(List<? extends NotionalAmountScheduleLeg2Report> var1);

        public MASTransactionReportBuilder setNotionalAmountScheduleLeg2DTCC(List<? extends NotionalAmountScheduleLeg2Report> var1);

        public MASTransactionReportBuilder addNotionalQuantityScheduleLeg1DTCC(NotionalQuantityScheduleLeg1Report var1);

        public MASTransactionReportBuilder addNotionalQuantityScheduleLeg1DTCC(NotionalQuantityScheduleLeg1Report var1, int var2);

        public MASTransactionReportBuilder addNotionalQuantityScheduleLeg1DTCC(List<? extends NotionalQuantityScheduleLeg1Report> var1);

        public MASTransactionReportBuilder setNotionalQuantityScheduleLeg1DTCC(List<? extends NotionalQuantityScheduleLeg1Report> var1);

        public MASTransactionReportBuilder addNotionalQuantityScheduleLeg2DTCC(NotionalQuantityScheduleLeg2Report var1);

        public MASTransactionReportBuilder addNotionalQuantityScheduleLeg2DTCC(NotionalQuantityScheduleLeg2Report var1, int var2);

        public MASTransactionReportBuilder addNotionalQuantityScheduleLeg2DTCC(List<? extends NotionalQuantityScheduleLeg2Report> var1);

        public MASTransactionReportBuilder setNotionalQuantityScheduleLeg2DTCC(List<? extends NotionalQuantityScheduleLeg2Report> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradingCapacityOfSpecifiedPerson"), TradingCapacity7Code.class, (Object)this.getTradingCapacityOfSpecifiedPerson(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction"), String.class, (Object)this.getDirection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("directionOfLeg1"), String.class, (Object)this.getDirectionOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("directionOfLeg2"), String.class, (Object)this.getDirectionOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingSpecifiedPerson"), String.class, (Object)this.getReportingSpecifiedPerson(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dataSubmitter"), String.class, (Object)this.getDataSubmitter(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractType"), String.class, (Object)this.getContractType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), String.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlying"), String.class, (Object)this.getUnderlying(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOtherSource"), String.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRateOfLeg1"), BigDecimal.class, (Object)this.getFixedRateOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg1"), String.class, (Object)this.getIdentifierOfFloatingRateOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg1"), String.class, (Object)this.getNameOfTheFloatingRateOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadOfLeg1"), processor, SpreadOfLeg1.SpreadOfLeg1Builder.class, this.getSpreadOfLeg1(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRateOfLeg2"), BigDecimal.class, (Object)this.getFixedRateOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg2"), String.class, (Object)this.getIdentifierOfFloatingRateOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg2"), String.class, (Object)this.getNameOfTheFloatingRateOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadOfLeg2"), processor, SpreadOfLeg2.SpreadOfLeg2Builder.class, this.getSpreadOfLeg2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), String.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionStyle"), String.class, (Object)this.getOptionStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryType"), String.class, (Object)this.getDeliveryType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementCurrency1"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementCurrency2"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), String.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bookingLocation"), String.class, (Object)this.getBookingLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("traderLocation"), String.class, (Object)this.getTraderLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmed"), String.class, (Object)this.getConfirmed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, this.getBasketConstituents(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAmountOfTheContractOrLeg1"), BigDecimal.class, (Object)this.getNotionalAmountOfTheContractOrLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalCurrencyOfTheContractOrLeg1"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrencyOfTheContractOrLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAmountOfLeg2"), BigDecimal.class, (Object)this.getNotionalAmountOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalCurrencyOfLeg2"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrencyOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalNotionalQuantityOfTheContractOrLeg1"), BigDecimal.class, (Object)this.getTotalNotionalQuantityOfTheContractOrLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityUnitOfMeasureForTheContractOrLeg1"), String.class, (Object)this.getQuantityUnitOfMeasureForTheContractOrLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalQuantityOfTheContractOrLeg1"), BigDecimal.class, (Object)this.getNotionalQuantityOfTheContractOrLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityFrequencyOfTheContractOrLeg1"), String.class, (Object)this.getQuantityFrequencyOfTheContractOrLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityFrequencyMultiplierOfTheContractOrLeg1"), Integer.class, (Object)this.getQuantityFrequencyMultiplierOfTheContractOrLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, (Object)this.getTotalNotionalQuantityLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, (Object)this.getQuantityUnitOfMeasureLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalQuantityOfLeg2"), BigDecimal.class, (Object)this.getNotionalQuantityOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityFrequencyOfLeg2"), String.class, (Object)this.getQuantityFrequencyOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityFrequencyMultiplierOfLeg2"), Integer.class, (Object)this.getQuantityFrequencyMultiplierOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, PriceAndNotation.PriceAndNotationBuilder.class, this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSchedule"), processor, PriceScheduleReport.PriceScheduleReportBuilder.class, this.getPriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.StrikePriceAndNotationBuilder.class, this.getStrikePrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, StrikePriceScheduleReport.StrikePriceScheduleReportBuilder.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, (Object)this.getFixedRateDayCountConventionOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, (Object)this.getFixedRateDayCountConventionOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, (Object)this.getFloatingRateDayCountConventionOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, (Object)this.getFloatingRateDayCountConventionOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg1"), String.class, (Object)this.getFloatingRateResetFrequencyPeriodOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierOfLeg1"), Integer.class, (Object)this.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg2"), String.class, (Object)this.getFloatingRateResetFrequencyPeriodOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierOfLeg2"), Integer.class, (Object)this.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodOfLeg1"), Frequency13Code__1.class, (Object)this.getFixedRatePaymentFrequencyPeriodOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1"), Integer.class, (Object)this.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodOfLeg2"), Frequency13Code__1.class, (Object)this.getFixedRatePaymentFrequencyPeriodOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2"), Integer.class, (Object)this.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg1"), Frequency13Code__1.class, (Object)this.getFloatingRatePaymentFrequencyPeriodOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1"), Integer.class, (Object)this.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg2"), Frequency13Code__1.class, (Object)this.getFloatingRatePaymentFrequencyPeriodOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2"), Integer.class, (Object)this.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.OtherPaymentReportBuilder.class, this.getOtherPayment(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), String.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventType"), String.class, (Object)this.getEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), ZonedDateTime.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonReportable"), processor, MASNonReportable.MASNonReportableBuilder.class, this.getNonReportable(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, (Object)this.getExecutionAgentOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfCounterparty2DTCC"), String.class, (Object)this.getExecutionAgentOfCounterparty2DTCC(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountScheduleLeg1DTCC"), processor, NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder.class, this.getNotionalAmountScheduleLeg1DTCC(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountScheduleLeg2DTCC"), processor, NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder.class, this.getNotionalAmountScheduleLeg2DTCC(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalQuantityScheduleLeg1DTCC"), processor, NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder.class, this.getNotionalQuantityScheduleLeg1DTCC(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalQuantityScheduleLeg2DTCC"), processor, NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder.class, this.getNotionalQuantityScheduleLeg2DTCC(), new AttributeMeta[0]);
        }

        public MASTransactionReportBuilder prune();
    }

    public static class MASTransactionReportImpl
    implements MASTransactionReport {
        private final String counterparty1;
        private final String counterparty2;
        private final Boolean counterparty2IdentifierType;
        private final TradingCapacity7Code tradingCapacityOfSpecifiedPerson;
        private final String direction;
        private final String directionOfLeg1;
        private final String directionOfLeg2;
        private final String reportingSpecifiedPerson;
        private final String dataSubmitter;
        private final String uniqueTransactionIdentifier;
        private final String uniqueTransactionIdentifierProprietary;
        private final String uniqueProductIdentifier;
        private final String priorUTI;
        private final String priorUTIProprietary;
        private final String contractType;
        private final String assetClass;
        private final String underlying;
        private final String underlyingIdentificationType;
        private final String underlyingIdOther;
        private final String underlyingIdOtherSource;
        private final String nameOfTheUnderlyingIndex;
        private final BigDecimal fixedRateOfLeg1;
        private final String identifierOfFloatingRateOfLeg1;
        private final String nameOfTheFloatingRateOfLeg1;
        private final SpreadOfLeg1 spreadOfLeg1;
        private final BigDecimal fixedRateOfLeg2;
        private final String identifierOfFloatingRateOfLeg2;
        private final String nameOfTheFloatingRateOfLeg2;
        private final SpreadOfLeg2 spreadOfLeg2;
        private final String optionType;
        private final String optionStyle;
        private final Date firstExerciseDate;
        private final Date effectiveDate;
        private final Date expirationDate;
        private final String swapLinkID;
        private final String packageIdentifier;
        private final String deliveryType;
        private final ISOCurrencyCodeEnum settlementCurrency1;
        private final ISOCurrencyCodeEnum settlementCurrency2;
        private final Date finalContractualSettlementDate;
        private final String cleared;
        private final String centralCounterparty;
        private final String clearingMember;
        private final ZonedDateTime clearingTimestamp;
        private final String platformIdentifier;
        private final String bookingLocation;
        private final String traderLocation;
        private final String confirmed;
        private final ZonedDateTime confirmationTimestamp;
        private final ZonedDateTime executionTimestamp;
        private final ZonedDateTime reportingTimestamp;
        private final List<? extends BasketConstituentsReport> basketConstituents;
        private final BigDecimal valuationAmount;
        private final ISOCurrencyCodeEnum valuationCurrency;
        private final ValuationType1Code valuationMethod;
        private final ZonedDateTime valuationTimestamp;
        private final Boolean collateralPortfolioIndicator;
        private final String initialMarginCollateralPortfolioCode;
        private final String variationMarginCollateralPortfolioCode;
        private final BigDecimal notionalAmountOfTheContractOrLeg1;
        private final ISOCurrencyCodeEnum notionalCurrencyOfTheContractOrLeg1;
        private final BigDecimal notionalAmountOfLeg2;
        private final ISOCurrencyCodeEnum notionalCurrencyOfLeg2;
        private final BigDecimal totalNotionalQuantityOfTheContractOrLeg1;
        private final String quantityUnitOfMeasureForTheContractOrLeg1;
        private final BigDecimal notionalQuantityOfTheContractOrLeg1;
        private final String quantityFrequencyOfTheContractOrLeg1;
        private final Integer quantityFrequencyMultiplierOfTheContractOrLeg1;
        private final BigDecimal totalNotionalQuantityLeg2;
        private final String quantityUnitOfMeasureLeg2;
        private final BigDecimal notionalQuantityOfLeg2;
        private final String quantityFrequencyOfLeg2;
        private final Integer quantityFrequencyMultiplierOfLeg2;
        private final BigDecimal callAmount;
        private final ISOCurrencyCodeEnum callCurrency;
        private final BigDecimal putAmount;
        private final ISOCurrencyCodeEnum putCurrency;
        private final PriceAndNotation price;
        private final String priceUnitOfMeasure;
        private final List<? extends PriceScheduleReport> priceSchedule;
        private final StrikePriceAndNotation strikePrice;
        private final List<? extends StrikePriceScheduleReport> strikePriceSchedule;
        private final BigDecimal optionPremiumAmount;
        private final ISOCurrencyCodeEnum optionPremiumCurrency;
        private final BigDecimal exchangeRate;
        private final String exchangeRateBasis;
        private final InterestComputationMethod4Code fixedRateDayCountConventionOfLeg1;
        private final InterestComputationMethod4Code fixedRateDayCountConventionOfLeg2;
        private final InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1;
        private final InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2;
        private final String floatingRateResetFrequencyPeriodOfLeg1;
        private final Integer floatingRateResetFrequencyPeriodMultiplierOfLeg1;
        private final String floatingRateResetFrequencyPeriodOfLeg2;
        private final Integer floatingRateResetFrequencyPeriodMultiplierOfLeg2;
        private final Frequency13Code__1 fixedRatePaymentFrequencyPeriodOfLeg1;
        private final Integer fixedRatePaymentFrequencyPeriodMultiplierOfLeg1;
        private final Frequency13Code__1 fixedRatePaymentFrequencyPeriodOfLeg2;
        private final Integer fixedRatePaymentFrequencyPeriodMultiplierOfLeg2;
        private final Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg1;
        private final Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
        private final Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg2;
        private final Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
        private final List<? extends OtherPaymentReport> otherPayment;
        private final String actionType;
        private final String eventType;
        private final ZonedDateTime eventDate;
        private final MASNonReportable nonReportable;
        private final String technicalRecordId;
        private final String counterparty2Name;
        private final String executionAgentOfCounterparty1;
        private final String executionAgentOfCounterparty2DTCC;
        private final List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1DTCC;
        private final List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2DTCC;
        private final List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1DTCC;
        private final List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2DTCC;

        protected MASTransactionReportImpl(MASTransactionReportBuilder builder) {
            this.counterparty1 = builder.getCounterparty1();
            this.counterparty2 = builder.getCounterparty2();
            this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
            this.tradingCapacityOfSpecifiedPerson = builder.getTradingCapacityOfSpecifiedPerson();
            this.direction = builder.getDirection();
            this.directionOfLeg1 = builder.getDirectionOfLeg1();
            this.directionOfLeg2 = builder.getDirectionOfLeg2();
            this.reportingSpecifiedPerson = builder.getReportingSpecifiedPerson();
            this.dataSubmitter = builder.getDataSubmitter();
            this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
            this.uniqueTransactionIdentifierProprietary = builder.getUniqueTransactionIdentifierProprietary();
            this.uniqueProductIdentifier = builder.getUniqueProductIdentifier();
            this.priorUTI = builder.getPriorUTI();
            this.priorUTIProprietary = builder.getPriorUTIProprietary();
            this.contractType = builder.getContractType();
            this.assetClass = builder.getAssetClass();
            this.underlying = builder.getUnderlying();
            this.underlyingIdentificationType = builder.getUnderlyingIdentificationType();
            this.underlyingIdOther = builder.getUnderlyingIdOther();
            this.underlyingIdOtherSource = builder.getUnderlyingIdOtherSource();
            this.nameOfTheUnderlyingIndex = builder.getNameOfTheUnderlyingIndex();
            this.fixedRateOfLeg1 = builder.getFixedRateOfLeg1();
            this.identifierOfFloatingRateOfLeg1 = builder.getIdentifierOfFloatingRateOfLeg1();
            this.nameOfTheFloatingRateOfLeg1 = builder.getNameOfTheFloatingRateOfLeg1();
            this.spreadOfLeg1 = Optional.ofNullable(builder.getSpreadOfLeg1()).map(f -> f.build()).orElse(null);
            this.fixedRateOfLeg2 = builder.getFixedRateOfLeg2();
            this.identifierOfFloatingRateOfLeg2 = builder.getIdentifierOfFloatingRateOfLeg2();
            this.nameOfTheFloatingRateOfLeg2 = builder.getNameOfTheFloatingRateOfLeg2();
            this.spreadOfLeg2 = Optional.ofNullable(builder.getSpreadOfLeg2()).map(f -> f.build()).orElse(null);
            this.optionType = builder.getOptionType();
            this.optionStyle = builder.getOptionStyle();
            this.firstExerciseDate = builder.getFirstExerciseDate();
            this.effectiveDate = builder.getEffectiveDate();
            this.expirationDate = builder.getExpirationDate();
            this.swapLinkID = builder.getSwapLinkID();
            this.packageIdentifier = builder.getPackageIdentifier();
            this.deliveryType = builder.getDeliveryType();
            this.settlementCurrency1 = builder.getSettlementCurrency1();
            this.settlementCurrency2 = builder.getSettlementCurrency2();
            this.finalContractualSettlementDate = builder.getFinalContractualSettlementDate();
            this.cleared = builder.getCleared();
            this.centralCounterparty = builder.getCentralCounterparty();
            this.clearingMember = builder.getClearingMember();
            this.clearingTimestamp = builder.getClearingTimestamp();
            this.platformIdentifier = builder.getPlatformIdentifier();
            this.bookingLocation = builder.getBookingLocation();
            this.traderLocation = builder.getTraderLocation();
            this.confirmed = builder.getConfirmed();
            this.confirmationTimestamp = builder.getConfirmationTimestamp();
            this.executionTimestamp = builder.getExecutionTimestamp();
            this.reportingTimestamp = builder.getReportingTimestamp();
            this.basketConstituents = Optional.ofNullable(builder.getBasketConstituents()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.valuationAmount = builder.getValuationAmount();
            this.valuationCurrency = builder.getValuationCurrency();
            this.valuationMethod = builder.getValuationMethod();
            this.valuationTimestamp = builder.getValuationTimestamp();
            this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
            this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
            this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
            this.notionalAmountOfTheContractOrLeg1 = builder.getNotionalAmountOfTheContractOrLeg1();
            this.notionalCurrencyOfTheContractOrLeg1 = builder.getNotionalCurrencyOfTheContractOrLeg1();
            this.notionalAmountOfLeg2 = builder.getNotionalAmountOfLeg2();
            this.notionalCurrencyOfLeg2 = builder.getNotionalCurrencyOfLeg2();
            this.totalNotionalQuantityOfTheContractOrLeg1 = builder.getTotalNotionalQuantityOfTheContractOrLeg1();
            this.quantityUnitOfMeasureForTheContractOrLeg1 = builder.getQuantityUnitOfMeasureForTheContractOrLeg1();
            this.notionalQuantityOfTheContractOrLeg1 = builder.getNotionalQuantityOfTheContractOrLeg1();
            this.quantityFrequencyOfTheContractOrLeg1 = builder.getQuantityFrequencyOfTheContractOrLeg1();
            this.quantityFrequencyMultiplierOfTheContractOrLeg1 = builder.getQuantityFrequencyMultiplierOfTheContractOrLeg1();
            this.totalNotionalQuantityLeg2 = builder.getTotalNotionalQuantityLeg2();
            this.quantityUnitOfMeasureLeg2 = builder.getQuantityUnitOfMeasureLeg2();
            this.notionalQuantityOfLeg2 = builder.getNotionalQuantityOfLeg2();
            this.quantityFrequencyOfLeg2 = builder.getQuantityFrequencyOfLeg2();
            this.quantityFrequencyMultiplierOfLeg2 = builder.getQuantityFrequencyMultiplierOfLeg2();
            this.callAmount = builder.getCallAmount();
            this.callCurrency = builder.getCallCurrency();
            this.putAmount = builder.getPutAmount();
            this.putCurrency = builder.getPutCurrency();
            this.price = Optional.ofNullable(builder.getPrice()).map(f -> f.build()).orElse(null);
            this.priceUnitOfMeasure = builder.getPriceUnitOfMeasure();
            this.priceSchedule = Optional.ofNullable(builder.getPriceSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.strikePrice = Optional.ofNullable(builder.getStrikePrice()).map(f -> f.build()).orElse(null);
            this.strikePriceSchedule = Optional.ofNullable(builder.getStrikePriceSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.optionPremiumAmount = builder.getOptionPremiumAmount();
            this.optionPremiumCurrency = builder.getOptionPremiumCurrency();
            this.exchangeRate = builder.getExchangeRate();
            this.exchangeRateBasis = builder.getExchangeRateBasis();
            this.fixedRateDayCountConventionOfLeg1 = builder.getFixedRateDayCountConventionOfLeg1();
            this.fixedRateDayCountConventionOfLeg2 = builder.getFixedRateDayCountConventionOfLeg2();
            this.floatingRateDayCountConventionOfLeg1 = builder.getFloatingRateDayCountConventionOfLeg1();
            this.floatingRateDayCountConventionOfLeg2 = builder.getFloatingRateDayCountConventionOfLeg2();
            this.floatingRateResetFrequencyPeriodOfLeg1 = builder.getFloatingRateResetFrequencyPeriodOfLeg1();
            this.floatingRateResetFrequencyPeriodMultiplierOfLeg1 = builder.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1();
            this.floatingRateResetFrequencyPeriodOfLeg2 = builder.getFloatingRateResetFrequencyPeriodOfLeg2();
            this.floatingRateResetFrequencyPeriodMultiplierOfLeg2 = builder.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2();
            this.fixedRatePaymentFrequencyPeriodOfLeg1 = builder.getFixedRatePaymentFrequencyPeriodOfLeg1();
            this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 = builder.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1();
            this.fixedRatePaymentFrequencyPeriodOfLeg2 = builder.getFixedRatePaymentFrequencyPeriodOfLeg2();
            this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 = builder.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2();
            this.floatingRatePaymentFrequencyPeriodOfLeg1 = builder.getFloatingRatePaymentFrequencyPeriodOfLeg1();
            this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1();
            this.floatingRatePaymentFrequencyPeriodOfLeg2 = builder.getFloatingRatePaymentFrequencyPeriodOfLeg2();
            this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2();
            this.otherPayment = Optional.ofNullable(builder.getOtherPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.actionType = builder.getActionType();
            this.eventType = builder.getEventType();
            this.eventDate = builder.getEventDate();
            this.nonReportable = Optional.ofNullable(builder.getNonReportable()).map(f -> f.build()).orElse(null);
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.counterparty2Name = builder.getCounterparty2Name();
            this.executionAgentOfCounterparty1 = builder.getExecutionAgentOfCounterparty1();
            this.executionAgentOfCounterparty2DTCC = builder.getExecutionAgentOfCounterparty2DTCC();
            this.notionalAmountScheduleLeg1DTCC = Optional.ofNullable(builder.getNotionalAmountScheduleLeg1DTCC()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.notionalAmountScheduleLeg2DTCC = Optional.ofNullable(builder.getNotionalAmountScheduleLeg2DTCC()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.notionalQuantityScheduleLeg1DTCC = Optional.ofNullable(builder.getNotionalQuantityScheduleLeg1DTCC()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.notionalQuantityScheduleLeg2DTCC = Optional.ofNullable(builder.getNotionalQuantityScheduleLeg2DTCC()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="tradingCapacityOfSpecifiedPerson")
        @RuneAttribute(value="tradingCapacityOfSpecifiedPerson")
        public TradingCapacity7Code getTradingCapacityOfSpecifiedPerson() {
            return this.tradingCapacityOfSpecifiedPerson;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public String getDirection() {
            return this.direction;
        }

        @Override
        @RosettaAttribute(value="directionOfLeg1")
        @RuneAttribute(value="directionOfLeg1")
        public String getDirectionOfLeg1() {
            return this.directionOfLeg1;
        }

        @Override
        @RosettaAttribute(value="directionOfLeg2")
        @RuneAttribute(value="directionOfLeg2")
        public String getDirectionOfLeg2() {
            return this.directionOfLeg2;
        }

        @Override
        @RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
        @RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
        public String getReportingSpecifiedPerson() {
            return this.reportingSpecifiedPerson;
        }

        @Override
        @RosettaAttribute(value="dataSubmitter", isRequired=true)
        @RuneAttribute(value="dataSubmitter", isRequired=true)
        public String getDataSubmitter() {
            return this.dataSubmitter;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public String getUniqueProductIdentifier() {
            return this.uniqueProductIdentifier;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public String getPriorUTI() {
            return this.priorUTI;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietary")
        @RuneAttribute(value="priorUTIProprietary")
        public String getPriorUTIProprietary() {
            return this.priorUTIProprietary;
        }

        @Override
        @RosettaAttribute(value="contractType")
        @RuneAttribute(value="contractType")
        public String getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public String getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="underlying")
        @RuneAttribute(value="underlying")
        public String getUnderlying() {
            return this.underlying;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public String getUnderlyingIdentificationType() {
            return this.underlyingIdentificationType;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public String getUnderlyingIdOther() {
            return this.underlyingIdOther;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public String getUnderlyingIdOtherSource() {
            return this.underlyingIdOtherSource;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public String getNameOfTheUnderlyingIndex() {
            return this.nameOfTheUnderlyingIndex;
        }

        @Override
        @RosettaAttribute(value="fixedRateOfLeg1")
        @RuneAttribute(value="fixedRateOfLeg1")
        public BigDecimal getFixedRateOfLeg1() {
            return this.fixedRateOfLeg1;
        }

        @Override
        @RosettaAttribute(value="identifierOfFloatingRateOfLeg1")
        @RuneAttribute(value="identifierOfFloatingRateOfLeg1")
        public String getIdentifierOfFloatingRateOfLeg1() {
            return this.identifierOfFloatingRateOfLeg1;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRateOfLeg1")
        @RuneAttribute(value="nameOfTheFloatingRateOfLeg1")
        public String getNameOfTheFloatingRateOfLeg1() {
            return this.nameOfTheFloatingRateOfLeg1;
        }

        @Override
        @RosettaAttribute(value="spreadOfLeg1")
        @RuneAttribute(value="spreadOfLeg1")
        public SpreadOfLeg1 getSpreadOfLeg1() {
            return this.spreadOfLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRateOfLeg2")
        @RuneAttribute(value="fixedRateOfLeg2")
        public BigDecimal getFixedRateOfLeg2() {
            return this.fixedRateOfLeg2;
        }

        @Override
        @RosettaAttribute(value="identifierOfFloatingRateOfLeg2")
        @RuneAttribute(value="identifierOfFloatingRateOfLeg2")
        public String getIdentifierOfFloatingRateOfLeg2() {
            return this.identifierOfFloatingRateOfLeg2;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRateOfLeg2")
        @RuneAttribute(value="nameOfTheFloatingRateOfLeg2")
        public String getNameOfTheFloatingRateOfLeg2() {
            return this.nameOfTheFloatingRateOfLeg2;
        }

        @Override
        @RosettaAttribute(value="spreadOfLeg2")
        @RuneAttribute(value="spreadOfLeg2")
        public SpreadOfLeg2 getSpreadOfLeg2() {
            return this.spreadOfLeg2;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public String getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public String getOptionStyle() {
            return this.optionStyle;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public Date getFirstExerciseDate() {
            return this.firstExerciseDate;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="swapLinkID")
        @RuneAttribute(value="swapLinkID")
        public String getSwapLinkID() {
            return this.swapLinkID;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public String getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency1")
        @RuneAttribute(value="settlementCurrency1")
        public ISOCurrencyCodeEnum getSettlementCurrency1() {
            return this.settlementCurrency1;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency2")
        @RuneAttribute(value="settlementCurrency2")
        public ISOCurrencyCodeEnum getSettlementCurrency2() {
            return this.settlementCurrency2;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public Date getFinalContractualSettlementDate() {
            return this.finalContractualSettlementDate;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public String getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public String getCentralCounterparty() {
            return this.centralCounterparty;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public String getClearingMember() {
            return this.clearingMember;
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public ZonedDateTime getClearingTimestamp() {
            return this.clearingTimestamp;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public String getPlatformIdentifier() {
            return this.platformIdentifier;
        }

        @Override
        @RosettaAttribute(value="bookingLocation")
        @RuneAttribute(value="bookingLocation")
        public String getBookingLocation() {
            return this.bookingLocation;
        }

        @Override
        @RosettaAttribute(value="traderLocation")
        @RuneAttribute(value="traderLocation")
        public String getTraderLocation() {
            return this.traderLocation;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public String getConfirmed() {
            return this.confirmed;
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public ZonedDateTime getConfirmationTimestamp() {
            return this.confirmationTimestamp;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public List<? extends BasketConstituentsReport> getBasketConstituents() {
            return this.basketConstituents;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="notionalAmountOfTheContractOrLeg1")
        @RuneAttribute(value="notionalAmountOfTheContractOrLeg1")
        public BigDecimal getNotionalAmountOfTheContractOrLeg1() {
            return this.notionalAmountOfTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyOfTheContractOrLeg1")
        @RuneAttribute(value="notionalCurrencyOfTheContractOrLeg1")
        public ISOCurrencyCodeEnum getNotionalCurrencyOfTheContractOrLeg1() {
            return this.notionalCurrencyOfTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalAmountOfLeg2")
        @RuneAttribute(value="notionalAmountOfLeg2")
        public BigDecimal getNotionalAmountOfLeg2() {
            return this.notionalAmountOfLeg2;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyOfLeg2")
        @RuneAttribute(value="notionalCurrencyOfLeg2")
        public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg2() {
            return this.notionalCurrencyOfLeg2;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityOfTheContractOrLeg1")
        @RuneAttribute(value="totalNotionalQuantityOfTheContractOrLeg1")
        public BigDecimal getTotalNotionalQuantityOfTheContractOrLeg1() {
            return this.totalNotionalQuantityOfTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureForTheContractOrLeg1")
        @RuneAttribute(value="quantityUnitOfMeasureForTheContractOrLeg1")
        public String getQuantityUnitOfMeasureForTheContractOrLeg1() {
            return this.quantityUnitOfMeasureForTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityOfTheContractOrLeg1")
        @RuneAttribute(value="notionalQuantityOfTheContractOrLeg1")
        public BigDecimal getNotionalQuantityOfTheContractOrLeg1() {
            return this.notionalQuantityOfTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyOfTheContractOrLeg1")
        @RuneAttribute(value="quantityFrequencyOfTheContractOrLeg1")
        public String getQuantityFrequencyOfTheContractOrLeg1() {
            return this.quantityFrequencyOfTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyMultiplierOfTheContractOrLeg1")
        @RuneAttribute(value="quantityFrequencyMultiplierOfTheContractOrLeg1")
        public Integer getQuantityFrequencyMultiplierOfTheContractOrLeg1() {
            return this.quantityFrequencyMultiplierOfTheContractOrLeg1;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg2")
        @RuneAttribute(value="totalNotionalQuantityLeg2")
        public BigDecimal getTotalNotionalQuantityLeg2() {
            return this.totalNotionalQuantityLeg2;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg2")
        @RuneAttribute(value="quantityUnitOfMeasureLeg2")
        public String getQuantityUnitOfMeasureLeg2() {
            return this.quantityUnitOfMeasureLeg2;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityOfLeg2")
        @RuneAttribute(value="notionalQuantityOfLeg2")
        public BigDecimal getNotionalQuantityOfLeg2() {
            return this.notionalQuantityOfLeg2;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyOfLeg2")
        @RuneAttribute(value="quantityFrequencyOfLeg2")
        public String getQuantityFrequencyOfLeg2() {
            return this.quantityFrequencyOfLeg2;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyMultiplierOfLeg2")
        @RuneAttribute(value="quantityFrequencyMultiplierOfLeg2")
        public Integer getQuantityFrequencyMultiplierOfLeg2() {
            return this.quantityFrequencyMultiplierOfLeg2;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public BigDecimal getCallAmount() {
            return this.callAmount;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public ISOCurrencyCodeEnum getCallCurrency() {
            return this.callCurrency;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public BigDecimal getPutAmount() {
            return this.putAmount;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public ISOCurrencyCodeEnum getPutCurrency() {
            return this.putCurrency;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public PriceAndNotation getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public String getPriceUnitOfMeasure() {
            return this.priceUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public List<? extends PriceScheduleReport> getPriceSchedule() {
            return this.priceSchedule;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public StrikePriceAndNotation getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public List<? extends StrikePriceScheduleReport> getStrikePriceSchedule() {
            return this.strikePriceSchedule;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public BigDecimal getOptionPremiumAmount() {
            return this.optionPremiumAmount;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
            return this.optionPremiumCurrency;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public BigDecimal getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public String getExchangeRateBasis() {
            return this.exchangeRateBasis;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConventionOfLeg1")
        @RuneAttribute(value="fixedRateDayCountConventionOfLeg1")
        public InterestComputationMethod4Code getFixedRateDayCountConventionOfLeg1() {
            return this.fixedRateDayCountConventionOfLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConventionOfLeg2")
        @RuneAttribute(value="fixedRateDayCountConventionOfLeg2")
        public InterestComputationMethod4Code getFixedRateDayCountConventionOfLeg2() {
            return this.fixedRateDayCountConventionOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConventionOfLeg1")
        @RuneAttribute(value="floatingRateDayCountConventionOfLeg1")
        public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1() {
            return this.floatingRateDayCountConventionOfLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConventionOfLeg2")
        @RuneAttribute(value="floatingRateDayCountConventionOfLeg2")
        public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2() {
            return this.floatingRateDayCountConventionOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodOfLeg1")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodOfLeg1")
        public String getFloatingRateResetFrequencyPeriodOfLeg1() {
            return this.floatingRateResetFrequencyPeriodOfLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodMultiplierOfLeg1")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodMultiplierOfLeg1")
        public Integer getFloatingRateResetFrequencyPeriodMultiplierOfLeg1() {
            return this.floatingRateResetFrequencyPeriodMultiplierOfLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodOfLeg2")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodOfLeg2")
        public String getFloatingRateResetFrequencyPeriodOfLeg2() {
            return this.floatingRateResetFrequencyPeriodOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodMultiplierOfLeg2")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodMultiplierOfLeg2")
        public Integer getFloatingRateResetFrequencyPeriodMultiplierOfLeg2() {
            return this.floatingRateResetFrequencyPeriodMultiplierOfLeg2;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodOfLeg1")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodOfLeg1")
        public Frequency13Code__1 getFixedRatePaymentFrequencyPeriodOfLeg1() {
            return this.fixedRatePaymentFrequencyPeriodOfLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierOfLeg1")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierOfLeg1")
        public Integer getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1() {
            return this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodOfLeg2")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodOfLeg2")
        public Frequency13Code__1 getFixedRatePaymentFrequencyPeriodOfLeg2() {
            return this.fixedRatePaymentFrequencyPeriodOfLeg2;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierOfLeg2")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierOfLeg2")
        public Integer getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2() {
            return this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodOfLeg1")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodOfLeg1")
        public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg1() {
            return this.floatingRatePaymentFrequencyPeriodOfLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
        public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1() {
            return this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodOfLeg2")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodOfLeg2")
        public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg2() {
            return this.floatingRatePaymentFrequencyPeriodOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
        public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2() {
            return this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public List<? extends OtherPaymentReport> getOtherPayment() {
            return this.otherPayment;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public String getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public String getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public ZonedDateTime getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public MASNonReportable getNonReportable() {
            return this.nonReportable;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public String getCounterparty2Name() {
            return this.counterparty2Name;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty1")
        @RuneAttribute(value="executionAgentOfCounterparty1")
        public String getExecutionAgentOfCounterparty1() {
            return this.executionAgentOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty2DTCC")
        @RuneAttribute(value="executionAgentOfCounterparty2DTCC")
        public String getExecutionAgentOfCounterparty2DTCC() {
            return this.executionAgentOfCounterparty2DTCC;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg1DTCC")
        @RuneAttribute(value="notionalAmountScheduleLeg1DTCC")
        public List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1DTCC() {
            return this.notionalAmountScheduleLeg1DTCC;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg2DTCC")
        @RuneAttribute(value="notionalAmountScheduleLeg2DTCC")
        public List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2DTCC() {
            return this.notionalAmountScheduleLeg2DTCC;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityScheduleLeg1DTCC")
        @RuneAttribute(value="notionalQuantityScheduleLeg1DTCC")
        public List<? extends NotionalQuantityScheduleLeg1Report> getNotionalQuantityScheduleLeg1DTCC() {
            return this.notionalQuantityScheduleLeg1DTCC;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityScheduleLeg2DTCC")
        @RuneAttribute(value="notionalQuantityScheduleLeg2DTCC")
        public List<? extends NotionalQuantityScheduleLeg2Report> getNotionalQuantityScheduleLeg2DTCC() {
            return this.notionalQuantityScheduleLeg2DTCC;
        }

        @Override
        public MASTransactionReport build() {
            return this;
        }

        @Override
        public MASTransactionReportBuilder toBuilder() {
            MASTransactionReportBuilder builder = MASTransactionReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MASTransactionReportBuilder builder) {
            Optional.ofNullable(this.getCounterparty1()).ifPresent(builder::setCounterparty1);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2);
            Optional.ofNullable(this.getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierType);
            Optional.ofNullable(this.getTradingCapacityOfSpecifiedPerson()).ifPresent(builder::setTradingCapacityOfSpecifiedPerson);
            Optional.ofNullable(this.getDirection()).ifPresent(builder::setDirection);
            Optional.ofNullable(this.getDirectionOfLeg1()).ifPresent(builder::setDirectionOfLeg1);
            Optional.ofNullable(this.getDirectionOfLeg2()).ifPresent(builder::setDirectionOfLeg2);
            Optional.ofNullable(this.getReportingSpecifiedPerson()).ifPresent(builder::setReportingSpecifiedPerson);
            Optional.ofNullable(this.getDataSubmitter()).ifPresent(builder::setDataSubmitter);
            Optional.ofNullable(this.getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
            Optional.ofNullable(this.getUniqueTransactionIdentifierProprietary()).ifPresent(builder::setUniqueTransactionIdentifierProprietary);
            Optional.ofNullable(this.getUniqueProductIdentifier()).ifPresent(builder::setUniqueProductIdentifier);
            Optional.ofNullable(this.getPriorUTI()).ifPresent(builder::setPriorUTI);
            Optional.ofNullable(this.getPriorUTIProprietary()).ifPresent(builder::setPriorUTIProprietary);
            Optional.ofNullable(this.getContractType()).ifPresent(builder::setContractType);
            Optional.ofNullable(this.getAssetClass()).ifPresent(builder::setAssetClass);
            Optional.ofNullable(this.getUnderlying()).ifPresent(builder::setUnderlying);
            Optional.ofNullable(this.getUnderlyingIdentificationType()).ifPresent(builder::setUnderlyingIdentificationType);
            Optional.ofNullable(this.getUnderlyingIdOther()).ifPresent(builder::setUnderlyingIdOther);
            Optional.ofNullable(this.getUnderlyingIdOtherSource()).ifPresent(builder::setUnderlyingIdOtherSource);
            Optional.ofNullable(this.getNameOfTheUnderlyingIndex()).ifPresent(builder::setNameOfTheUnderlyingIndex);
            Optional.ofNullable(this.getFixedRateOfLeg1()).ifPresent(builder::setFixedRateOfLeg1);
            Optional.ofNullable(this.getIdentifierOfFloatingRateOfLeg1()).ifPresent(builder::setIdentifierOfFloatingRateOfLeg1);
            Optional.ofNullable(this.getNameOfTheFloatingRateOfLeg1()).ifPresent(builder::setNameOfTheFloatingRateOfLeg1);
            Optional.ofNullable(this.getSpreadOfLeg1()).ifPresent(builder::setSpreadOfLeg1);
            Optional.ofNullable(this.getFixedRateOfLeg2()).ifPresent(builder::setFixedRateOfLeg2);
            Optional.ofNullable(this.getIdentifierOfFloatingRateOfLeg2()).ifPresent(builder::setIdentifierOfFloatingRateOfLeg2);
            Optional.ofNullable(this.getNameOfTheFloatingRateOfLeg2()).ifPresent(builder::setNameOfTheFloatingRateOfLeg2);
            Optional.ofNullable(this.getSpreadOfLeg2()).ifPresent(builder::setSpreadOfLeg2);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getOptionStyle()).ifPresent(builder::setOptionStyle);
            Optional.ofNullable(this.getFirstExerciseDate()).ifPresent(builder::setFirstExerciseDate);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
            Optional.ofNullable(this.getSwapLinkID()).ifPresent(builder::setSwapLinkID);
            Optional.ofNullable(this.getPackageIdentifier()).ifPresent(builder::setPackageIdentifier);
            Optional.ofNullable(this.getDeliveryType()).ifPresent(builder::setDeliveryType);
            Optional.ofNullable(this.getSettlementCurrency1()).ifPresent(builder::setSettlementCurrency1);
            Optional.ofNullable(this.getSettlementCurrency2()).ifPresent(builder::setSettlementCurrency2);
            Optional.ofNullable(this.getFinalContractualSettlementDate()).ifPresent(builder::setFinalContractualSettlementDate);
            Optional.ofNullable(this.getCleared()).ifPresent(builder::setCleared);
            Optional.ofNullable(this.getCentralCounterparty()).ifPresent(builder::setCentralCounterparty);
            Optional.ofNullable(this.getClearingMember()).ifPresent(builder::setClearingMember);
            Optional.ofNullable(this.getClearingTimestamp()).ifPresent(builder::setClearingTimestamp);
            Optional.ofNullable(this.getPlatformIdentifier()).ifPresent(builder::setPlatformIdentifier);
            Optional.ofNullable(this.getBookingLocation()).ifPresent(builder::setBookingLocation);
            Optional.ofNullable(this.getTraderLocation()).ifPresent(builder::setTraderLocation);
            Optional.ofNullable(this.getConfirmed()).ifPresent(builder::setConfirmed);
            Optional.ofNullable(this.getConfirmationTimestamp()).ifPresent(builder::setConfirmationTimestamp);
            Optional.ofNullable(this.getExecutionTimestamp()).ifPresent(builder::setExecutionTimestamp);
            Optional.ofNullable(this.getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
            Optional.ofNullable(this.getBasketConstituents()).ifPresent(builder::setBasketConstituents);
            Optional.ofNullable(this.getValuationAmount()).ifPresent(builder::setValuationAmount);
            Optional.ofNullable(this.getValuationCurrency()).ifPresent(builder::setValuationCurrency);
            Optional.ofNullable(this.getValuationMethod()).ifPresent(builder::setValuationMethod);
            Optional.ofNullable(this.getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
            Optional.ofNullable(this.getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
            Optional.ofNullable(this.getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getNotionalAmountOfTheContractOrLeg1()).ifPresent(builder::setNotionalAmountOfTheContractOrLeg1);
            Optional.ofNullable(this.getNotionalCurrencyOfTheContractOrLeg1()).ifPresent(builder::setNotionalCurrencyOfTheContractOrLeg1);
            Optional.ofNullable(this.getNotionalAmountOfLeg2()).ifPresent(builder::setNotionalAmountOfLeg2);
            Optional.ofNullable(this.getNotionalCurrencyOfLeg2()).ifPresent(builder::setNotionalCurrencyOfLeg2);
            Optional.ofNullable(this.getTotalNotionalQuantityOfTheContractOrLeg1()).ifPresent(builder::setTotalNotionalQuantityOfTheContractOrLeg1);
            Optional.ofNullable(this.getQuantityUnitOfMeasureForTheContractOrLeg1()).ifPresent(builder::setQuantityUnitOfMeasureForTheContractOrLeg1);
            Optional.ofNullable(this.getNotionalQuantityOfTheContractOrLeg1()).ifPresent(builder::setNotionalQuantityOfTheContractOrLeg1);
            Optional.ofNullable(this.getQuantityFrequencyOfTheContractOrLeg1()).ifPresent(builder::setQuantityFrequencyOfTheContractOrLeg1);
            Optional.ofNullable(this.getQuantityFrequencyMultiplierOfTheContractOrLeg1()).ifPresent(builder::setQuantityFrequencyMultiplierOfTheContractOrLeg1);
            Optional.ofNullable(this.getTotalNotionalQuantityLeg2()).ifPresent(builder::setTotalNotionalQuantityLeg2);
            Optional.ofNullable(this.getQuantityUnitOfMeasureLeg2()).ifPresent(builder::setQuantityUnitOfMeasureLeg2);
            Optional.ofNullable(this.getNotionalQuantityOfLeg2()).ifPresent(builder::setNotionalQuantityOfLeg2);
            Optional.ofNullable(this.getQuantityFrequencyOfLeg2()).ifPresent(builder::setQuantityFrequencyOfLeg2);
            Optional.ofNullable(this.getQuantityFrequencyMultiplierOfLeg2()).ifPresent(builder::setQuantityFrequencyMultiplierOfLeg2);
            Optional.ofNullable(this.getCallAmount()).ifPresent(builder::setCallAmount);
            Optional.ofNullable(this.getCallCurrency()).ifPresent(builder::setCallCurrency);
            Optional.ofNullable(this.getPutAmount()).ifPresent(builder::setPutAmount);
            Optional.ofNullable(this.getPutCurrency()).ifPresent(builder::setPutCurrency);
            Optional.ofNullable(this.getPrice()).ifPresent(builder::setPrice);
            Optional.ofNullable(this.getPriceUnitOfMeasure()).ifPresent(builder::setPriceUnitOfMeasure);
            Optional.ofNullable(this.getPriceSchedule()).ifPresent(builder::setPriceSchedule);
            Optional.ofNullable(this.getStrikePrice()).ifPresent(builder::setStrikePrice);
            Optional.ofNullable(this.getStrikePriceSchedule()).ifPresent(builder::setStrikePriceSchedule);
            Optional.ofNullable(this.getOptionPremiumAmount()).ifPresent(builder::setOptionPremiumAmount);
            Optional.ofNullable(this.getOptionPremiumCurrency()).ifPresent(builder::setOptionPremiumCurrency);
            Optional.ofNullable(this.getExchangeRate()).ifPresent(builder::setExchangeRate);
            Optional.ofNullable(this.getExchangeRateBasis()).ifPresent(builder::setExchangeRateBasis);
            Optional.ofNullable(this.getFixedRateDayCountConventionOfLeg1()).ifPresent(builder::setFixedRateDayCountConventionOfLeg1);
            Optional.ofNullable(this.getFixedRateDayCountConventionOfLeg2()).ifPresent(builder::setFixedRateDayCountConventionOfLeg2);
            Optional.ofNullable(this.getFloatingRateDayCountConventionOfLeg1()).ifPresent(builder::setFloatingRateDayCountConventionOfLeg1);
            Optional.ofNullable(this.getFloatingRateDayCountConventionOfLeg2()).ifPresent(builder::setFloatingRateDayCountConventionOfLeg2);
            Optional.ofNullable(this.getFloatingRateResetFrequencyPeriodOfLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodOfLeg1);
            Optional.ofNullable(this.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierOfLeg1);
            Optional.ofNullable(this.getFloatingRateResetFrequencyPeriodOfLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodOfLeg2);
            Optional.ofNullable(this.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierOfLeg2);
            Optional.ofNullable(this.getFixedRatePaymentFrequencyPeriodOfLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodOfLeg1);
            Optional.ofNullable(this.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierOfLeg1);
            Optional.ofNullable(this.getFixedRatePaymentFrequencyPeriodOfLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodOfLeg2);
            Optional.ofNullable(this.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierOfLeg2);
            Optional.ofNullable(this.getFloatingRatePaymentFrequencyPeriodOfLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodOfLeg1);
            Optional.ofNullable(this.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1);
            Optional.ofNullable(this.getFloatingRatePaymentFrequencyPeriodOfLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodOfLeg2);
            Optional.ofNullable(this.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2);
            Optional.ofNullable(this.getOtherPayment()).ifPresent(builder::setOtherPayment);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getEventType()).ifPresent(builder::setEventType);
            Optional.ofNullable(this.getEventDate()).ifPresent(builder::setEventDate);
            Optional.ofNullable(this.getNonReportable()).ifPresent(builder::setNonReportable);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
            Optional.ofNullable(this.getCounterparty2Name()).ifPresent(builder::setCounterparty2Name);
            Optional.ofNullable(this.getExecutionAgentOfCounterparty1()).ifPresent(builder::setExecutionAgentOfCounterparty1);
            Optional.ofNullable(this.getExecutionAgentOfCounterparty2DTCC()).ifPresent(builder::setExecutionAgentOfCounterparty2DTCC);
            Optional.ofNullable(this.getNotionalAmountScheduleLeg1DTCC()).ifPresent(builder::setNotionalAmountScheduleLeg1DTCC);
            Optional.ofNullable(this.getNotionalAmountScheduleLeg2DTCC()).ifPresent(builder::setNotionalAmountScheduleLeg2DTCC);
            Optional.ofNullable(this.getNotionalQuantityScheduleLeg1DTCC()).ifPresent(builder::setNotionalQuantityScheduleLeg1DTCC);
            Optional.ofNullable(this.getNotionalQuantityScheduleLeg2DTCC()).ifPresent(builder::setNotionalQuantityScheduleLeg2DTCC);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MASTransactionReport _that = this.getType().cast(o);
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.tradingCapacityOfSpecifiedPerson, _that.getTradingCapacityOfSpecifiedPerson())) {
                return false;
            }
            if (!Objects.equals(this.direction, _that.getDirection())) {
                return false;
            }
            if (!Objects.equals(this.directionOfLeg1, _that.getDirectionOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.directionOfLeg2, _that.getDirectionOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.reportingSpecifiedPerson, _that.getReportingSpecifiedPerson())) {
                return false;
            }
            if (!Objects.equals(this.dataSubmitter, _that.getDataSubmitter())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.uniqueProductIdentifier, _that.getUniqueProductIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.priorUTI, _that.getPriorUTI())) {
                return false;
            }
            if (!Objects.equals(this.priorUTIProprietary, _that.getPriorUTIProprietary())) {
                return false;
            }
            if (!Objects.equals(this.contractType, _that.getContractType())) {
                return false;
            }
            if (!Objects.equals(this.assetClass, _that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.underlying, _that.getUnderlying())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdentificationType, _that.getUnderlyingIdentificationType())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOther, _that.getUnderlyingIdOther())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateOfLeg1, _that.getFixedRateOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.identifierOfFloatingRateOfLeg1, _that.getIdentifierOfFloatingRateOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheFloatingRateOfLeg1, _that.getNameOfTheFloatingRateOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.spreadOfLeg1, _that.getSpreadOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateOfLeg2, _that.getFixedRateOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.identifierOfFloatingRateOfLeg2, _that.getIdentifierOfFloatingRateOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheFloatingRateOfLeg2, _that.getNameOfTheFloatingRateOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.spreadOfLeg2, _that.getSpreadOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.optionType, _that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.optionStyle, _that.getOptionStyle())) {
                return false;
            }
            if (!Objects.equals(this.firstExerciseDate, _that.getFirstExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.swapLinkID, _that.getSwapLinkID())) {
                return false;
            }
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.deliveryType, _that.getDeliveryType())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency1, _that.getSettlementCurrency1())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency2, _that.getSettlementCurrency2())) {
                return false;
            }
            if (!Objects.equals(this.finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.cleared, _that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.centralCounterparty, _that.getCentralCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.clearingMember, _that.getClearingMember())) {
                return false;
            }
            if (!Objects.equals(this.clearingTimestamp, _that.getClearingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.platformIdentifier, _that.getPlatformIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.bookingLocation, _that.getBookingLocation())) {
                return false;
            }
            if (!Objects.equals(this.traderLocation, _that.getTraderLocation())) {
                return false;
            }
            if (!Objects.equals(this.confirmed, _that.getConfirmed())) {
                return false;
            }
            if (!Objects.equals(this.confirmationTimestamp, _that.getConfirmationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituents, _that.getBasketConstituents())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.valuationMethod, _that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmountOfTheContractOrLeg1, _that.getNotionalAmountOfTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrencyOfTheContractOrLeg1, _that.getNotionalCurrencyOfTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmountOfLeg2, _that.getNotionalAmountOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrencyOfLeg2, _that.getNotionalCurrencyOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantityOfTheContractOrLeg1, _that.getTotalNotionalQuantityOfTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasureForTheContractOrLeg1, _that.getQuantityUnitOfMeasureForTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalQuantityOfTheContractOrLeg1, _that.getNotionalQuantityOfTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.quantityFrequencyOfTheContractOrLeg1, _that.getQuantityFrequencyOfTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.quantityFrequencyMultiplierOfTheContractOrLeg1, _that.getQuantityFrequencyMultiplierOfTheContractOrLeg1())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) {
                return false;
            }
            if (!Objects.equals(this.notionalQuantityOfLeg2, _that.getNotionalQuantityOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.quantityFrequencyOfLeg2, _that.getQuantityFrequencyOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.quantityFrequencyMultiplierOfLeg2, _that.getQuantityFrequencyMultiplierOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.callAmount, _that.getCallAmount())) {
                return false;
            }
            if (!Objects.equals(this.callCurrency, _that.getCallCurrency())) {
                return false;
            }
            if (!Objects.equals(this.putAmount, _that.getPutAmount())) {
                return false;
            }
            if (!Objects.equals(this.putCurrency, _that.getPutCurrency())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals(this.priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) {
                return false;
            }
            if (!ListEquals.listEquals(this.priceSchedule, _that.getPriceSchedule())) {
                return false;
            }
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePriceSchedule, _that.getStrikePriceSchedule())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumAmount, _that.getOptionPremiumAmount())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumCurrency, _that.getOptionPremiumCurrency())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRateBasis, _that.getExchangeRateBasis())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateDayCountConventionOfLeg1, _that.getFixedRateDayCountConventionOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateDayCountConventionOfLeg2, _that.getFixedRateDayCountConventionOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateDayCountConventionOfLeg1, _that.getFloatingRateDayCountConventionOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateDayCountConventionOfLeg2, _that.getFloatingRateDayCountConventionOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodOfLeg1, _that.getFloatingRateResetFrequencyPeriodOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodMultiplierOfLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodOfLeg2, _that.getFloatingRateResetFrequencyPeriodOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodMultiplierOfLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodOfLeg1, _that.getFixedRatePaymentFrequencyPeriodOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodOfLeg2, _that.getFixedRatePaymentFrequencyPeriodOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPayment, _that.getOtherPayment())) {
                return false;
            }
            if (!Objects.equals(this.actionType, _that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventType, _that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals(this.nonReportable, _that.getNonReportable())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2Name, _that.getCounterparty2Name())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfCounterparty2DTCC, _that.getExecutionAgentOfCounterparty2DTCC())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountScheduleLeg1DTCC, _that.getNotionalAmountScheduleLeg1DTCC())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountScheduleLeg2DTCC, _that.getNotionalAmountScheduleLeg2DTCC())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalQuantityScheduleLeg1DTCC, _that.getNotionalQuantityScheduleLeg1DTCC())) {
                return false;
            }
            return ListEquals.listEquals(this.notionalQuantityScheduleLeg2DTCC, _that.getNotionalQuantityScheduleLeg2DTCC());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.tradingCapacityOfSpecifiedPerson != null ? this.tradingCapacityOfSpecifiedPerson.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.direction != null ? this.direction.hashCode() : 0);
            _result = 31 * _result + (this.directionOfLeg1 != null ? this.directionOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.directionOfLeg2 != null ? this.directionOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.reportingSpecifiedPerson != null ? this.reportingSpecifiedPerson.hashCode() : 0);
            _result = 31 * _result + (this.dataSubmitter != null ? this.dataSubmitter.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifier != null ? this.uniqueProductIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.priorUTI != null ? this.priorUTI.hashCode() : 0);
            _result = 31 * _result + (this.priorUTIProprietary != null ? this.priorUTIProprietary.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? this.contractType.hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? this.assetClass.hashCode() : 0);
            _result = 31 * _result + (this.underlying != null ? this.underlying.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdentificationType != null ? this.underlyingIdentificationType.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOther != null ? this.underlyingIdOther.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOtherSource != null ? this.underlyingIdOtherSource.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheUnderlyingIndex != null ? this.nameOfTheUnderlyingIndex.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateOfLeg1 != null ? this.fixedRateOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.identifierOfFloatingRateOfLeg1 != null ? this.identifierOfFloatingRateOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheFloatingRateOfLeg1 != null ? this.nameOfTheFloatingRateOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.spreadOfLeg1 != null ? this.spreadOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateOfLeg2 != null ? this.fixedRateOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.identifierOfFloatingRateOfLeg2 != null ? this.identifierOfFloatingRateOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheFloatingRateOfLeg2 != null ? this.nameOfTheFloatingRateOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.spreadOfLeg2 != null ? this.spreadOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? this.optionType.hashCode() : 0);
            _result = 31 * _result + (this.optionStyle != null ? this.optionStyle.hashCode() : 0);
            _result = 31 * _result + (this.firstExerciseDate != null ? this.firstExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.swapLinkID != null ? this.swapLinkID.hashCode() : 0);
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? this.deliveryType.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency1 != null ? this.settlementCurrency1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency2 != null ? this.settlementCurrency2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.finalContractualSettlementDate != null ? this.finalContractualSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? this.cleared.hashCode() : 0);
            _result = 31 * _result + (this.centralCounterparty != null ? this.centralCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.clearingMember != null ? this.clearingMember.hashCode() : 0);
            _result = 31 * _result + (this.clearingTimestamp != null ? this.clearingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.platformIdentifier != null ? this.platformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.bookingLocation != null ? this.bookingLocation.hashCode() : 0);
            _result = 31 * _result + (this.traderLocation != null ? this.traderLocation.hashCode() : 0);
            _result = 31 * _result + (this.confirmed != null ? this.confirmed.hashCode() : 0);
            _result = 31 * _result + (this.confirmationTimestamp != null ? this.confirmationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.basketConstituents != null ? this.basketConstituents.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? this.valuationMethod.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountOfTheContractOrLeg1 != null ? this.notionalAmountOfTheContractOrLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrencyOfTheContractOrLeg1 != null ? this.notionalCurrencyOfTheContractOrLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountOfLeg2 != null ? this.notionalAmountOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrencyOfLeg2 != null ? this.notionalCurrencyOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantityOfTheContractOrLeg1 != null ? this.totalNotionalQuantityOfTheContractOrLeg1.hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasureForTheContractOrLeg1 != null ? this.quantityUnitOfMeasureForTheContractOrLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityOfTheContractOrLeg1 != null ? this.notionalQuantityOfTheContractOrLeg1.hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequencyOfTheContractOrLeg1 != null ? this.quantityFrequencyOfTheContractOrLeg1.hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequencyMultiplierOfTheContractOrLeg1 != null ? this.quantityFrequencyMultiplierOfTheContractOrLeg1.hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantityLeg2 != null ? this.totalNotionalQuantityLeg2.hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasureLeg2 != null ? this.quantityUnitOfMeasureLeg2.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityOfLeg2 != null ? this.notionalQuantityOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequencyOfLeg2 != null ? this.quantityFrequencyOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequencyMultiplierOfLeg2 != null ? this.quantityFrequencyMultiplierOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.callAmount != null ? this.callAmount.hashCode() : 0);
            _result = 31 * _result + (this.callCurrency != null ? this.callCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.putAmount != null ? this.putAmount.hashCode() : 0);
            _result = 31 * _result + (this.putCurrency != null ? this.putCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.priceUnitOfMeasure != null ? this.priceUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.priceSchedule != null ? this.priceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceSchedule != null ? this.strikePriceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumAmount != null ? this.optionPremiumAmount.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumCurrency != null ? this.optionPremiumCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRateBasis != null ? this.exchangeRateBasis.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateDayCountConventionOfLeg1 != null ? this.fixedRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRateDayCountConventionOfLeg2 != null ? this.fixedRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDayCountConventionOfLeg1 != null ? this.floatingRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDayCountConventionOfLeg2 != null ? this.floatingRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodOfLeg1 != null ? this.floatingRateResetFrequencyPeriodOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodMultiplierOfLeg1 != null ? this.floatingRateResetFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodOfLeg2 != null ? this.floatingRateResetFrequencyPeriodOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodMultiplierOfLeg2 != null ? this.floatingRateResetFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodOfLeg1 != null ? this.fixedRatePaymentFrequencyPeriodOfLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 != null ? this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodOfLeg2 != null ? this.fixedRatePaymentFrequencyPeriodOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 != null ? this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodOfLeg1 != null ? this.floatingRatePaymentFrequencyPeriodOfLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 != null ? this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodOfLeg2 != null ? this.floatingRatePaymentFrequencyPeriodOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 != null ? this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.otherPayment != null ? this.otherPayment.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? this.actionType.hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? this.eventType.hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.nonReportable != null ? this.nonReportable.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2Name != null ? this.counterparty2Name.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfCounterparty1 != null ? this.executionAgentOfCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfCounterparty2DTCC != null ? this.executionAgentOfCounterparty2DTCC.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountScheduleLeg1DTCC != null ? this.notionalAmountScheduleLeg1DTCC.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountScheduleLeg2DTCC != null ? this.notionalAmountScheduleLeg2DTCC.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityScheduleLeg1DTCC != null ? this.notionalQuantityScheduleLeg1DTCC.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityScheduleLeg2DTCC != null ? this.notionalQuantityScheduleLeg2DTCC.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MASTransactionReport {counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", tradingCapacityOfSpecifiedPerson=" + String.valueOf(this.tradingCapacityOfSpecifiedPerson) + ", direction=" + this.direction + ", directionOfLeg1=" + this.directionOfLeg1 + ", directionOfLeg2=" + this.directionOfLeg2 + ", reportingSpecifiedPerson=" + this.reportingSpecifiedPerson + ", dataSubmitter=" + this.dataSubmitter + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", priorUTI=" + this.priorUTI + ", priorUTIProprietary=" + this.priorUTIProprietary + ", contractType=" + this.contractType + ", assetClass=" + this.assetClass + ", underlying=" + this.underlying + ", underlyingIdentificationType=" + this.underlyingIdentificationType + ", underlyingIdOther=" + this.underlyingIdOther + ", underlyingIdOtherSource=" + this.underlyingIdOtherSource + ", nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", fixedRateOfLeg1=" + String.valueOf(this.fixedRateOfLeg1) + ", identifierOfFloatingRateOfLeg1=" + this.identifierOfFloatingRateOfLeg1 + ", nameOfTheFloatingRateOfLeg1=" + this.nameOfTheFloatingRateOfLeg1 + ", spreadOfLeg1=" + String.valueOf(this.spreadOfLeg1) + ", fixedRateOfLeg2=" + String.valueOf(this.fixedRateOfLeg2) + ", identifierOfFloatingRateOfLeg2=" + this.identifierOfFloatingRateOfLeg2 + ", nameOfTheFloatingRateOfLeg2=" + this.nameOfTheFloatingRateOfLeg2 + ", spreadOfLeg2=" + String.valueOf(this.spreadOfLeg2) + ", optionType=" + this.optionType + ", optionStyle=" + this.optionStyle + ", firstExerciseDate=" + String.valueOf(this.firstExerciseDate) + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", expirationDate=" + String.valueOf(this.expirationDate) + ", swapLinkID=" + this.swapLinkID + ", packageIdentifier=" + this.packageIdentifier + ", deliveryType=" + this.deliveryType + ", settlementCurrency1=" + String.valueOf(this.settlementCurrency1) + ", settlementCurrency2=" + String.valueOf(this.settlementCurrency2) + ", finalContractualSettlementDate=" + String.valueOf(this.finalContractualSettlementDate) + ", cleared=" + this.cleared + ", centralCounterparty=" + this.centralCounterparty + ", clearingMember=" + this.clearingMember + ", clearingTimestamp=" + String.valueOf(this.clearingTimestamp) + ", platformIdentifier=" + this.platformIdentifier + ", bookingLocation=" + this.bookingLocation + ", traderLocation=" + this.traderLocation + ", confirmed=" + this.confirmed + ", confirmationTimestamp=" + String.valueOf(this.confirmationTimestamp) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", basketConstituents=" + String.valueOf(this.basketConstituents) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf(this.valuationMethod) + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", notionalAmountOfTheContractOrLeg1=" + String.valueOf(this.notionalAmountOfTheContractOrLeg1) + ", notionalCurrencyOfTheContractOrLeg1=" + String.valueOf(this.notionalCurrencyOfTheContractOrLeg1) + ", notionalAmountOfLeg2=" + String.valueOf(this.notionalAmountOfLeg2) + ", notionalCurrencyOfLeg2=" + String.valueOf(this.notionalCurrencyOfLeg2) + ", totalNotionalQuantityOfTheContractOrLeg1=" + String.valueOf(this.totalNotionalQuantityOfTheContractOrLeg1) + ", quantityUnitOfMeasureForTheContractOrLeg1=" + this.quantityUnitOfMeasureForTheContractOrLeg1 + ", notionalQuantityOfTheContractOrLeg1=" + String.valueOf(this.notionalQuantityOfTheContractOrLeg1) + ", quantityFrequencyOfTheContractOrLeg1=" + this.quantityFrequencyOfTheContractOrLeg1 + ", quantityFrequencyMultiplierOfTheContractOrLeg1=" + this.quantityFrequencyMultiplierOfTheContractOrLeg1 + ", totalNotionalQuantityLeg2=" + String.valueOf(this.totalNotionalQuantityLeg2) + ", quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", notionalQuantityOfLeg2=" + String.valueOf(this.notionalQuantityOfLeg2) + ", quantityFrequencyOfLeg2=" + this.quantityFrequencyOfLeg2 + ", quantityFrequencyMultiplierOfLeg2=" + this.quantityFrequencyMultiplierOfLeg2 + ", callAmount=" + String.valueOf(this.callAmount) + ", callCurrency=" + String.valueOf(this.callCurrency) + ", putAmount=" + String.valueOf(this.putAmount) + ", putCurrency=" + String.valueOf(this.putCurrency) + ", price=" + String.valueOf(this.price) + ", priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", priceSchedule=" + String.valueOf(this.priceSchedule) + ", strikePrice=" + String.valueOf(this.strikePrice) + ", strikePriceSchedule=" + String.valueOf(this.strikePriceSchedule) + ", optionPremiumAmount=" + String.valueOf(this.optionPremiumAmount) + ", optionPremiumCurrency=" + String.valueOf(this.optionPremiumCurrency) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + ", exchangeRateBasis=" + this.exchangeRateBasis + ", fixedRateDayCountConventionOfLeg1=" + String.valueOf(this.fixedRateDayCountConventionOfLeg1) + ", fixedRateDayCountConventionOfLeg2=" + String.valueOf(this.fixedRateDayCountConventionOfLeg2) + ", floatingRateDayCountConventionOfLeg1=" + String.valueOf(this.floatingRateDayCountConventionOfLeg1) + ", floatingRateDayCountConventionOfLeg2=" + String.valueOf(this.floatingRateDayCountConventionOfLeg2) + ", floatingRateResetFrequencyPeriodOfLeg1=" + this.floatingRateResetFrequencyPeriodOfLeg1 + ", floatingRateResetFrequencyPeriodMultiplierOfLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierOfLeg1 + ", floatingRateResetFrequencyPeriodOfLeg2=" + this.floatingRateResetFrequencyPeriodOfLeg2 + ", floatingRateResetFrequencyPeriodMultiplierOfLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierOfLeg2 + ", fixedRatePaymentFrequencyPeriodOfLeg1=" + String.valueOf(this.fixedRatePaymentFrequencyPeriodOfLeg1) + ", fixedRatePaymentFrequencyPeriodMultiplierOfLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 + ", fixedRatePaymentFrequencyPeriodOfLeg2=" + String.valueOf(this.fixedRatePaymentFrequencyPeriodOfLeg2) + ", fixedRatePaymentFrequencyPeriodMultiplierOfLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 + ", floatingRatePaymentFrequencyPeriodOfLeg1=" + String.valueOf(this.floatingRatePaymentFrequencyPeriodOfLeg1) + ", floatingRatePaymentFrequencyPeriodMultiplierOfLeg1=" + (this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 + ", floatingRatePaymentFrequencyPeriodOfLeg2=" + String.valueOf(this.floatingRatePaymentFrequencyPeriodOfLeg2) + ", floatingRatePaymentFrequencyPeriodMultiplierOfLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 + ", otherPayment=" + String.valueOf(this.otherPayment) + ", actionType=" + this.actionType + ", eventType=" + this.eventType + ", eventDate=" + String.valueOf(this.eventDate) + ", nonReportable=" + String.valueOf(this.nonReportable) + ", technicalRecordId=" + this.technicalRecordId + ", counterparty2Name=" + this.counterparty2Name + ", executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 + ", executionAgentOfCounterparty2DTCC=" + this.executionAgentOfCounterparty2DTCC + ", notionalAmountScheduleLeg1DTCC=" + String.valueOf(this.notionalAmountScheduleLeg1DTCC) + ", notionalAmountScheduleLeg2DTCC=" + String.valueOf(this.notionalAmountScheduleLeg2DTCC) + ", notionalQuantityScheduleLeg1DTCC=" + String.valueOf(this.notionalQuantityScheduleLeg1DTCC) + ", notionalQuantityScheduleLeg2DTCC=" + String.valueOf(this.notionalQuantityScheduleLeg2DTCC) + "}");
        }
    }
}

