/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.reports.CDECallCurrencyRule;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=CallCurrencyRuleDefault.class)
public abstract class CallCurrencyRule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected CDECallCurrencyRule cDECallCurrencyRule;
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected IsAllowableActionForMAS isAllowableActionForMAS;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class CallCurrencyRuleDefault
    extends CallCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForMAS.evaluate((ReportableEvent)item.get()));
            MapperC thenArg1 = MapperC.of(this.cDECallCurrencyRule.evaluate((TransactionReportInstruction)thenArg0.get()).stream().map(string -> FieldWithMetaString.builder().setValue((String)string).build()).collect(Collectors.toList()));
            MapperC thenArg2 = thenArg1.mapItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            });
            output = (ISOCurrencyCodeEnum)MapperS.of((Object)((ISOCurrencyCodeEnum)thenArg2.get())).get();
            return output;
        }
    }
}

