/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOne18Rate;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.reports.CDEExchangeRateRule;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=ExchangeRateRuleDefault.class)
public abstract class ExchangeRateRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected CDEExchangeRateRule cDEExchangeRateRule;
    @Inject
    protected FormatToBaseOne18Rate formatToBaseOne18Rate;
    @Inject
    protected IsAllowableActionForMAS isAllowableActionForMAS;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class ExchangeRateRuleDefault
    extends ExchangeRateRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForMAS.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = MapperS.of((Object)this.cDEExchangeRateRule.evaluate((TransactionReportInstruction)thenArg0.get()));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> item.map("getValue", priceSchedule -> priceSchedule.getValue()));
            output = (BigDecimal)MapperS.of((Object)this.formatToBaseOne18Rate.evaluate((BigDecimal)thenArg2.get())).get();
            return output;
        }
    }
}

