/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.GetPriceNotation;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.reports.CDESpread_CommodityRule;
import drr.standards.iosco.cde.reports.CDESpread_InterestRateRule;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;

@ImplementedBy(value=SpreadCurrencyOfLeg2RuleDefault.class)
public abstract class SpreadCurrencyOfLeg2Rule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected CDESpread_CommodityRule cDESpread_CommodityRule;
    @Inject
    protected CDESpread_InterestRateRule cDESpread_InterestRateRule;
    @Inject
    protected CommodityLeg2 commodityLeg2;
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected GetPriceNotation getPriceNotation;
    @Inject
    protected InterestRateLeg2 interestRateLeg2;
    @Inject
    protected IsAllowableActionForMAS isAllowableActionForMAS;
    @Inject
    protected IsCommoditySwap isCommoditySwap;
    @Inject
    protected IsIRSwaption isIRSwaption;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class SpreadCurrencyOfLeg2RuleDefault
    extends SpreadCurrencyOfLeg2Rule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForMAS.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> {
                Boolean boolean0 = this.isIRSwaption.evaluate((Product)item.get());
                if (boolean0 != null && boolean0.booleanValue()) {
                    return MapperS.of((Object)this.cDESpread_InterestRateRule.evaluate(this.interestRateLeg2.evaluate(this.underlierForProduct.evaluate((Product)item.get()))));
                }
                Boolean boolean1 = this.isCommoditySwap.evaluate((Product)item.get());
                if (boolean1 != null && boolean1.booleanValue()) {
                    return MapperS.of((Object)this.cDESpread_CommodityRule.evaluate(this.commodityLeg2.evaluate((Product)item.get())));
                }
                return MapperS.of((Object)this.cDESpread_InterestRateRule.evaluate(this.interestRateLeg2.evaluate((Product)item.get())));
            });
            MapperS thenArg3 = thenArg2.mapSingleToItem(item -> item.map("getPrice", spreadSchedule -> spreadSchedule.getPrice()));
            MapperS thenArg4 = thenArg3.mapSingleToItem(item -> {
                ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule0 = (ReferenceWithMetaPriceSchedule)item.get();
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)this.getPriceNotation.evaluate(referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("Type coercion", referenceWithMetaPriceSchedule1 -> referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
                }
                return MapperS.ofNull();
            });
            output = (ISOCurrencyCodeEnum)thenArg4.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

