/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.functions;

import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.template.ForwardPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=CDEEquityForwardNotionalDefault.class)
public abstract class CDEEquityForwardNotional
implements RosettaFunction {
    public BigDecimal evaluate(List<? extends ForwardPayout> forwardPayout) {
        BigDecimal amount = this.doEvaluate(forwardPayout);
        return amount;
    }

    protected abstract BigDecimal doEvaluate(List<? extends ForwardPayout> var1);

    protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity(List<? extends ForwardPayout> var1);

    protected abstract MapperS<BigDecimal> multipliedQuantity(List<? extends ForwardPayout> var1);

    public static class CDEEquityForwardNotionalDefault
    extends CDEEquityForwardNotional {
        @Override
        protected BigDecimal doEvaluate(List<? extends ForwardPayout> forwardPayout) {
            if (forwardPayout == null) {
                forwardPayout = Collections.emptyList();
            }
            BigDecimal amount = null;
            return this.assignOutput(amount, forwardPayout);
        }

        protected BigDecimal assignOutput(BigDecimal amount, List<? extends ForwardPayout> forwardPayout) {
            if (ExpressionOperators.exists((Mapper)this.quantity(forwardPayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                amount = (BigDecimal)this.multipliedQuantity(forwardPayout).get();
            } else if (ExpressionOperators.exists((Mapper)this.quantity(forwardPayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = (ReferenceWithMetaPriceSchedule)MapperC.of(forwardPayout).map("getPriceQuantity", _forwardPayout -> _forwardPayout.getPriceQuantity()).mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).get();
                amount = (BigDecimal)MapperMaths.multiply(this.multipliedQuantity(forwardPayout), (Mapper)(referenceWithMetaPriceSchedule == null ? MapperS.ofNull() : MapperS.of((Object)referenceWithMetaPriceSchedule.getValue())).map("getValue", priceSchedule -> priceSchedule.getValue())).get();
            } else {
                amount = null;
            }
            return amount;
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity(List<? extends ForwardPayout> forwardPayout) {
            return MapperS.of((Object)((ForwardPayout)MapperC.of(forwardPayout).get())).map("getPriceQuantity", _forwardPayout -> _forwardPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
        }

        @Override
        protected MapperS<BigDecimal> multipliedQuantity(List<? extends ForwardPayout> forwardPayout) {
            if (ExpressionOperators.exists((Mapper)this.quantity(forwardPayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperMaths.multiply((Mapper)this.quantity(forwardPayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)this.quantity(forwardPayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier()).map("getValue", measure -> measure.getValue()));
            }
            return this.quantity(forwardPayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
        }
    }
}

