/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetActionType;
import drr.regulation.common.functions.IsActionTypePRTO;
import javax.inject.Inject;

@ImplementedBy(value=CDEActionTypeRuleDefault.class)
public abstract class CDEActionTypeRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected GetActionType getActionType;
    @Inject
    protected IsActionTypePRTO isActionTypePRTO;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class CDEActionTypeRuleDefault
    extends CDEActionTypeRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            output = (String)MapperS.of((Object)input).mapSingleToItem(item -> {
                Boolean _boolean = this.isActionTypePRTO.evaluate((ReportableEvent)item.get());
                if (_boolean != null && _boolean.booleanValue()) {
                    return MapperS.of((Object)((Object)ActionTypeEnum.PRTO)).map("to-string", ActionTypeEnum::toDisplayString);
                }
                return MapperS.of((Object)this.getActionType.evaluate((ReportableEvent)item.get()));
            }).get();
            return output;
        }
    }
}

